package win.baruna.blockmeter.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Color;
import net.minecraft.class_10799;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8666;
import net.minecraft.client.render.*;
import win.baruna.blockmeter.BlockMeterClient;
import win.baruna.blockmeter.ModConfig;
import win.baruna.blockmeter.measurebox.ClientMeasureBox;

public class OptionsGui extends class_437 {

    public OptionsGui() {
        super(class_333.field_18967);
    }

    private final static int BUTTONWIDTH = 200;

    @Override
    protected void method_25426() {
        ModConfig config = BlockMeterClient.getConfigManager().getConfig();

        // Create Color Selector
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                final int colorIndex = i * 4 + j;
                this.method_37063(new ColorButton(this.field_22789 / 2 - 44 + j * 22,
                        this.field_22790 / 2 - 88 + i * 22, 20, 20, null,
                        Color.ofOpaque(class_1767.method_7791(colorIndex)
                                .method_7794().field_16011), config.colorIndex == colorIndex, false,
                        button -> {
                            ClientMeasureBox.setColorIndex(colorIndex);

                            final ClientMeasureBox currentBox = BlockMeterClient.getInstance().getCurrentBox();
                            if (currentBox != null)
                                currentBox.setColor(class_1767.method_7791(colorIndex));
                            class_310.method_1551().method_1507(null);
                        }));
            }
        }

        this.method_37063(new class_4185.class_7840(
                class_2561.method_43469("blockmeter.keepColor", class_2561.method_43471(config.incrementColor ? "options.off" :
                        "options.on")), button -> {
            config.incrementColor = !config.incrementColor;
            class_310.method_1551().method_1507(null);
            // Todo find a way to increment to a new Color if a box was created while
            // incrementColor was disabled
            BlockMeterClient.getConfigManager().save();
        })
                .method_46433(this.field_22789 / 2 - BUTTONWIDTH / 2, this.field_22790 / 2 + 10)
                .method_46437(BUTTONWIDTH, 20)
                .method_46431());

        this.method_37063(new class_4185.class_7840(class_2561.method_43469("blockmeter.diagonal",
                class_2561.method_43471(config.innerDiagonal ? "options.on" : "options.off")), button -> {
            System.err.println("IDK WHAT YOU ARE DOING");
            config.innerDiagonal = !config.innerDiagonal;
            class_310.method_1551().method_1507(null);
            BlockMeterClient.getConfigManager().save();
        })
                .method_46433(this.field_22789 / 2 - BUTTONWIDTH / 2, this.field_22790 / 2 + 32)
                .method_46437(BUTTONWIDTH, 20)
                .method_46431());

        this.method_37063(new class_4185.class_7840(class_2561.method_43469("blockmeter.showOthers",
                class_2561.method_43471(config.showOtherUsersBoxes ? "options.on" : "options.off")), button -> {
            System.err.println("IDK WHAT YOU ARE DOING");
            config.showOtherUsersBoxes = !config.showOtherUsersBoxes;
            class_310.method_1551().method_1507(null);
            BlockMeterClient.getConfigManager().save();
        })
                .method_46433(this.field_22789 / 2 - BUTTONWIDTH / 2, this.field_22790 / 2 + 54)
                .method_46437(BUTTONWIDTH, 20)
                .method_46431());
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
//        super.renderBackground(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

}

class ColorButton extends class_4185 {
    Color color;
    int x;
    int y;
    int width;
    int height;
    boolean selected;
    boolean texture;
    class_5250 text;
    private static final class_8666 TEXTURES = new class_8666(
            class_2960.method_60656("widget/button"), class_2960.method_60656("widget/button_disabled"), class_2960.method_60656("widget/button_highlighted")
    );

    @Override
    public void method_25306() {
        System.out.println(color.getRed());
        System.out.println(color.getGreen());
        System.out.println(color.getBlue());
        System.err.println("IK WHAT YOU ARE DOING");
        super.method_25306();
    }

    ColorButton(final int x, final int y, final int width, final int height, final class_5250 label, final Color color,
                final boolean selected, boolean texture, class_4241 onPress) {
        super(x, y, width, height, class_2561.method_43470(""), onPress, field_40754);
        this.selected = false;
        this.color = color;
        this.x = x + 2;
        this.y = y + 2;
        this.field_22758 = width - 4;
        this.field_22759 = height - 4;
        this.method_25365(selected);
        this.selected = selected;
        this.text = label;
        this.texture = texture;
        // this.color = Color.ofRGBA(0.5f, 1f, 1f, 1f);
    }

    @Override
    public void method_48579(class_332 context, final int int_1, final int int_2, final float float_1) {

        context.method_52707(
                class_10799.field_56883,
                TEXTURES.method_52729(this.field_22763, this.method_25367()),
                x, y, field_22758, field_22759, color.getColor()
        );
//        Tessellator tessellator = Tessellator.getInstance();
//        var bufferBuilder = tessellator.begin(VertexFormat.DrawMode.QUADS, VertexFormats.POSITION_COLOR);
//        RenderSystem.setShader(ShaderProgramKeys.POSITION_COLOR);
//
//        int r = this.color.getRed();
//        int g = this.color.getGreen();
//        int b = this.color.getBlue();
//        int a = texture ? 102 : 255;
//        bufferBuilder.vertex(this.x - (texture ? 1 : 0), this.y - (texture ? 1 : 0), 0f)
//                .color(r, g, b, a);
//        bufferBuilder.vertex(this.x - (texture ? 1 : 0), this.y + this.height + (texture ? 1 : 0), 0f)
//                .color(r, g, b, a);
//        bufferBuilder.vertex(this.x + this.width + (texture ? 1 : 0), this.y + this.height + (texture ? 1 : 0), 0f)
//                .color(r, g, b, a);
//        bufferBuilder.vertex(this.x + this.width + (texture ? 1 : 0), this.y - (texture ? 1 : 0), 0f)
//                .color(r, g, b, a);
//        BufferRenderer.drawWithGlobalProgram(bufferBuilder.end());

        if (text != null) {
            boolean dark = (0.299f * color.getRed() + 0.587f * color.getBlue() + 0.114f * color.getRed()) / 255f < 0.8f;

            final class_327 textRenderer = class_310.method_1551().field_1772;
            int text_width = textRenderer.method_27525(text);
            if (dark || texture)
                context.method_51430(textRenderer, text.method_30937(), x + field_22758 / 2 - text_width / 2,
                        y + field_22759 / 2 - 4, 0xFFFFFF, true);
            else {
                // shadow
                context.method_51439(textRenderer, text, x + field_22758 / 2 - text_width / 2 + 1, y + field_22759 / 2 - 3, 0xAAAAAA
                        , false);
                context.method_51439(textRenderer, text, x + field_22758 / 2 - text_width / 2, y + field_22759 / 2 - 4, 0, false);
            }
        }
    }
}
