package win.baruna.blockmeter.measurebox;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_10799;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3341;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_7833;
import net.minecraft.class_9799;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import win.baruna.blockmeter.BlockMeterClient;
import win.baruna.blockmeter.ModConfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;

import static net.minecraft.class_10799.field_56860;

public class ClientMeasureBox extends MeasureBox {
    private static final class_1921.class_4687 DEBUG_LINE_STRIP = class_1921.method_24048(
            "debug_line_strip_no_depth",
            1536,
            class_10799.method_67887(
                    RenderPipeline.builder(field_56860)
                            .withLocation("pipeline/debug_line_strip")
                            .withVertexShader("core/position_color")
                            .withFragmentShader("core/position_color")
                            .withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST)
                            .withCull(false)
                            .withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_29345)
                            .build()
            ),
            class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(4.0))).method_23617(false)

    );
    private static final class_1921.class_4687 DEBUG_QUADS = class_1921.method_24049(
            "debug_quads_no_depth", 1536, false, true, class_10799.method_67887(
                    RenderPipeline.builder(field_56860).withLocation("pipeline/debug_quads").withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build()
            ), class_1921.class_4688.method_23598().method_23617(false)
    );
    @NotNull
    public MiningRestriction miningRestriction;
    private class_238 box;
    private int argb;

    protected ClientMeasureBox(final class_2338 blockStart, final class_2338 blockEnd, final class_2960 dimension,
                               final class_1767 color, final boolean finished, final int mode, final int orientation) {
        super(blockStart, blockEnd, dimension, color, finished, mode, orientation);
        miningRestriction = MiningRestriction.Off;
        argb = color.method_7787() | 0xFF000000;
        updateBoundingBox();
    }

    public ClientMeasureBox(MeasureBox measureBox) {
        this(measureBox.blockStart, measureBox.blockEnd, measureBox.dimension, measureBox.color, measureBox.finished,
                measureBox.mode, measureBox.orientation);
    }

    public static ClientMeasureBox getBox(final class_2338 block, final class_2960 dimension) {
        final ClientMeasureBox box = new ClientMeasureBox(block, block, dimension, getSelectedColor(), false, 0, 0);
        incrementColor();
        return box;
    }

    /**
     * If enabled increments to next color
     */
    static private void incrementColor() {
        final ModConfig conf = BlockMeterClient.getConfigManager().getConfig();

        if (conf.incrementColor) {
            setColorIndex(conf.colorIndex + 1);
        }
    }

    /**
     * Accessor for the currently selected color
     *
     * @return currently selected color
     */
    static private class_1767 getSelectedColor() {
        final ModConfig conf = BlockMeterClient.getConfigManager().getConfig();
        return class_1767.method_7791(conf.colorIndex);
    }

    public static void setColorIndex(final int newColor) {
        BlockMeterClient.getConfigManager().getConfig().colorIndex = Math.floorMod(newColor, class_1767.values().length);
        BlockMeterClient.getConfigManager().save();
    }

    /**
     * Sets the second box corner
     *
     * @param block second corner position
     */
    public void setBlockEnd(final class_2338 block) {
        blockEnd = block;
        updateBoundingBox();
    }

    /**
     * The current creation state of the MeasureBox
     *
     * @return true if MeasureBox is completed
     */
    public boolean isFinished() {
        return this.finished;
    }

    /**
     * Marks Box to be complete
     */
    public void setFinished() {
        this.finished = true;
    }

    /**
     * Sets the Color of the MeasureBox
     *
     * @param color Color to be applied
     */
    public void setColor(final class_1767 color) {
        this.color = color;
        this.argb = color.method_7787() | 0xFF000000;
    }

    /**
     * Tests if the block is on a corner of the box
     *
     * @param block Position to test
     * @return true if block is a corner
     */
    public boolean isCorner(final class_2338 block) {
        return (block.method_10263() == blockStart.method_10263() || block.method_10263() == blockEnd.method_10263())
                && (block.method_10264() == blockStart.method_10264() || block.method_10264() == blockEnd.method_10264())
                && (block.method_10260() == blockStart.method_10260() || block.method_10260() == blockEnd.method_10260());
    }

    /**
     * Loosens the selected Corner i.e. the opposite corner gets fixed, and the
     * current one can be moved
     *
     * @param block The corner to loosen, needs to be an actual corner of the box
     */
    public void loosenCorner(final class_2338 block) {
        final int x = blockStart.method_10263() == block.method_10263() ? blockEnd.method_10263() : blockStart.method_10263();
        final int y = blockStart.method_10264() == block.method_10264() ? blockEnd.method_10264() : blockStart.method_10264();
        final int z = blockStart.method_10260() == block.method_10260() ? blockEnd.method_10260() : blockStart.method_10260();
        blockStart = new class_2338(x, y, z);
        blockEnd = block;
        finished = false;
    }

    public void render(final WorldRenderContext context, final class_2960 currentDimension) {
        render(context, currentDimension, null);
    }

    public void render(final WorldRenderContext context, final class_2960 currentDimension,
                       final class_2561 boxCreatorName) {
        if (!(currentDimension.equals(this.dimension))) {
            return;
        }
        final class_243 pos = context.camera().method_19326();
        var stack = context.matrixStack();
        var buffer = context.consumers().getBuffer(DEBUG_LINE_STRIP);

        stack.method_22903();
        stack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        final Matrix4f model = stack.method_23760().method_23761();

        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1322, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1322, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1322, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1322, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1322, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1325, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1325, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1325, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1325, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1325, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1325, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1325, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1322, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1322, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1325, (float) this.box.field_1324).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1325, (float) this.box.field_1321).method_39415(argb);
        buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1322, (float) this.box.field_1321).method_39415(argb);

        if (BlockMeterClient.getConfigManager().getConfig().innerDiagonal) {
            buffer = context.consumers().getBuffer(DEBUG_LINE_STRIP);
            buffer.method_22918(model, (float) this.box.field_1323, (float) this.box.field_1322, (float) this.box.field_1321).method_39415(argb);
            buffer.method_22918(model, (float) this.box.field_1320, (float) this.box.field_1325, (float) this.box.field_1324).method_39415(argb);
        }

        this.drawLengths(context, boxCreatorName);

        stack.method_22909();
    }

    /**
     * Calculates the BoundingBox for rendering
     */
    private void updateBoundingBox() {
        final int ax = this.blockStart.method_10263();
        final int ay = this.blockStart.method_10264();
        final int az = this.blockStart.method_10260();
        final int bx = this.blockEnd.method_10263();
        final int by = this.blockEnd.method_10264();
        final int bz = this.blockEnd.method_10260();

        this.box = new class_238(Math.min(ax, bx), Math.min(ay, by), Math.min(az, bz),
                Math.max(ax, bx) + 1, Math.max(ay, by) + 1, Math.max(az, bz) + 1);

    }

    private void drawLengths(final WorldRenderContext context, final class_2561 boxCreatorName) {
        final int lengthX = (int) this.box.method_17939();
        final int lengthY = (int) this.box.method_17940();
        final int lengthZ = (int) this.box.method_17941();

        final class_243 boxCenter = this.box.method_1005();
        final double diagonalLength = new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321)
                .method_1022(new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324));

        var camera = context.camera();
        final float yaw = camera.method_19330();
        final float pitch = camera.method_19329();
        final class_243 pos = camera.method_19326();

        final List<Line> lines = new ArrayList<>();
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1321, this.box.field_1323, this.box.field_1322, this.box.field_1324),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1325, this.box.field_1321, this.box.field_1323, this.box.field_1325, this.box.field_1324),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1320, this.box.field_1322, this.box.field_1321, this.box.field_1320, this.box.field_1322, this.box.field_1324),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1320, this.box.field_1325, this.box.field_1321, this.box.field_1320, this.box.field_1325, this.box.field_1324),
                pos));
        Collections.sort(lines);
        final class_243 lineZ = lines.get(0).line.method_1005();

        lines.clear();
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1321, this.box.field_1323, this.box.field_1325, this.box.field_1321),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1324, this.box.field_1323, this.box.field_1325, this.box.field_1324),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1320, this.box.field_1322, this.box.field_1321, this.box.field_1320, this.box.field_1325, this.box.field_1321),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1320, this.box.field_1322, this.box.field_1324, this.box.field_1320, this.box.field_1325, this.box.field_1324),
                pos));
        Collections.sort(lines);
        final class_243 lineY = lines.get(0).line.method_1005();

        lines.clear();
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1321, this.box.field_1320, this.box.field_1322, this.box.field_1321),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1324, this.box.field_1320, this.box.field_1322, this.box.field_1324),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1325, this.box.field_1321, this.box.field_1320, this.box.field_1325, this.box.field_1321),
                pos));
        lines.add(new Line(
                new class_238(this.box.field_1323, this.box.field_1325, this.box.field_1324, this.box.field_1320, this.box.field_1325, this.box.field_1324),
                pos));
        Collections.sort(lines);
        final class_243 lineX = lines.get(0).line.method_1005();

        final String playerNameStr = (boxCreatorName == null ? "" : boxCreatorName.getString() + " : ");

        if (BlockMeterClient.getConfigManager().getConfig().innerDiagonal) {
            this.drawBackground(context, boxCenter.field_1352, boxCenter.field_1351, boxCenter.field_1350, yaw, pitch,
                    playerNameStr + String.format("%.2f", diagonalLength), pos);
        }
        this.drawBackground(context, lineZ.field_1352, lineZ.field_1351, lineZ.field_1350, yaw, pitch, playerNameStr + lengthZ, pos);
        this.drawBackground(context, lineX.field_1352, lineX.field_1351, lineX.field_1350, yaw, pitch, playerNameStr + lengthX, pos);
        this.drawBackground(context, lineY.field_1352, lineY.field_1351, lineY.field_1350, yaw, pitch, playerNameStr + lengthY, pos);

        if (BlockMeterClient.getConfigManager().getConfig().innerDiagonal) {
            this.drawText(context, boxCenter.field_1352, boxCenter.field_1351, boxCenter.field_1350, yaw, pitch,
                    playerNameStr + String.format("%.2f", diagonalLength), pos);
        }
        this.drawText(context, lineZ.field_1352, lineZ.field_1351, lineZ.field_1350, yaw, pitch, playerNameStr + lengthZ, pos);
        this.drawText(context, lineX.field_1352, lineX.field_1351, lineX.field_1350, yaw, pitch, playerNameStr + lengthX, pos);
        this.drawText(context, lineY.field_1352, lineY.field_1351, lineY.field_1350, yaw, pitch, playerNameStr + lengthY, pos);
    }

    private void drawBackground(final WorldRenderContext context, final double x, final double y, final double z,
                                final float yaw,
                                final float pitch, final String text, final class_243 playerPos) {
        // TODO figure this out
//        final TextRenderer textRenderer = MinecraftClient.getInstance().textRenderer;
//
//        final var literalText = Text.literal(text);
//
//        float size = 0.03f;
//        final int constDist = 10;
//
//        if (AutoConfig.getConfigHolder(ModConfig.class).getConfig().minimalLabelSize) {
//            final float dist = (float) Math.sqrt((x - playerPos.x) * (x - playerPos.x)
//                    + (y - playerPos.y) * (y - playerPos.y) + (z - playerPos.z) * (z - playerPos.z));
//            if (dist > constDist)
//                size = dist * size / constDist;
//        }
//
//        var stack = context.matrixStack();
//        stack.push();
//        stack.translate(x, y + 0.15, z);
//        stack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(180.0F - yaw));
//        stack.multiply(RotationAxis.POSITIVE_X.rotationDegrees(-pitch));
//        stack.scale(size, -size, 0.001f);
//        final int width = textRenderer.getWidth(literalText);
//        stack.translate((-width / 2f), 0.0, 0.0);
//        final Matrix4f model = stack.peek().getPositionMatrix();
//
//        final ModConfig conf = BlockMeterClient.getConfigManager().getConfig();
//        if (conf.backgroundForLabels) {
//            var buffer = context.consumers().getBuffer(DEBUG_QUADS);
//            buffer.vertex(model, -1, -1, 0).color(argb);
//            buffer.vertex(model, -1, 8, 0).color(argb);
//            buffer.vertex(model, width, 8, 0).color(argb);
//            buffer.vertex(model, width, -1, 0).color(argb);
//        }
//
//        stack.pop();
    }

    private void drawText(final WorldRenderContext context, final double x, final double y, final double z,
                          final float yaw,
                          final float pitch, final String text, final class_243 playerPos) {
        final class_327 textRenderer = class_310.method_1551().field_1772;

        final var literalText = class_2561.method_43470(text);

        float size = 0.03f;
        final int constDist = 10;

        if (AutoConfig.getConfigHolder(ModConfig.class).getConfig().minimalLabelSize) {
            final float dist = (float) Math.sqrt((x - playerPos.field_1352) * (x - playerPos.field_1352)
                    + (y - playerPos.field_1351) * (y - playerPos.field_1351) + (z - playerPos.field_1350) * (z - playerPos.field_1350));
            if (dist > constDist)
                size = dist * size / constDist;
        }

        var stack = context.matrixStack();
        stack.method_22903();
        stack.method_22904(x, y + 0.15, z);
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0F - yaw));
        stack.method_22907(class_7833.field_40714.rotationDegrees(-pitch));
        stack.method_22905(size, -size, 0.001f);
        final int width = textRenderer.method_27525(literalText);
        stack.method_22904((-width / 2f), 0.0, 0.0);
        final Matrix4f model = stack.method_23760().method_23761();

        int textColor = color.method_16357();

        final ModConfig conf = BlockMeterClient.getConfigManager().getConfig();
        // TODO figure this out
//        if (conf.backgroundForLabels) {
//            var color = new Color(argb);
//            float luminance = (0.299f * color.getRed() + 0.587f * color.getGreen() + 0.114f * color.getBlue());
//            textColor = luminance < 0.4f ? DyeColor.WHITE.getSignColor() : DyeColor.BLACK.getSignColor();
//        }

        final class_4597.class_4598 immediate = class_4597.method_22991(new class_9799(0));
        textRenderer.method_27522(
                literalText,
                0.0f,
                0.0f,
                textColor,
                !conf.backgroundForLabels, // shadow
                model, // matrix
                immediate, // draw buffer
                class_327.class_6415.field_33994,
                0, // backgroundColor => underlineColor,
                15728880 // light
        );
        immediate.method_22993();

        stack.method_22909();
    }

    public boolean contains(class_2338 block) {
        return class_3341.method_34390(blockStart, blockEnd).method_14662(block);
    }

    public enum MiningRestriction {
        Off("options.off"),
        Inside("blockmeter.restrictMining.inside"),
        Outside("blockmeter.restrictMining.outside");
        public final String translation;

        MiningRestriction(String translation) {
            this.translation = translation;
        }

        @NotNull
        public MiningRestriction next() {
            switch (this) {
                case Off -> {
                    return Inside;
                }
                case Inside -> {
                    return Outside;
                }
                case Outside -> {
                    return Off;
                }
                default -> throw new IllegalArgumentException();
            }
        }
    }

    private static class Line implements Comparable<Line> {
        class_238 line;
        double distance;

        Line(final class_238 line, final class_243 pos) {
            this.line = line;
            this.distance = line.method_1005().method_1022(pos);
        }

        @Override
        public int compareTo(final Line l) {
            return Double.compare(this.distance, l.distance);
        }
    }
}
