package win.baruna.blockmeter.measurebox;

import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class MeasureBox {

    protected class_2338 blockStart;
    protected class_2338 blockEnd;
    protected class_2960 dimension;
    protected class_1767 color;
    protected boolean finished;
    protected int mode;
    protected int orientation;

    public class_2338 getBlockStart() {
        return blockStart;
    }

    public class_2338 getBlockEnd() {
        return blockEnd;
    }

    public class_2960 getDimension() {
        return dimension;
    }

    public class_1767 getColor() {
        return color;
    }

    public boolean isFinished() {
        return finished;
    }

    protected MeasureBox(class_2338 blockStart, class_2338 blockEnd,
            class_2960 dimension, class_1767 color, boolean finished, int mode,
            int orientation) {
        this.blockStart = blockStart;
        this.blockEnd = blockEnd;
        this.dimension = dimension;
        this.color = color;
        this.finished = finished;
        this.mode = mode;
        this.orientation = orientation;
    }

    /**
     * Creates a MeasureBox from a PacketByteBuf
     *
     * @param attachedData a PacketByteBuf containing the ClientMeasureBox
     * @return the PacketByteBuf submitted
     */
    protected MeasureBox(class_2540 attachedData) {
        this.blockStart = attachedData.method_10811();
        this.blockEnd = attachedData.method_10811();
        this.dimension = attachedData.method_10810();
        this.color = class_1767.method_7791(attachedData.readInt());
        this.finished = attachedData.readBoolean();
        this.mode = attachedData.readInt();
        this.orientation = attachedData.readInt();

        if (dimension == null) {
            throw new IllegalArgumentException("invalid buffer");
        }
    }

    /**
     * Fills a PacketByteBuf with the MeasureBox
     *
     * @param buf PacketByteBuf to fill
     */
    public void writePacketBuf(class_2540 buf) {
        buf.method_10807(this.blockStart);
        buf.method_10807(this.blockEnd);
        buf.method_10812(dimension);
        buf.method_53002(color.method_7789());
        buf.method_52964(finished);
        buf.method_53002(mode);
        buf.method_53002(orientation);
    }

    /**
     * Parses a MeasureBox from a PacketByteBuf
     *
     * @param attachedData a PacketByteBuf containing the ClientMeasureBox
     * @return the PacketByteBuf submitted
     */
    public static MeasureBox fromPacketByteBuf(class_2540 attachedData) {
        return new MeasureBox(attachedData);
    }
}
