/*=====================================================================================
    👻 LUMINARA SPOOKY SHADER - HORROR CONFIGURATION
    Atmospheric Horror & Eerie Visual Effects Configuration
    إعدادات المؤثرات المرعبة والجو المخيف
    
    🎃 SPOOKY FEATURES - المميزات المخيفة:
    ✨ Dark, desaturated color palette
    ✨ Eerie fog and mist effects
    ✨ Creepy atmospheric lighting
    ✨ Enhanced shadows and darkness
    
    © 2025 VcorA - Spooky Edition
=====================================================================================*/

#ifndef LUMINARA_SPOOKY_CONFIG
#define LUMINARA_SPOOKY_CONFIG

// ═══════════════════════════════════════════════════════════════════════════════
//                         SPOOKY COLOR CONFIGURATION
// ═══════════════════════════════════════════════════════════════════════════════

// Darkness & Desaturation Multipliers
#define SPOOKY_DARKNESS_MULT 0.65        // Overall darkness (0.0 = black, 1.0 = normal)
#define SPOOKY_DESATURATION 0.55         // Color desaturation (0.0 = grayscale, 1.0 = full color)

// Eerie Color Tints
#define SPOOKY_GREEN_TINT 0.15           // Greenish tint intensity
#define SPOOKY_PURPLE_TINT 0.10          // Purple/magenta tint for night
#define SPOOKY_BLUE_TINT 0.08            // Cool blue tint

// ═══════════════════════════════════════════════════════════════════════════════
//                         ATMOSPHERIC EFFECTS
// ═══════════════════════════════════════════════════════════════════════════════

// Fog Configuration
#define SPOOKY_FOG_DENSITY 2.5           // Fog thickness multiplier
#define SPOOKY_FOG_HEIGHT 0.4            // Fog height factor
#define SPOOKY_GROUND_FOG 1.5            // Ground-level mist intensity

// Shadow Enhancement
#define SPOOKY_SHADOW_DARKNESS 1.35      // Shadow darkness multiplier
#define SPOOKY_AMBIENT_REDUCTION 0.60    // Ambient light reduction

// ═══════════════════════════════════════════════════════════════════════════════
//                         LIGHTING ADJUSTMENTS
// ═══════════════════════════════════════════════════════════════════════════════

#define SPOOKY_TORCH_FLICKER 1.2         // Torch flicker intensity
#define SPOOKY_MOONLIGHT_TINT 0.85       // Moonlight color adjustment (cooler)
#define SPOOKY_DARK_CAVES 0.45           // Cave darkness multiplier

// ═══════════════════════════════════════════════════════════════════════════════
//                         UTILITY FUNCTIONS
// ═══════════════════════════════════════════════════════════════════════════════

// Apply spooky color grading to any color
vec3 applySpookyGrading(vec3 color) {
    // Desaturate
    float luminance = dot(color, vec3(0.299, 0.587, 0.114));
    color = mix(vec3(luminance), color, SPOOKY_DESATURATION);
    
    // Apply darkness
    color *= SPOOKY_DARKNESS_MULT;
    
    // Add eerie tints
    color.g += SPOOKY_GREEN_TINT * 0.05;
    color.b += SPOOKY_BLUE_TINT * 0.03;
    
    return color;
}

// Apply spooky night color grading
vec3 applySpookyNightGrading(vec3 color, float nightFactor) {
    color = applySpookyGrading(color);
    
    // Add purple tint at night
    color.r += SPOOKY_PURPLE_TINT * 0.04 * nightFactor;
    color.b += SPOOKY_PURPLE_TINT * 0.06 * nightFactor;
    
    return color;
}

#endif // LUMINARA_SPOOKY_CONFIG
