#ifndef IPBR_COMPATIBILITY_MODE
    // Tweak to prevent the animation of lava causing brightness pulsing
    vec3 avgColor = vec3(0.0);
    ivec2 itexCoordC = ivec2(midCoord * atlasSize + 0.0001);
    for (int x = -8; x < 8; x += 2) {
        for (int y = -8; y < 8; y += 2) {
            avgColor += texelFetch(tex, itexCoordC + ivec2(x, y), 0).rgb;
        }
    }
    color.rgb /= max(GetLuminance(avgColor) * 0.0390625, 0.001);
#else
    color.rgb *= 0.86;
#endif

// Dark horror lava effect - حمم بركانية مرعبة وقاتمة
vec3 horrorLavaTint = vec3(0.8, 0.15, 0.1); // أحمر داكن مع قليل من البرتقالي
color.rgb *= horrorLavaTint * 1.2; // حمم قاتمة ومخيفة

#ifdef NETHER
    vec3 worldPos = playerPos + cameraPosition;
    vec2 lavaPos = (floor(worldPos.xz * 16.0) + worldPos.y * 32.0) * 0.000666;
    vec2 wind = vec2(frameTimeCounter * 0.012, 0.0);

    float noiseSample = texture2D(noisetex, lavaPos + wind).g;
    noiseSample = noiseSample - 0.5;
    noiseSample *= 0.15; // زيادة التموج للحمم
    color.rgb = pow(color.rgb, vec3(1.0 + noiseSample));
#endif

noDirectionalShading = true;
lmCoordM = vec2(0.0);
emission = GetLuminance(color.rgb) * 8.0; // زيادة الإضاءة للتوهج المخيف

// Luminara Shader: Intense lava emission in Nether for horror effect
#ifdef NETHER
    emission *= 0.4; // حمم متوهجة بشكل مخيف
#endif

maRecolor = vec3(clamp(pow2(pow2(pow2(smoothstep1(emission * 0.28)))), 0.12, 0.4) * 1.3) * vec3(1.0, vec2(0.7));

#if RAIN_PUDDLES >= 1
    noPuddles = 1.0;
#endif
