/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.spearsmod.client;

import com.doodle.spearsmod.client.entity.SpearEntityRenderer;
import com.doodle.spearsmod.client.item.ModItemRenderer;
import com.doodle.spearsmod.client.model.CrossSpearModel;
import com.doodle.spearsmod.client.model.SpearModel;
import com.doodle.spearsmod.init.ModEntityTypes;
import com.doodle.spearsmod.init.ModItems;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="spearsmod", value={Dist.CLIENT})
public class ClientSetup {
    private static BlockEntityWithoutLevelRenderer ITEMS_RENDERER;

    @SubscribeEvent
    public static void doSetup(FMLClientSetupEvent event) {
        EntityRenderers.register(ModEntityTypes.SPEAR.get(), SpearEntityRenderer::new);
        EntityRenderers.register(ModEntityTypes.WOODEN_SPEAR.get(), SpearEntityRenderer::new);
        EntityRenderers.register(ModEntityTypes.STONE_SPEAR.get(), SpearEntityRenderer::new);
        EntityRenderers.register(ModEntityTypes.IRON_SPEAR.get(), SpearEntityRenderer::new);
        EntityRenderers.register(ModEntityTypes.GOLDEN_SPEAR.get(), SpearEntityRenderer::new);
        EntityRenderers.register(ModEntityTypes.DIAMOND_SPEAR.get(), SpearEntityRenderer::new);
        EntityRenderers.register(ModEntityTypes.NETHERITE_SPEAR.get(), SpearEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpearModel.LAYER_LOCATION, SpearModel::createLayer);
        event.registerLayerDefinition(CrossSpearModel.LAYER_LOCATION, CrossSpearModel::createBodyLayer);
    }

    public static BlockEntityWithoutLevelRenderer getItemsRenderer() {
        if (ITEMS_RENDERER == null) {
            ITEMS_RENDERER = new ModItemRenderer();
        }
        return ITEMS_RENDERER;
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientSetup.getItemsRenderer();
            }
        }, new Item[]{ModItems.WOODEN_SPEAR.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientSetup.getItemsRenderer();
            }
        }, new Item[]{ModItems.STONE_SPEAR.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientSetup.getItemsRenderer();
            }
        }, new Item[]{ModItems.IRON_SPEAR.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientSetup.getItemsRenderer();
            }
        }, new Item[]{ModItems.GOLDEN_SPEAR.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientSetup.getItemsRenderer();
            }
        }, new Item[]{ModItems.DIAMOND_SPEAR.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientSetup.getItemsRenderer();
            }
        }, new Item[]{ModItems.NETHERITE_SPEAR.get()});
    }
}

