/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.spearsmod.client.entity;

import com.doodle.spearsmod.client.model.CrossSpearModel;
import com.doodle.spearsmod.entity.DiamondSpearEntity;
import com.doodle.spearsmod.entity.GoldenSpearEntity;
import com.doodle.spearsmod.entity.IronSpearEntity;
import com.doodle.spearsmod.entity.NetheriteSpearEntity;
import com.doodle.spearsmod.entity.StoneSpearEntity;
import com.doodle.spearsmod.entity.WoodenSpearEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SpearEntityRenderer
extends EntityRenderer<Entity> {
    private final CrossSpearModel crossModel;
    public static final ResourceLocation NETHERITE_SPEAR = ResourceLocation.parse((String)"spearsmod:textures/entity/netherite_spear.png");
    public static final ResourceLocation DIAMOND_SPEAR = ResourceLocation.parse((String)"spearsmod:textures/entity/diamond_spear.png");
    public static final ResourceLocation GOLDEN_SPEAR = ResourceLocation.parse((String)"spearsmod:textures/entity/golden_spear.png");
    public static final ResourceLocation IRON_SPEAR = ResourceLocation.parse((String)"spearsmod:textures/entity/iron_spear.png");
    public static final ResourceLocation STONE_SPEAR = ResourceLocation.parse((String)"spearsmod:textures/entity/stone_spear.png");
    public static final ResourceLocation WOODEN_SPEAR = ResourceLocation.parse((String)"spearsmod:textures/entity/wooden_spear.png");
    public static final ResourceLocation CROSS_NETHERITE = ResourceLocation.parse((String)"spearsmod:textures/entity/netherite_spear_plane.png");
    public static final ResourceLocation CROSS_DIAMOND = ResourceLocation.parse((String)"spearsmod:textures/entity/diamond_spear_plane.png");
    public static final ResourceLocation CROSS_GOLDEN = ResourceLocation.parse((String)"spearsmod:textures/entity/golden_spear_plane.png");
    public static final ResourceLocation CROSS_IRON = ResourceLocation.parse((String)"spearsmod:textures/entity/iron_spear_plane.png");
    public static final ResourceLocation CROSS_STONE = ResourceLocation.parse((String)"spearsmod:textures/entity/stone_spear_plane.png");
    public static final ResourceLocation CROSS_WOODEN = ResourceLocation.parse((String)"spearsmod:textures/entity/wooden_spear_plane.png");

    public SpearEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.crossModel = new CrossSpearModel(context.bakeLayer(CrossSpearModel.LAYER_LOCATION));
    }

    public void render(Entity spear, float f, float g, PoseStack pose, MultiBufferSource source, int i) {
        if (spear instanceof WoodenSpearEntity) {
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spear)), (boolean)false, (boolean)((WoodenSpearEntity)spear).isFoil());
            this.crossModel.renderToBuffer(pose, vertexconsumer, i, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            super.render(spear, f, g, pose, source, i);
        } else if (spear instanceof StoneSpearEntity) {
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spear)), (boolean)false, (boolean)((StoneSpearEntity)spear).isFoil());
            this.crossModel.renderToBuffer(pose, vertexconsumer, i, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            super.render(spear, f, g, pose, source, i);
        } else if (spear instanceof IronSpearEntity) {
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spear)), (boolean)false, (boolean)((IronSpearEntity)spear).isFoil());
            this.crossModel.renderToBuffer(pose, vertexconsumer, i, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            super.render(spear, f, g, pose, source, i);
        } else if (spear instanceof GoldenSpearEntity) {
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spear)), (boolean)false, (boolean)((GoldenSpearEntity)spear).isFoil());
            this.crossModel.renderToBuffer(pose, vertexconsumer, i, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            super.render(spear, f, g, pose, source, i);
        } else if (spear instanceof DiamondSpearEntity) {
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spear)), (boolean)false, (boolean)((DiamondSpearEntity)spear).isFoil());
            this.crossModel.renderToBuffer(pose, vertexconsumer, i, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            super.render(spear, f, g, pose, source, i);
        } else if (spear instanceof NetheriteSpearEntity) {
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)spear.yRotO, (float)spear.getYRot()) - 90.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)spear.xRotO, (float)spear.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spear)), (boolean)false, (boolean)((NetheriteSpearEntity)spear).isFoil());
            this.crossModel.renderToBuffer(pose, vertexconsumer, i, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            super.render(spear, f, g, pose, source, i);
        }
    }

    public ResourceLocation getTextureLocation(Entity spear) {
        if (spear instanceof WoodenSpearEntity) {
            return CROSS_WOODEN;
        }
        if (spear instanceof StoneSpearEntity) {
            return CROSS_STONE;
        }
        if (spear instanceof IronSpearEntity) {
            return CROSS_IRON;
        }
        if (spear instanceof GoldenSpearEntity) {
            return CROSS_GOLDEN;
        }
        if (spear instanceof DiamondSpearEntity) {
            return CROSS_DIAMOND;
        }
        if (spear instanceof NetheriteSpearEntity) {
            return CROSS_NETHERITE;
        }
        return null;
    }
}

