/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.spearsmod.client.item;

import com.doodle.spearsmod.client.entity.SpearEntityRenderer;
import com.doodle.spearsmod.client.model.CrossSpearModel;
import com.doodle.spearsmod.client.model.SpearModel;
import com.doodle.spearsmod.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private SpearModel spearModel;
    private CrossSpearModel crossModel;
    private final EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();

    public ModItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.spearModel = new SpearModel(this.entityModelSet.bakeLayer(SpearModel.LAYER_LOCATION));
        this.crossModel = new CrossSpearModel(this.entityModelSet.bakeLayer(CrossSpearModel.LAYER_LOCATION));
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        this.spearModel = new SpearModel(this.entityModelSet.bakeLayer(SpearModel.LAYER_LOCATION));
        this.crossModel = new CrossSpearModel(this.entityModelSet.bakeLayer(CrossSpearModel.LAYER_LOCATION));
    }

    public void renderByItem(ItemStack stack, @NotNull ItemDisplayContext context, @NotNull PoseStack pose, @NotNull MultiBufferSource source, int light, int overlay) {
        if (stack.is(ModItems.NETHERITE_SPEAR.get())) {
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            ResourceLocation layerLocation = SpearEntityRenderer.CROSS_NETHERITE;
            VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)layerLocation), (boolean)false, (boolean)stack.hasFoil());
            this.crossModel.renderToBuffer(pose, consumer, light, overlay);
            pose.popPose();
        } else if (stack.is(ModItems.DIAMOND_SPEAR.get())) {
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            ResourceLocation layerLocation = SpearEntityRenderer.CROSS_DIAMOND;
            VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)layerLocation), (boolean)false, (boolean)stack.hasFoil());
            this.crossModel.renderToBuffer(pose, consumer, light, overlay);
            pose.popPose();
        } else if (stack.is(ModItems.GOLDEN_SPEAR.get())) {
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            ResourceLocation layerLocation = SpearEntityRenderer.CROSS_GOLDEN;
            VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)layerLocation), (boolean)false, (boolean)stack.hasFoil());
            this.crossModel.renderToBuffer(pose, consumer, light, overlay);
            pose.popPose();
        } else if (stack.is(ModItems.IRON_SPEAR.get())) {
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            ResourceLocation layerLocation = SpearEntityRenderer.CROSS_IRON;
            VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)layerLocation), (boolean)false, (boolean)stack.hasFoil());
            this.crossModel.renderToBuffer(pose, consumer, light, overlay);
            pose.popPose();
        } else if (stack.is(ModItems.STONE_SPEAR.get())) {
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            ResourceLocation layerLocation = SpearEntityRenderer.CROSS_STONE;
            VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)layerLocation), (boolean)false, (boolean)stack.hasFoil());
            this.crossModel.renderToBuffer(pose, consumer, light, overlay);
            pose.popPose();
        } else if (stack.is(ModItems.WOODEN_SPEAR.get())) {
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            ResourceLocation layerLocation = SpearEntityRenderer.CROSS_WOODEN;
            VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityCutout((ResourceLocation)layerLocation), (boolean)false, (boolean)stack.hasFoil());
            this.crossModel.renderToBuffer(pose, consumer, light, overlay);
            pose.popPose();
        }
    }
}

