/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.spearsmod.entity;

import com.doodle.spearsmod.init.ModEntityTypes;
import com.doodle.spearsmod.init.ModItems;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SpearEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public SpearEntity(EntityType<? extends AbstractArrow> type, Level world, LivingEntity entity, ItemStack stack) {
        super(ModEntityTypes.SPEAR.get(), entity, world, stack, null);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
    }

    public SpearEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(ModEntityTypes.SPEAR.get(), x, y, z, world, stack, stack);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
    }

    protected void defineSynchedData(SynchedEntityData.Builder sed) {
        super.defineSynchedData(sed);
        sed.define(ID_LOYALTY, (Object)0);
        sed.define(ID_FOIL, (Object)false);
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.WOODEN_SPEAR.get());
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        byte by;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverlevel, (ItemStack)stack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

