/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.spearsmod.entity;

import com.doodle.spearsmod.init.ModEntityTypes;
import com.doodle.spearsmod.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class StoneSpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(StoneSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(StoneSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stoneSpearItem = new ItemStack((ItemLike)ModItems.STONE_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnStoneSpearTickCount;

    public StoneSpearEntity(EntityType<? extends StoneSpearEntity> type, Level level) {
        super(type, level);
    }

    public StoneSpearEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(ModEntityTypes.STONE_SPEAR.get(), x, y, z, world, stack, stack);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
    }

    public StoneSpearEntity(Level level, LivingEntity entity, ItemStack stack) {
        super(ModEntityTypes.STONE_SPEAR.get(), entity, level, stack, null);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
                if (this.clientSideReturnStoneSpearTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnStoneSpearTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.findHitEntity(p_37575_, p_37576_);
    }

    protected void onHitEntity(EntityHitResult p_37573_) {
        Item item;
        Player player;
        Entity entity = p_37573_.getEntity();
        float f = 8.0f;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)f);
            if (EnchantmentHelper.getEnchantmentLevel((Holder)((Holder)((HolderLookup.RegistryLookup)this.level().registryAccess().lookup(Registries.ENCHANTMENT).get()).get(Enchantments.FIRE_ASPECT).get()), (LivingEntity)((LivingEntity)entity1)) > 0) {
                entity.igniteForSeconds(4.0f);
            }
        }
        if (entity instanceof Player && (player = (Player)entity).isUsingItem() && (item = player.getUseItem().getItem()) instanceof ShieldItem) {
            ShieldItem shield = (ShieldItem)item;
            player.stopUsingItem();
            player.getCooldowns().addCooldown((Item)shield, 100);
            player.level().playSound(null, (Entity)player, SoundEvents.SHIELD_BREAK, player.getSoundSource(), 1.0f, 0.8f + player.level().random.nextFloat() * 0.4f);
        }
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.TRIDENT_HIT;
        if (entity.hurt(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            item = this.level();
            if (item instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)item;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damagesource);
                this.doPostHurtEffects(livingentity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(soundevent, 1.0f, 1.0f);
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        byte by;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverlevel, (ItemStack)stack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected void defineSynchedData(SynchedEntityData.Builder sed) {
        super.defineSynchedData(sed);
        sed.define(ID_LOYALTY, (Object)0);
        sed.define(ID_FOIL, (Object)false);
    }

    protected ItemStack getDefaultPickupItem() {
        return this.stoneSpearItem;
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player p_37580_) {
        if (this.ownedBy((Entity)p_37580_) || this.getOwner() == null) {
            super.playerTouch(p_37580_);
        }
    }

    public void readAdditionalSaveData(CompoundTag p_37578_) {
        super.readAdditionalSaveData(p_37578_);
        this.dealtDamage = p_37578_.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.stoneSpearItem));
    }

    public void addAdditionalSaveData(CompoundTag p_37582_) {
        super.addAdditionalSaveData(p_37582_);
        p_37582_.putBoolean("DealtDamage", this.dealtDamage);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

