/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.spearsmod.init;

import com.doodle.spearsmod.item.DiamondSpearItem;
import com.doodle.spearsmod.item.GoldenSpearItem;
import com.doodle.spearsmod.item.IronSpearItem;
import com.doodle.spearsmod.item.NetheriteSpearItem;
import com.doodle.spearsmod.item.StoneSpearItem;
import com.doodle.spearsmod.item.WoodenSpearItem;
import java.util.function.Supplier;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"spearsmod");
    public static final Supplier<Item> NETHERITE_SPEAR = ITEMS.register("netherite_spear", () -> new NetheriteSpearItem(new Item.Properties().stacksTo(1).durability(508).component(DataComponents.TOOL, (Object)NetheriteSpearItem.createToolProperties()).attributes(NetheriteSpearItem.createAttributes()).fireResistant()));
    public static final Supplier<Item> DIAMOND_SPEAR = ITEMS.register("diamond_spear", () -> new DiamondSpearItem(new Item.Properties().stacksTo(1).durability(390).component(DataComponents.TOOL, (Object)DiamondSpearItem.createToolProperties()).attributes(DiamondSpearItem.createAttributes())));
    public static final Supplier<Item> GOLDEN_SPEAR = ITEMS.register("golden_spear", () -> new GoldenSpearItem(new Item.Properties().stacksTo(1).durability(8).component(DataComponents.TOOL, (Object)GoldenSpearItem.createToolProperties()).attributes(GoldenSpearItem.createAttributes())));
    public static final Supplier<Item> IRON_SPEAR = ITEMS.register("iron_spear", () -> new IronSpearItem(new Item.Properties().stacksTo(1).durability(63).component(DataComponents.TOOL, (Object)IronSpearItem.createToolProperties()).attributes(IronSpearItem.createAttributes())));
    public static final Supplier<Item> STONE_SPEAR = ITEMS.register("stone_spear", () -> new StoneSpearItem(new Item.Properties().stacksTo(1).durability(33).component(DataComponents.TOOL, (Object)StoneSpearItem.createToolProperties()).attributes(StoneSpearItem.createAttributes())));
    public static final Supplier<Item> WOODEN_SPEAR = ITEMS.register("wooden_spear", () -> new WoodenSpearItem(new Item.Properties().stacksTo(1).durability(15).component(DataComponents.TOOL, (Object)WoodenSpearItem.createToolProperties()).attributes(WoodenSpearItem.createAttributes())));

    private static void registerUseItemProperty(Supplier<Item> item, String name) {
        ItemProperties.register((Item)item.get(), (ResourceLocation)ResourceLocation.parse((String)name), (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    public static void registerItemProperties() {
        ModItems.registerUseItemProperty(NETHERITE_SPEAR, "throwing");
        ModItems.registerUseItemProperty(DIAMOND_SPEAR, "throwing");
        ModItems.registerUseItemProperty(GOLDEN_SPEAR, "throwing");
        ModItems.registerUseItemProperty(IRON_SPEAR, "throwing");
        ModItems.registerUseItemProperty(STONE_SPEAR, "throwing");
        ModItems.registerUseItemProperty(WOODEN_SPEAR, "throwing");
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

