/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

import io.github.rypofalem.armorstandeditor.CommandEx;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.Metrics;
import io.github.rypofalem.armorstandeditor.PlayerEditorManager;
import io.github.rypofalem.armorstandeditor.Scheduler;
import io.github.rypofalem.armorstandeditor.language.Language;
import io.github.rypofalem.armorstandeditor.libs.paperlib.PaperLib;
import io.github.rypofalem.armorstandeditor.updatechecker.UpdateCheckSource;
import io.github.rypofalem.armorstandeditor.updatechecker.UpdateChecker;
import io.github.rypofalem.armorstandeditor.updatechecker.UserAgentBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ArmorStandEditorPlugin
extends JavaPlugin {
    public static final int SPIGOT_RESOURCE_ID = 94503;
    private static final int PLUGIN_ID = 12668;
    private Debug debug = new Debug(this);
    private NamespacedKey iconKey;
    private static ArmorStandEditorPlugin instance;
    private Language lang;
    String nmsVersion;
    String languageFolderLocation = "lang/";
    String warningMCVer = "Minecraft Version: ";
    public boolean hasSpigot = false;
    public boolean hasPaper = false;
    public boolean hasFolia = false;
    String nmsVersionNotLatest = null;
    public static final String ASE_VERSION = "1.21.10-49.3";
    public static final String SEPARATOR_FIELD = "================================";
    public PlayerEditorManager editorManager;
    boolean opUpdateNotification = false;
    boolean runTheUpdateChecker = false;
    double updateCheckerInterval;
    Material editTool;
    String toolType;
    int editToolData = Integer.MIN_VALUE;
    boolean requireToolData = false;
    boolean requireToolName = false;
    String editToolName = null;
    boolean requireToolLore = false;
    List<?> editToolLore = null;
    boolean enablePerWorld = false;
    List<?> allowedWorldList = null;
    boolean allowCustomModelData = false;
    Integer customModelDataInt = Integer.MIN_VALUE;
    double maxScaleValue;
    double minScaleValue;
    boolean requireSneaking = false;
    boolean sendToActionBar = true;
    double coarseRot;
    double fineRot;
    boolean glowItemFrames = false;
    boolean invisibleItemFrames = true;
    boolean armorStandVisibility = true;
    boolean defaultGravity = false;
    boolean allowedToRetrieveOwnPlayerHead = false;
    boolean adminOnlyNotifications = false;
    public Scoreboard scoreboard;
    public Team team;
    List<String> asTeams = new ArrayList<String>();
    String lockedTeam = "ASLocked";
    String inUseTeam = "AS-InUse";
    boolean debugFlag;
    private static ArmorStandEditorPlugin plugin;

    public ArmorStandEditorPlugin() {
        instance = this;
    }

    public void onEnable() {
        if (!Scheduler.isFolia().booleanValue()) {
            this.scoreboard = Objects.requireNonNull(this.getServer().getScoreboardManager()).getMainScoreboard();
        }
        this.getLogger().info("======= ArmorStandEditor =======");
        this.getLogger().info("Plugin Version: v1.21.10-49.3");
        this.hasSpigot = this.getHasSpigot();
        this.hasPaper = this.getHasPaper();
        this.hasFolia = Scheduler.isFolia();
        if (this.hasPaper || this.hasFolia) {
            this.nmsVersion = this.getServer().getMinecraftVersion();
            if (this.nmsVersion.contains("1.21")) {
                this.getLogger().log(Level.INFO, this.warningMCVer + "{0}", this.nmsVersion);
                this.getLogger().info("ArmorStandEditor is compatible with this version of Minecraft. Loading continuing.");
            } else if (this.nmsVersion.contains("1.17") || this.nmsVersion.contains("1.18") || this.nmsVersion.contains("1.19") || this.nmsVersion.contains("1.20")) {
                this.getLogger().log(Level.WARNING, this.warningMCVer + "{0}", this.nmsVersion);
                this.getLogger().warning("ArmorStandEditor is compatible with this version of Minecraft, but it is not the latest supported version.");
                this.getLogger().warning("Loading continuing, but please consider updating to the latest version.");
            } else {
                this.getLogger().log(Level.WARNING, this.warningMCVer + "{0}", this.nmsVersion);
                this.getLogger().warning("ArmorStandEditor is not compatible with this version of Minecraft. Please update to at least version 1.17. Loading failed.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                this.getLogger().info(SEPARATOR_FIELD);
            }
        } else {
            this.nmsVersion = this.getNmsVersion();
            if (this.nmsVersion.compareTo("v1_17") < 0) {
                this.getLogger().log(Level.WARNING, this.warningMCVer + "{0}", this.nmsVersion);
                this.getLogger().warning("ArmorStandEditor is not compatible with this version of Minecraft. Please update to at least version 1.17. Loading failed.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                this.getLogger().info(SEPARATOR_FIELD);
                return;
            }
            if (this.nmsVersion.compareTo("v1_21") < 0) {
                this.getLogger().log(Level.WARNING, this.warningMCVer + "{0}", this.nmsVersion);
                this.getLogger().warning("ArmorStandEditor is compatible with this version of Minecraft, but it is not the latest supported version.");
                this.getLogger().warning("Loading continuing, but please consider updating to the latest version.");
            } else {
                this.getLogger().log(Level.INFO, this.warningMCVer + "{0}", this.nmsVersion);
                this.getLogger().info("ArmorStandEditor is compatible with this version of Minecraft. Loading continuing.");
            }
        }
        if (!this.hasPaper && !this.hasSpigot) {
            this.getLogger().severe("This plugin requires either Paper, Spigot or one of its forks to run. This is not an error, please do not report this!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().info(SEPARATOR_FIELD);
            return;
        }
        if (this.hasSpigot) {
            this.getLogger().log(Level.INFO, "SpigotMC: {0}", this.hasSpigot);
        } else {
            this.getLogger().log(Level.INFO, "PaperMC: {0}", this.hasPaper);
        }
        this.getServer().getPluginManager().enablePlugin((Plugin)this);
        this.asTeams.add(this.lockedTeam);
        this.asTeams.add(this.inUseTeam);
        if (!this.hasFolia) {
            this.scoreboard = Objects.requireNonNull(this.getServer().getScoreboardManager()).getMainScoreboard();
            this.registerScoreboards(this.scoreboard);
        } else {
            this.getServer().getLogger().warning("Scoreboards currently do not work on Folia. Scoreboard Coloring will not work");
        }
        this.getLogger().info(SEPARATOR_FIELD);
        this.updateConfig("", "config.yml");
        this.updateConfig(this.languageFolderLocation, "de_DE.yml");
        this.updateConfig(this.languageFolderLocation, "es_ES.yml");
        this.updateConfig(this.languageFolderLocation, "fr_FR.yml");
        this.updateConfig(this.languageFolderLocation, "ja_JP.yml");
        this.updateConfig(this.languageFolderLocation, "nl_NL.yml");
        this.updateConfig(this.languageFolderLocation, "pl_PL.yml");
        this.updateConfig(this.languageFolderLocation, "pt_BR.yml");
        this.updateConfig(this.languageFolderLocation, "ro_RO.yml");
        this.updateConfig(this.languageFolderLocation, "ru_RU.yml");
        this.updateConfig(this.languageFolderLocation, "test_NA.yml");
        this.updateConfig(this.languageFolderLocation, "uk_UA.yml");
        this.updateConfig(this.languageFolderLocation, "zh_CN.yml");
        this.saveResource("lang/en_US.yml", true);
        this.lang = new Language(this.getConfig().getString("lang"), this);
        this.coarseRot = this.getConfig().getDouble("coarse");
        this.fineRot = this.getConfig().getDouble("fine");
        this.maxScaleValue = this.getConfig().getDouble("maxScaleValue");
        this.minScaleValue = this.getConfig().getDouble("minScaleValue");
        this.toolType = this.getConfig().getString("tool");
        if (this.toolType == null) {
            this.getLogger().severe("Unable to get Tool for Use with Plugin. Unable to continue!");
            this.getLogger().info(SEPARATOR_FIELD);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.editTool = Material.getMaterial((String)this.toolType);
        this.requireToolName = this.getConfig().getBoolean("requireToolName", false);
        if (this.requireToolName) {
            this.editToolName = this.getConfig().getString("toolName", null);
            if (this.editToolName != null) {
                this.editToolName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.editToolName);
            }
        }
        this.allowCustomModelData = this.getConfig().getBoolean("allowCustomModelData", false);
        if (this.allowCustomModelData) {
            this.customModelDataInt = this.getConfig().getInt("customModelDataInt", Integer.MIN_VALUE);
        }
        this.armorStandVisibility = this.getConfig().getBoolean("armorStandVisibility", true);
        this.requireToolData = this.getConfig().getBoolean("requireToolData", false);
        if (this.requireToolData) {
            this.editToolData = this.getConfig().getInt("toolData", Integer.MIN_VALUE);
        }
        this.requireToolLore = this.getConfig().getBoolean("requireToolLore", false);
        if (this.requireToolLore) {
            this.editToolLore = this.getConfig().getList("toolLore", null);
        }
        this.enablePerWorld = this.getConfig().getBoolean("enablePerWorldSupport", false);
        if (this.enablePerWorld) {
            this.allowedWorldList = this.getConfig().getList("allowed-worlds", null);
            if (this.allowedWorldList != null && this.allowedWorldList.get(0).equals("*")) {
                this.allowedWorldList = this.getServer().getWorlds().stream().map(WorldInfo::getName).toList();
            }
        }
        this.defaultGravity = this.getConfig().getBoolean("defaultGravitySetting", true);
        this.requireSneaking = this.getConfig().getBoolean("requireSneaking", false);
        this.sendToActionBar = this.getConfig().getBoolean("sendMessagesToActionBar", true);
        this.glowItemFrames = this.getConfig().getBoolean("glowingItemFrame", true);
        this.invisibleItemFrames = this.getConfig().getBoolean("invisibleItemFrames", true);
        this.runTheUpdateChecker = this.getConfig().getBoolean("runTheUpdateChecker", true);
        this.opUpdateNotification = this.getConfig().getBoolean("opUpdateNotification", true);
        this.updateCheckerInterval = this.getConfig().getDouble("updateCheckerInterval", 24.0);
        this.allowedToRetrieveOwnPlayerHead = this.getConfig().getBoolean("allowedToRetrieveOwnPlayerHead", true);
        this.adminOnlyNotifications = this.getConfig().getBoolean("adminOnlyNotifications", true);
        this.debugFlag = this.getConfig().getBoolean("debugFlag", false);
        if (this.debugFlag) {
            this.getServer().getLogger().log(Level.INFO, "[ArmorStandEditor-Debug] ArmorStandEditor Debug Mode is now ENABLED! Use this ONLY for testing Purposes. If you can see this and you have debug disabled, please report it as a bug!");
        }
        if (!this.hasFolia && this.runTheUpdateChecker) {
            if (this.opUpdateNotification) {
                this.runUpdateCheckerWithOPNotifyOnJoinEnabled();
            } else {
                this.runUpdateCheckerConsoleUpdateCheck();
            }
        }
        this.getMetrics();
        this.editorManager = new PlayerEditorManager(this);
        CommandEx execute = new CommandEx(this);
        Objects.requireNonNull(this.getCommand("ase")).setExecutor((CommandExecutor)execute);
        Objects.requireNonNull(this.getCommand("ase")).setTabCompleter((TabCompleter)execute);
        this.getServer().getPluginManager().registerEvents((Listener)this.editorManager, (Plugin)this);
    }

    private void runUpdateCheckerConsoleUpdateCheck() {
        if (ASE_VERSION.contains(".x")) {
            this.getLogger().warning("Note from the development team: ");
            this.getLogger().warning("It appears that you are using the development version of ArmorStandEditor");
            this.getLogger().warning("This version can be unstable and is not recommended for Production Environments.");
            this.getLogger().warning("Please, report bugs to: https://github.com/Wolfieheart/ArmorStandEditor. ");
            this.getLogger().warning("This warning is intended to be displayed when using a Dev build and is NOT A BUG!");
            this.getLogger().info("Update Checker does not work on Development Builds.");
        } else {
            new UpdateChecker(this, UpdateCheckSource.SPIGET, "94503").setDownloadLink("https://www.spigotmc.org/resources/armorstandeditor-reborn.94503/").setChangelogLink("https://www.spigotmc.org/resources/armorstandeditor-reborn.94503/history").setColoredConsoleOutput(true).setUserAgent(new UserAgentBuilder().addPluginNameAndVersion().addServerVersion()).checkEveryXHours(this.updateCheckerInterval).checkNow();
        }
    }

    private void runUpdateCheckerWithOPNotifyOnJoinEnabled() {
        if (ASE_VERSION.contains(".x")) {
            this.getLogger().warning("Note from the development team: ");
            this.getLogger().warning("It appears that you are using the development version of ArmorStandEditor");
            this.getLogger().warning("This version can be unstable and is not recommended for Production Environments.");
            this.getLogger().warning("Please, report bugs to: https://github.com/Wolfieheart/ArmorStandEditor . ");
            this.getLogger().warning("This warning is intended to be displayed when using a Dev build and is NOT A BUG!");
            this.getLogger().info("Update Checker does not work on Development Builds.");
        } else {
            new UpdateChecker(this, UpdateCheckSource.SPIGET, "94503").setDownloadLink("https://www.spigotmc.org/resources/armorstandeditor-reborn.94503/").setChangelogLink("https://www.spigotmc.org/resources/armorstandeditor-reborn.94503/history").setColoredConsoleOutput(true).setNotifyOpsOnJoin(true).setUserAgent(new UserAgentBuilder().addPluginNameAndVersion().addServerVersion()).checkEveryXHours(this.updateCheckerInterval).checkNow();
        }
    }

    private void registerScoreboards(Scoreboard scoreboard) {
        this.getServer().getLogger().info("Registering Scoreboards required for Glowing Effects");
        if (scoreboard.getTeam(this.inUseTeam) == null) {
            scoreboard.registerNewTeam(this.inUseTeam);
        } else {
            this.getServer().getLogger().info("Scoreboard for AS-InUse Already exists. Continuing to load");
        }
        if (scoreboard.getTeam(this.lockedTeam) == null) {
            scoreboard.registerNewTeam(this.lockedTeam);
            scoreboard.getTeam(this.lockedTeam).setColor(ChatColor.RED);
        } else {
            this.getServer().getLogger().info("Scoreboard for ASLocked Already exists. Continuing to load");
        }
    }

    private void unregisterScoreboards(Scoreboard scoreboard) {
        this.getLogger().info("Removing Scoreboards required for Glowing Effects when Disabling Slots...");
        this.team = scoreboard.getTeam(this.lockedTeam);
        if (this.team != null) {
            this.team.unregister();
        } else {
            this.getLogger().severe("Team Already Appears to be removed. Please do not do this manually!");
        }
        this.team = scoreboard.getTeam(this.inUseTeam);
        if (this.team != null) {
            this.team.unregister();
        } else {
            this.getLogger().severe("Team Already Appears to be removed. Please do not do this manually!");
        }
    }

    private void updateConfig(String folder, String config) {
        if (!new File(String.valueOf(this.getDataFolder()) + File.separator + folder + config).exists()) {
            this.saveResource(folder + config, false);
        }
    }

    public void onDisable() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (PaperLib.getHolder(player.getOpenInventory().getTopInventory(), false).getHolder() != this.editorManager.getMenuHolder()) continue;
            player.closeInventory(InventoryCloseEvent.Reason.DISCONNECT);
        }
        if (!this.hasFolia) {
            this.scoreboard = Objects.requireNonNull(this.getServer().getScoreboardManager()).getMainScoreboard();
            this.unregisterScoreboards(this.scoreboard);
        }
    }

    public String getNmsVersion() {
        if (this.getHasPaper() || this.getHasFolia()) {
            return this.getMinecraftVersion();
        }
        return this.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public boolean getHasSpigot() {
        try {
            Class.forName("org.spigotmc.CustomTimingsHandler");
            this.nmsVersionNotLatest = "SpigotMC ASAP.";
            return true;
        }
        catch (ClassNotFoundException e) {
            this.nmsVersionNotLatest = "";
            return false;
        }
    }

    public boolean getHasPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            this.nmsVersionNotLatest = "PaperMC ASAP.";
            return true;
        }
        catch (ClassNotFoundException e) {
            this.nmsVersionNotLatest = "";
            return false;
        }
    }

    public boolean getHasFolia() {
        return Scheduler.isFolia();
    }

    public String getMinecraftVersion() {
        return this.nmsVersion;
    }

    public boolean getArmorStandVisibility() {
        return this.getConfig().getBoolean("armorStandVisibility");
    }

    public boolean getItemFrameVisibility() {
        return this.getConfig().getBoolean("invisibleItemFrames");
    }

    public Language getLang() {
        return this.lang;
    }

    public boolean getAllowCustomModelData() {
        return this.getConfig().getBoolean("allowCustomModelData");
    }

    public Material getEditTool() {
        return this.editTool;
    }

    public boolean getRunTheUpdateChecker() {
        return this.getConfig().getBoolean("runTheUpdateChecker");
    }

    public boolean getDefaultGravity() {
        return this.getConfig().getBoolean("defaultGravitySetting");
    }

    public Integer getCustomModelDataInt() {
        return this.getConfig().getInt("customModelDataInt");
    }

    public boolean getallowedToRetrieveOwnPlayerHead() {
        return this.getConfig().getBoolean("allowedToRetrieveOwnPlayerHead");
    }

    public boolean getAdminOnlyNotifications() {
        return this.getConfig().getBoolean("adminOnlyNotifications");
    }

    public double getMinScaleValue() {
        return this.getConfig().getDouble("minScaleValue");
    }

    public double getMaxScaleValue() {
        return this.getConfig().getDouble("maxScaleValue");
    }

    public boolean isEditTool(ItemStack itemStk) {
        Damageable d1;
        if (itemStk == null) {
            return false;
        }
        if (this.editTool != itemStk.getType()) {
            return false;
        }
        ItemMeta itemMeta = itemStk.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        if (this.requireToolData && (d1 = (Damageable)itemMeta) != null && d1.getDamage() != (short)this.editToolData) {
            return false;
        }
        if (this.requireToolName && this.editToolName != null) {
            if (!itemStk.hasItemMeta()) {
                return false;
            }
            String itemName = itemMeta.getDisplayName();
            if (!itemName.equals(this.editToolName)) {
                return false;
            }
        }
        if (this.requireToolLore && this.editToolLore != null) {
            if (!itemStk.hasItemMeta()) {
                return false;
            }
            List itemLore = itemMeta.getLore();
            boolean hasTheItemLore = itemMeta.hasLore();
            if (!hasTheItemLore) {
                return false;
            }
            List<?> listStringOfEditToolLore = this.editToolLore;
            if (!itemLore.equals(listStringOfEditToolLore)) {
                return false;
            }
        }
        if (this.allowCustomModelData && this.customModelDataInt != null) {
            if (!itemStk.hasItemMeta()) {
                return false;
            }
            Integer itemCustomModel = itemMeta.getCustomModelData();
            return itemCustomModel.equals(this.customModelDataInt);
        }
        return true;
    }

    public void performReload() {
        if (!this.hasFolia) {
            this.scoreboard = Objects.requireNonNull(this.getServer().getScoreboardManager()).getMainScoreboard();
            this.unregisterScoreboards(this.scoreboard);
        }
        this.reloadConfig();
        if (!this.hasFolia) {
            this.registerScoreboards(this.scoreboard);
        }
        this.reloadConfig();
        this.lang = new Language(this.getConfig().getString("lang"), this);
        this.coarseRot = this.getConfig().getDouble("coarse");
        this.fineRot = this.getConfig().getDouble("fine");
        this.maxScaleValue = this.getConfig().getDouble("maxScaleValue");
        this.minScaleValue = this.getConfig().getDouble("minScaleValue");
        this.toolType = this.getConfig().getString("tool");
        if (this.toolType != null) {
            this.editTool = Material.getMaterial((String)this.toolType);
        }
        this.requireToolName = this.getConfig().getBoolean("requireToolName", false);
        if (this.requireToolName) {
            this.editToolName = this.getConfig().getString("toolName", null);
            if (this.editToolName != null) {
                this.editToolName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.editToolName);
            }
        }
        this.allowCustomModelData = this.getConfig().getBoolean("allowCustomModelData", false);
        if (this.allowCustomModelData) {
            this.customModelDataInt = this.getConfig().getInt("customModelDataInt", Integer.MIN_VALUE);
        }
        this.armorStandVisibility = this.getConfig().getBoolean("armorStandVisibility", true);
        this.requireToolData = this.getConfig().getBoolean("requireToolData", false);
        if (this.requireToolData) {
            this.editToolData = this.getConfig().getInt("toolData", Integer.MIN_VALUE);
        }
        this.requireToolLore = this.getConfig().getBoolean("requireToolLore", false);
        if (this.requireToolLore) {
            this.editToolLore = this.getConfig().getList("toolLore", null);
        }
        this.enablePerWorld = this.getConfig().getBoolean("enablePerWorldSupport", false);
        if (this.enablePerWorld) {
            this.allowedWorldList = this.getConfig().getList("allowed-worlds", null);
            if (this.allowedWorldList != null && this.allowedWorldList.getFirst().equals("*")) {
                this.allowedWorldList = this.getServer().getWorlds().stream().map(WorldInfo::getName).toList();
            }
        }
        this.requireSneaking = this.getConfig().getBoolean("requireSneaking", false);
        this.sendToActionBar = this.getConfig().getBoolean("sendMessagesToActionBar", true);
        this.glowItemFrames = this.getConfig().getBoolean("glowingItemFrame", true);
        this.invisibleItemFrames = this.getConfig().getBoolean("invisibleItemFrames", true);
        this.runTheUpdateChecker = this.getConfig().getBoolean("runTheUpdateChecker", true);
        this.allowedToRetrieveOwnPlayerHead = this.getConfig().getBoolean("allowedToRetrieveOwnPlayerHead", true);
        this.adminOnlyNotifications = this.getConfig().getBoolean("adminOnlyNotifications", true);
        this.opUpdateNotification = this.getConfig().getBoolean("opUpdateNotification", true);
        this.updateCheckerInterval = this.getConfig().getDouble("updateCheckerInterval", 24.0);
        this.debugFlag = this.getConfig().getBoolean("debugFlag", false);
        if (this.debugFlag) {
            this.getServer().getLogger().log(Level.INFO, "[ArmorStandEditor-Debug] ArmorStandEditor Debug Mode is now ENABLED! Use this ONLY for testing Purposes. If you can see this and you have debug disabled, please report it as a bug!");
        }
        if (!this.hasFolia && this.runTheUpdateChecker) {
            if (this.opUpdateNotification) {
                this.runUpdateCheckerWithOPNotifyOnJoinEnabled();
            } else {
                this.runUpdateCheckerConsoleUpdateCheck();
            }
        }
    }

    public static ArmorStandEditorPlugin instance() {
        return instance;
    }

    private void getMetrics() {
        Metrics metrics = new Metrics(this, 12668);
        metrics.addCustomChart(new Metrics.SimplePie("tool_lore_enabled", () -> this.getConfig().getString("requireToolLore")));
        metrics.addCustomChart(new Metrics.SimplePie("tool_data_enabled", () -> this.getConfig().getString("requireToolData")));
        metrics.addCustomChart(new Metrics.SimplePie("action_bar_messages", () -> this.getConfig().getString("sendMessagesToActionBar")));
        metrics.addCustomChart(new Metrics.SimplePie("require_sneaking", () -> this.getConfig().getString("requireSneaking")));
        metrics.addCustomChart(new Metrics.DrilldownPie("language_used", () -> {
            HashMap map = new HashMap();
            HashMap entry = new HashMap();
            String languageUsed = this.getConfig().getString("lang");
            assert (languageUsed != null);
            if (languageUsed.startsWith("nl")) {
                map.put("Dutch", entry);
            } else if (languageUsed.startsWith("de")) {
                map.put("German", entry);
            } else if (languageUsed.startsWith("es")) {
                map.put("Spanish", entry);
            } else if (languageUsed.startsWith("fr")) {
                map.put("French", entry);
            } else if (languageUsed.startsWith("ja")) {
                map.put("Japanese", entry);
            } else if (languageUsed.startsWith("pl")) {
                map.put("Polish", entry);
            } else if (languageUsed.startsWith("ru")) {
                map.put("Russian", entry);
            } else if (languageUsed.startsWith("ro")) {
                map.put("Romanian", entry);
            } else if (languageUsed.startsWith("uk")) {
                map.put("Ukrainian", entry);
            } else if (languageUsed.startsWith("zh")) {
                map.put("Chinese", entry);
            } else if (languageUsed.startsWith("pt")) {
                map.put("Brazilian", entry);
            } else {
                map.put("English", entry);
            }
            return map;
        }));
        metrics.addCustomChart(new Metrics.SimplePie("armor_stand_invisibility_usage", () -> this.getConfig().getString("armorStandVisibility")));
        metrics.addCustomChart(new Metrics.SimplePie("itemframe_invisibility_used", () -> this.getConfig().getString("invisibleItemFrames")));
        metrics.addCustomChart(new Metrics.SimplePie("custom_toolname_enabled", () -> this.getConfig().getString("requireToolName")));
        metrics.addCustomChart(new Metrics.SimplePie("using_the_update_checker", () -> this.getConfig().getString("runTheUpdateChecker")));
        metrics.addCustomChart(new Metrics.SimplePie("op_updates", () -> this.getConfig().getString("opUpdateNotification")));
    }

    public NamespacedKey getIconKey() {
        if (this.iconKey == null) {
            this.iconKey = new NamespacedKey((Plugin)this, "command_icon");
        }
        return this.iconKey;
    }

    public boolean isDebug() {
        return this.debugFlag;
    }
}

