/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.Util;
import io.github.rypofalem.armorstandeditor.VersionUtil;
import io.github.rypofalem.armorstandeditor.modes.AdjustmentMode;
import io.github.rypofalem.armorstandeditor.modes.Axis;
import io.github.rypofalem.armorstandeditor.modes.EditMode;
import io.github.rypofalem.armorstandeditor.updatechecker.UpdateCheckSource;
import io.github.rypofalem.armorstandeditor.updatechecker.UpdateChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class CommandEx
implements CommandExecutor,
TabCompleter {
    ArmorStandEditorPlugin plugin;
    final String LISTMODE = String.valueOf(ChatColor.YELLOW) + "/ase mode <" + Util.getEnumList(EditMode.class) + ">";
    final String LISTAXIS = String.valueOf(ChatColor.YELLOW) + "/ase axis <" + Util.getEnumList(Axis.class) + ">";
    final String LISTADJUSTMENT = String.valueOf(ChatColor.YELLOW) + "/ase adj <" + Util.getEnumList(AdjustmentMode.class) + ">";
    final String LISTSLOT = String.valueOf(ChatColor.YELLOW) + "/ase slot <1-9>";
    final String HELP = String.valueOf(ChatColor.YELLOW) + "/ase help or /ase ?";
    final String VERSION = String.valueOf(ChatColor.YELLOW) + "/ase version";
    final String UPDATE = String.valueOf(ChatColor.YELLOW) + "/ase update";
    final String RELOAD = String.valueOf(ChatColor.YELLOW) + "/ase reload";
    final String GIVECUSTOMMODEL = String.valueOf(ChatColor.YELLOW) + "/ase give";
    final String GIVEPLAYERHEAD = String.valueOf(ChatColor.YELLOW) + "/ase playerhead";
    final String GETARMORSTATS = String.valueOf(ChatColor.YELLOW) + "/ase stats";
    private Debug debug;

    public CommandEx(ArmorStandEditorPlugin armorStandEditorPlugin) {
        this.plugin = armorStandEditorPlugin;
        this.debug = new Debug(armorStandEditorPlugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (sender instanceof ConsoleCommandSender) {
            this.debug.log("Sender is CONSOLE!");
            if (args.length == 0) {
                sender.sendMessage(this.VERSION);
                sender.sendMessage(this.HELP);
                sender.sendMessage(this.RELOAD);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "reload": {
                    this.commandReloadConsole(sender);
                    break;
                }
                case "help": 
                case "?": {
                    this.commandHelpConsole(sender);
                    break;
                }
                case "version": {
                    this.commandVersionConsole(sender);
                    break;
                }
                default: {
                    sender.sendMessage(this.plugin.getLang().getMessage("noconsolecom", "warn"));
                }
            }
            return true;
        }
        if (sender instanceof Player && !this.getPermissionBasic(player = (Player)sender)) {
            this.debug.log("Sender is Player but asedit.basic is" + this.getPermissionBasic(player));
            sender.sendMessage(this.plugin.getLang().getMessage("nopermoption", "warn", "basic"));
            return true;
        }
        Player player2 = (Player)sender;
        this.debug.log("Sender is Player and asedit.basic is " + this.getPermissionBasic(player2));
        if (args.length == 0) {
            player2.sendMessage(this.LISTMODE);
            player2.sendMessage(this.LISTAXIS);
            player2.sendMessage(this.LISTSLOT);
            player2.sendMessage(this.LISTADJUSTMENT);
            player2.sendMessage(this.VERSION);
            player2.sendMessage(this.UPDATE);
            player2.sendMessage(this.HELP);
            player2.sendMessage(this.RELOAD);
            player2.sendMessage(this.GIVECUSTOMMODEL);
            player2.sendMessage(this.GIVEPLAYERHEAD);
            player2.sendMessage(this.GETARMORSTATS);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "mode": {
                this.commandMode(player2, args);
                break;
            }
            case "axis": {
                this.commandAxis(player2, args);
                break;
            }
            case "adj": {
                this.commandAdj(player2, args);
                break;
            }
            case "slot": {
                this.commandSlot(player2, args);
                break;
            }
            case "help": 
            case "?": {
                this.commandHelp(player2);
                break;
            }
            case "version": {
                this.commandVersion(player2);
                break;
            }
            case "update": {
                this.commandUpdate(player2);
                break;
            }
            case "give": {
                this.commandGive(player2);
                break;
            }
            case "playerhead": {
                this.commandGivePlayerHead(player2);
                break;
            }
            case "reload": {
                this.commandReload(player2);
                break;
            }
            case "stats": {
                this.commandStats(player2);
                break;
            }
            default: {
                sender.sendMessage(this.LISTMODE);
                sender.sendMessage(this.LISTAXIS);
                sender.sendMessage(this.LISTSLOT);
                sender.sendMessage(this.LISTADJUSTMENT);
                sender.sendMessage(this.VERSION);
                sender.sendMessage(this.UPDATE);
                sender.sendMessage(this.HELP);
                sender.sendMessage(this.RELOAD);
                sender.sendMessage(this.GIVECUSTOMMODEL);
                sender.sendMessage(this.GIVEPLAYERHEAD);
                sender.sendMessage(this.GETARMORSTATS);
            }
        }
        return true;
    }

    private void commandGive(Player player) {
        if (player.hasPermission("asedit.give")) {
            ItemStack stack = new ItemStack(this.plugin.getEditTool());
            ItemMeta meta = stack.getItemMeta();
            Objects.requireNonNull(meta).setCustomModelData(this.plugin.getCustomModelDataInt());
            meta.setUnbreakable(true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            stack.setItemMeta(meta);
            player.getInventory().addItem(new ItemStack[]{stack});
            player.sendMessage(this.plugin.getLang().getMessage("give", "info"));
        } else {
            player.sendMessage(this.plugin.getLang().getMessage("nogive", "warn"));
        }
    }

    private void commandGivePlayerHead(Player player) {
        if (player.hasPermission("asedit.head")) {
            this.debug.log("Creating a player head for the OfflinePlayer '" + player.getDisplayName() + "'");
            Player offlinePlayer = player.getPlayer();
            ItemStack item = new ItemStack(Material.PLAYER_HEAD, 1, 3);
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            meta.setOwningPlayer((OfflinePlayer)offlinePlayer);
            item.setItemMeta((ItemMeta)meta);
            player.getInventory().addItem(new ItemStack[]{item});
            player.sendMessage(this.plugin.getLang().getMessage("playerhead", "info"));
        } else {
            player.sendMessage(this.plugin.getLang().getMessage("playerheaderror", "warn"));
        }
    }

    private void commandSlot(Player player, String[] args) {
        if (args.length <= 1) {
            player.sendMessage(this.plugin.getLang().getMessage("noslotnumcom", "warn"));
            player.sendMessage(this.LISTSLOT);
        }
        if (args.length > 1) {
            try {
                byte slot = (byte)(Byte.parseByte(args[1]) - 1);
                if (slot >= 0 && slot < 9) {
                    this.debug.log("Player has chosen slot: " + slot);
                    this.plugin.editorManager.getPlayerEditor(player.getUniqueId()).setCopySlot(slot);
                } else {
                    player.sendMessage(this.LISTSLOT);
                }
            }
            catch (NumberFormatException nfe) {
                player.sendMessage(this.LISTSLOT);
            }
        }
    }

    private void commandAdj(Player player, String[] args) {
        if (args.length <= 1) {
            player.sendMessage(this.plugin.getLang().getMessage("noadjcom", "warn"));
            player.sendMessage(this.LISTADJUSTMENT);
        }
        if (args.length > 1) {
            for (AdjustmentMode adj : AdjustmentMode.values()) {
                if (!adj.toString().toLowerCase().contentEquals(args[1].toLowerCase())) continue;
                this.plugin.editorManager.getPlayerEditor(player.getUniqueId()).setAdjMode(adj);
                return;
            }
            player.sendMessage(this.LISTADJUSTMENT);
        }
    }

    private void commandAxis(Player player, String[] args) {
        if (args.length <= 1) {
            player.sendMessage(this.plugin.getLang().getMessage("noaxiscom", "warn"));
            player.sendMessage(this.LISTAXIS);
        }
        if (args.length > 1) {
            for (Axis axis : Axis.values()) {
                if (!axis.toString().toLowerCase().contentEquals(args[1].toLowerCase())) continue;
                this.debug.log("Player '" + player.getDisplayName() + "' sets the axis to " + String.valueOf((Object)axis));
                this.plugin.editorManager.getPlayerEditor(player.getUniqueId()).setAxis(axis);
                return;
            }
            player.sendMessage(this.LISTAXIS);
        }
    }

    private void commandMode(Player player, String[] args) {
        if (args.length <= 1) {
            player.sendMessage(this.plugin.getLang().getMessage("nomodecom", "warn"));
            player.sendMessage(this.LISTMODE);
        }
        if (args.length > 1) {
            for (EditMode mode : EditMode.values()) {
                if (!mode.toString().toLowerCase().contentEquals(args[1].toLowerCase())) continue;
                if (args[1].equals("invisible") && !this.checkPermission(player, "togglearmorstandvisibility", true) && !this.plugin.getArmorStandVisibility()) {
                    return;
                }
                if (args[1].equals("itemframe") && !this.checkPermission(player, "toggleitemframevisibility", true) && !this.plugin.getItemFrameVisibility()) {
                    return;
                }
                this.plugin.editorManager.getPlayerEditor(player.getUniqueId()).setMode(mode);
                this.debug.log("Player '" + player.getDisplayName() + "' chose the mode: " + String.valueOf((Object)mode));
                return;
            }
        }
    }

    private void commandHelp(Player player) {
        player.closeInventory();
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        player.sendMessage(this.plugin.getLang().getMessage("help", "info", this.plugin.editTool.name()));
        player.sendMessage("");
        player.sendMessage(this.plugin.getLang().getMessage("helptips", "info"));
        player.sendMessage("");
        player.sendRawMessage(this.plugin.getLang().getMessage("helpurl", ""));
        player.sendRawMessage(this.plugin.getLang().getMessage("helpdiscord", ""));
    }

    private void commandHelpConsole(CommandSender sender) {
        sender.sendMessage(this.plugin.getLang().getMessage("help", "info", this.plugin.editTool.name()));
        sender.sendMessage("");
        sender.sendMessage(this.plugin.getLang().getMessage("helptips", "info"));
        sender.sendMessage("");
        sender.sendMessage(this.plugin.getLang().getMessage("helpurl", "info"));
        sender.sendMessage(this.plugin.getLang().getMessage("helpdiscord", "info"));
    }

    private void commandUpdate(Player player) {
        if (!this.checkPermission(player, "update", true)) {
            return;
        }
        this.debug.log("Current ArmorStandEditor Version is: " + "1.21.10-49.3");
        if ("1.21.10-49.3".contains(".x")) {
            this.debug.log("Plugin version is DEVELOPMENT");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Update Checker will not work on Development Versions.");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Report all bugs to: https://github.com/Wolfieheart/ArmorStandEditor/issues");
        } else if (!this.plugin.getHasFolia() && this.plugin.getRunTheUpdateChecker()) {
            this.debug.log("Plugin is on Server: Paper/Spigot or a fork thereof.");
            new UpdateChecker(this.plugin, UpdateCheckSource.SPIGOT, "94503").checkNow(new CommandSender[]{player});
        } else if (this.plugin.getHasFolia()) {
            this.debug.log("Plugin is on Folia");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Update Checker does not currently work on Folia.");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Report all bugs to: https://github.com/Wolfieheart/ArmorStandEditor/issues");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Update Checker is not enabled on this server");
        }
    }

    private void commandVersion(Player player) {
        this.debug.log("Player '" + player.getDisplayName() + "' permission check for asedit.update: " + this.getPermissionUpdate(player));
        if (!this.getPermissionUpdate(player)) {
            return;
        }
        String verString = "1.21.10-49.3";
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Version: " + verString);
    }

    private void commandVersionConsole(CommandSender sender) {
        String verString = "1.21.10-49.3";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ArmorStandEditor] Version: " + verString);
    }

    private void commandReload(Player player) {
        this.debug.log("Player '" + player.getDisplayName() + "' permission check for asedit.reload: " + this.getPermissionReload(player));
        if (!this.getPermissionReload(player)) {
            return;
        }
        this.debug.log("Performing reload of config.yml");
        this.plugin.performReload();
        player.sendMessage(this.plugin.getLang().getMessage("reloaded", ""));
    }

    private void commandReloadConsole(CommandSender sender) {
        this.debug.log("Console has decided to reload the plugin....");
        this.plugin.performReload();
        sender.sendMessage(this.plugin.getLang().getMessage("reloaded", "info"));
    }

    private void commandStats(Player player) {
        this.debug.log("Player '" + player.getDisplayName() + "' permission check for asedit.stats: " + this.getPermissionStats(player));
        if (this.getPermissionStats(player)) {
            for (Entity e : player.getNearbyEntities(1.0, 1.0, 1.0)) {
                if (!(e instanceof ArmorStand)) continue;
                ArmorStand as = (ArmorStand)e;
                double headX = as.getHeadPose().getX();
                headX = Math.toDegrees(headX);
                headX = Math.rint(headX);
                double headY = as.getHeadPose().getY();
                headY = Math.toDegrees(headY);
                headY = Math.rint(headY);
                double headZ = as.getHeadPose().getZ();
                headZ = Math.toDegrees(headZ);
                headZ = Math.rint(headZ);
                double bodyX = as.getBodyPose().getX();
                bodyX = Math.toDegrees(bodyX);
                bodyX = Math.rint(bodyX);
                double bodyY = as.getBodyPose().getY();
                bodyY = Math.toDegrees(bodyY);
                bodyY = Math.rint(bodyY);
                double bodyZ = as.getBodyPose().getZ();
                bodyZ = Math.toDegrees(bodyZ);
                bodyZ = Math.rint(bodyZ);
                double rightArmY = as.getRightArmPose().getY();
                rightArmY = Math.toDegrees(rightArmY);
                rightArmY = Math.rint(rightArmY);
                double rightArmZ = as.getRightArmPose().getZ();
                rightArmZ = Math.toDegrees(rightArmZ);
                rightArmZ = Math.rint(rightArmZ);
                double rightArmX = as.getRightArmPose().getX();
                rightArmX = Math.toDegrees(rightArmX);
                rightArmX = Math.rint(rightArmX);
                double leftArmX = as.getLeftArmPose().getX();
                leftArmX = Math.toDegrees(leftArmX);
                leftArmX = Math.rint(leftArmX);
                double leftArmY = as.getLeftArmPose().getY();
                leftArmY = Math.toDegrees(leftArmY);
                leftArmY = Math.rint(leftArmY);
                double leftArmZ = as.getLeftArmPose().getZ();
                leftArmZ = Math.toDegrees(leftArmZ);
                leftArmZ = Math.rint(leftArmZ);
                double rightLegX = as.getRightLegPose().getX();
                rightLegX = Math.toDegrees(rightLegX);
                rightLegX = Math.rint(rightLegX);
                double rightLegY = as.getRightLegPose().getY();
                rightLegY = Math.toDegrees(rightLegY);
                rightLegY = Math.rint(rightLegY);
                double rightLegZ = as.getRightLegPose().getZ();
                rightLegZ = Math.toDegrees(rightLegZ);
                rightArmX = Math.rint(rightLegZ);
                double leftLegX = as.getLeftLegPose().getX();
                leftLegX = Math.toDegrees(leftLegX);
                leftLegX = Math.rint(leftLegX);
                double leftLegY = as.getLeftLegPose().getY();
                leftLegY = Math.toDegrees(leftLegY);
                leftLegY = Math.rint(leftLegY);
                double leftLegZ = as.getLeftLegPose().getZ();
                leftLegZ = Math.toDegrees(leftLegZ);
                leftLegZ = Math.rint(leftLegZ);
                double sizeAttribute = VersionUtil.isAtLeast(this.plugin.getNmsVersion(), "1.21.4") ? Objects.requireNonNull(as.getAttribute(Attribute.SCALE)).getBaseValue() : 0.0;
                float locationX = (float)as.getLocation().getX();
                float locationY = (float)as.getLocation().getY();
                float locationZ = (float)as.getLocation().getZ();
                boolean isVisible = as.isVisible();
                boolean armsVisible = as.hasArms();
                boolean basePlateVisible = as.hasBasePlate();
                boolean isVulnerable = as.isInvulnerable();
                boolean hasGravity = as.hasGravity();
                boolean isSmall = as.isSmall();
                boolean isGlowing = as.isGlowing();
                boolean isLocked = this.plugin.scoreboard.getTeam(this.plugin.lockedTeam).hasEntry(as.getUniqueId().toString());
                boolean isInUse = this.plugin.scoreboard.getTeam(this.plugin.inUseTeam).hasEntry(as.getUniqueId().toString());
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "----------- Armor Stand Statistics -----------");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + this.plugin.getLang().getMessage("stats"));
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Head: " + String.valueOf(ChatColor.AQUA) + headX + " / " + headY + " / " + headZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Body: " + String.valueOf(ChatColor.AQUA) + bodyX + " / " + bodyY + " / " + bodyZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Right Arm: " + String.valueOf(ChatColor.AQUA) + rightArmX + " / " + rightArmY + " / " + rightArmZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Left Arm: " + String.valueOf(ChatColor.AQUA) + leftArmX + " / " + leftArmY + " / " + leftArmZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Right Leg: " + String.valueOf(ChatColor.AQUA) + rightLegX + " / " + rightLegY + " / " + rightLegZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Left Leg: " + String.valueOf(ChatColor.AQUA) + leftLegX + " / " + leftLegY + " / " + leftLegZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Coordinates: " + String.valueOf(ChatColor.AQUA) + "X: " + locationX + " / Y: " + locationY + " / Z: " + locationZ);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Is Visible: " + String.valueOf(ChatColor.AQUA) + isVisible + ". " + String.valueOf(ChatColor.YELLOW) + "Arms Visible: " + String.valueOf(ChatColor.AQUA) + armsVisible + ". " + String.valueOf(ChatColor.YELLOW) + "Base Plate Visible: " + String.valueOf(ChatColor.AQUA) + basePlateVisible);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Is Vulnerable: " + String.valueOf(ChatColor.AQUA) + isVulnerable + ". " + String.valueOf(ChatColor.YELLOW) + "Affected by Gravity: " + String.valueOf(ChatColor.AQUA) + hasGravity);
                if (VersionUtil.isAtLeast(this.plugin.getNmsVersion(), "1.21.4")) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Size: " + String.valueOf(ChatColor.AQUA) + sizeAttribute + "/" + this.plugin.getMaxScaleValue() + ". " + String.valueOf(ChatColor.YELLOW) + "Is Glowing: " + String.valueOf(ChatColor.AQUA) + isGlowing + ". " + String.valueOf(ChatColor.YELLOW) + "Is Locked: " + String.valueOf(ChatColor.AQUA) + isLocked + ". " + String.valueOf(ChatColor.YELLOW) + "Is InUse: " + String.valueOf(ChatColor.AQUA) + isInUse);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Is Small: " + String.valueOf(ChatColor.AQUA) + isSmall + ". " + String.valueOf(ChatColor.YELLOW) + "Is Glowing: " + String.valueOf(ChatColor.AQUA) + isGlowing + ". " + String.valueOf(ChatColor.YELLOW) + "Is Locked: " + String.valueOf(ChatColor.AQUA) + isLocked + ". " + String.valueOf(ChatColor.YELLOW) + "Is InUse: " + String.valueOf(ChatColor.AQUA) + isInUse);
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "----------------------------------------------");
            }
        } else {
            player.sendMessage(this.plugin.getLang().getMessage("norangeforstats", "warn"));
        }
    }

    private boolean checkPermission(Player player, String permName, boolean sendMessageOnInvalidation) {
        if (permName.equalsIgnoreCase("paste")) {
            permName = "copy";
        }
        if (player.hasPermission("asedit." + permName.toLowerCase())) {
            return true;
        }
        if (sendMessageOnInvalidation) {
            player.sendMessage(this.plugin.getLang().getMessage("noperm", "warn"));
        }
        return false;
    }

    private boolean getPermissionBasic(Player player) {
        return this.checkPermission(player, "basic", false);
    }

    private boolean getPermissionGive(Player player) {
        return this.checkPermission(player, "give", false);
    }

    private boolean getPermissionUpdate(Player player) {
        return this.checkPermission(player, "update", false);
    }

    private boolean getPermissionReload(Player player) {
        return this.checkPermission(player, "reload", false);
    }

    private boolean getPermissionPlayerHead(Player player) {
        return this.checkPermission(player, "head", false);
    }

    private boolean getPermissionStats(Player player) {
        return this.checkPermission(player, "stats", false);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> argList = new ArrayList<String>();
        Player player = (Player)sender;
        if (this.isCommandValid(command.getName())) {
            if (args.length == 1) {
                argList.add("mode");
                argList.add("axis");
                argList.add("adj");
                argList.add("slot");
                argList.add("help");
                argList.add("?");
                if (this.getPermissionGive(player)) {
                    argList.add("give");
                }
                if (this.getPermissionUpdate(player)) {
                    argList.add("update");
                }
                if (this.getPermissionReload(player)) {
                    argList.add("reload");
                }
                if (this.getPermissionPlayerHead(player) || this.plugin.getallowedToRetrieveOwnPlayerHead()) {
                    argList.add("playerhead");
                }
                if (this.getPermissionStats(player)) {
                    argList.add("stats");
                }
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("mode")) {
                argList.addAll(this.getModeOptions());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("axis")) {
                argList.addAll(this.getAxisOptions());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("slot")) {
                argList.addAll(this.getSlotOptions());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("adj")) {
                argList.addAll(this.getAdjOptions());
            }
            return argList.stream().filter(a -> a.startsWith(args[0])).toList();
        }
        return Collections.emptyList();
    }

    private boolean isCommandValid(String commandName) {
        return commandName.equalsIgnoreCase("ase") || commandName.equalsIgnoreCase("armorstandeditor") || commandName.equalsIgnoreCase("asedit");
    }

    private List<String> getModeOptions() {
        return List.of("None", "Invisible", "ShowArms", "Gravity", "BasePlate", "Size", "Copy", "Paste", "Head", "Body", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "Placement", "DisableSlots", "Rotate", "Equipment", "Reset", "ItemFrame", "ItemFrameGlow", "Vulnerability", "ArmorStandGlow");
    }

    private List<String> getAxisOptions() {
        return List.of("X", "Y", "Z");
    }

    private List<String> getSlotOptions() {
        return List.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    }

    private List<String> getAdjOptions() {
        return List.of("Coarse", "Fine");
    }
}

