/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.PlayerEditorManager;
import io.github.rypofalem.armorstandeditor.Scheduler;
import io.github.rypofalem.armorstandeditor.Util;
import io.github.rypofalem.armorstandeditor.VersionUtil;
import io.github.rypofalem.armorstandeditor.api.ArmorStandManipulatedEvent;
import io.github.rypofalem.armorstandeditor.api.ArmorStandTargetedEvent;
import io.github.rypofalem.armorstandeditor.api.ItemFrameManipulatedEvent;
import io.github.rypofalem.armorstandeditor.api.ItemFrameTargetedEvent;
import io.github.rypofalem.armorstandeditor.api.PlayerOpenMenuEvent;
import io.github.rypofalem.armorstandeditor.menu.EquipmentMenu;
import io.github.rypofalem.armorstandeditor.menu.Menu;
import io.github.rypofalem.armorstandeditor.menu.PresetArmorPosesMenu;
import io.github.rypofalem.armorstandeditor.menu.SizeMenu;
import io.github.rypofalem.armorstandeditor.modes.AdjustmentMode;
import io.github.rypofalem.armorstandeditor.modes.ArmorStandData;
import io.github.rypofalem.armorstandeditor.modes.Axis;
import io.github.rypofalem.armorstandeditor.modes.CopySlots;
import io.github.rypofalem.armorstandeditor.modes.EditMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.EulerAngle;

public class PlayerEditor {
    public ArmorStandEditorPlugin plugin;
    private Debug debug;
    Team team;
    private UUID uuid;
    public UUID armorStandInUseId;
    UUID armorStandID;
    EditMode eMode;
    AdjustmentMode adjMode;
    CopySlots copySlots;
    Axis axis;
    double eulerAngleChange;
    double degreeAngleChange;
    double movChange;
    Menu chestMenu;
    ArmorStand target;
    ArrayList<ArmorStand> targetList = null;
    ItemFrame frameTarget;
    ArrayList<ItemFrame> frameTargetList = null;
    int targetIndex = 0;
    int frameTargetIndex = 0;
    EquipmentMenu equipMenu;
    PresetArmorPosesMenu presetPoseMenu;
    SizeMenu sizeModificationMenu;
    long lastCancelled = 0L;

    public PlayerEditor(UUID uuid, ArmorStandEditorPlugin plugin) {
        this.uuid = uuid;
        this.plugin = plugin;
        this.debug = new Debug(plugin);
        this.eMode = EditMode.NONE;
        this.adjMode = AdjustmentMode.COARSE;
        this.axis = Axis.X;
        this.copySlots = new CopySlots();
        this.eulerAngleChange = this.getManager().coarseAdj;
        this.degreeAngleChange = this.eulerAngleChange / Math.PI * 180.0;
        this.movChange = this.getManager().coarseMov;
        this.chestMenu = new Menu(this);
    }

    public void setMode(EditMode editMode) {
        this.eMode = editMode;
        this.debug.log("EditMode is: " + editMode.toString().toLowerCase());
        this.sendMessage("setmode", editMode.toString().toLowerCase());
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
        this.debug.log("Axis is: " + axis.toString().toLowerCase());
        this.sendMessage("setaxis", axis.toString().toLowerCase());
    }

    public void setAdjMode(AdjustmentMode adjMode) {
        this.adjMode = adjMode;
        if (adjMode == AdjustmentMode.COARSE) {
            this.eulerAngleChange = this.getManager().coarseAdj;
            this.movChange = this.getManager().coarseMov;
        } else {
            this.eulerAngleChange = this.getManager().fineAdj;
            this.movChange = this.getManager().fineMov;
        }
        this.degreeAngleChange = this.eulerAngleChange / Math.PI * 180.0;
        this.debug.log("AdjMode is: " + adjMode.toString().toLowerCase());
        this.sendMessage("setadj", adjMode.toString().toLowerCase());
    }

    public void setCopySlot(byte slot) {
        this.copySlots.changeSlots(slot);
        this.debug.log("Copy Slot set to: " + (slot + 1));
        this.sendMessage("setslot", String.valueOf(slot + 1));
    }

    public void editArmorStand(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.basic")) {
            armorStand = this.attemptTarget(armorStand);
            switch (this.eMode) {
                case LEFTARM: {
                    armorStand.setLeftArmPose(this.subEulerAngle(armorStand.getLeftArmPose()));
                    break;
                }
                case RIGHTARM: {
                    armorStand.setRightArmPose(this.subEulerAngle(armorStand.getRightArmPose()));
                    break;
                }
                case BODY: {
                    armorStand.setBodyPose(this.subEulerAngle(armorStand.getBodyPose()));
                    break;
                }
                case HEAD: {
                    armorStand.setHeadPose(this.subEulerAngle(armorStand.getHeadPose()));
                    break;
                }
                case LEFTLEG: {
                    armorStand.setLeftLegPose(this.subEulerAngle(armorStand.getLeftLegPose()));
                    break;
                }
                case RIGHTLEG: {
                    armorStand.setRightLegPose(this.subEulerAngle(armorStand.getRightLegPose()));
                    break;
                }
                case SHOWARMS: {
                    this.toggleArms(armorStand);
                    break;
                }
                case SIZE: {
                    this.chooseSize(armorStand);
                    break;
                }
                case INVISIBLE: {
                    this.toggleVisible(armorStand);
                    break;
                }
                case BASEPLATE: {
                    this.togglePlate(armorStand);
                    break;
                }
                case GRAVITY: {
                    this.toggleGravity(armorStand);
                    break;
                }
                case COPY: {
                    this.copy(armorStand);
                    break;
                }
                case PASTE: {
                    this.paste(armorStand);
                    break;
                }
                case PLACEMENT: {
                    this.move(armorStand);
                    break;
                }
                case ROTATE: {
                    this.rotate(armorStand);
                    break;
                }
                case DISABLESLOTS: {
                    this.toggleDisableSlots(armorStand);
                    break;
                }
                case VULNERABILITY: {
                    this.toggleInvulnerability(armorStand);
                    break;
                }
                case EQUIPMENT: {
                    this.openEquipment(armorStand);
                    break;
                }
                case RESET: {
                    this.resetPosition(armorStand);
                    break;
                }
                case GLOWING: {
                    this.toggleGlowing(armorStand);
                    break;
                }
                case PRESET: {
                    this.choosePreset(armorStand);
                    break;
                }
                default: {
                    this.sendMessage("nomode", null);
                    break;
                }
            }
        } else {
            return;
        }
    }

    public void editItemFrame(ItemFrame itemFrame) {
        if (this.getPlayer().hasPermission("asedit.toggleitemframevisibility") || this.plugin.invisibleItemFrames) {
            ItemFrameManipulatedEvent event = new ItemFrameManipulatedEvent(itemFrame, this.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            switch (this.eMode) {
                case ITEMFRAME: {
                    this.toggleItemFrameVisible(itemFrame);
                    break;
                }
                case RESET: {
                    itemFrame.setVisible(true);
                    break;
                }
                default: {
                    this.sendMessage("nomodeif", null);
                    break;
                }
            }
        } else {
            return;
        }
    }

    private void openEquipment(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.equipment")) {
            return;
        }
        if (!this.plugin.hasFolia) {
            this.team = this.plugin.scoreboard.getTeam(this.plugin.inUseTeam);
            this.armorStandInUseId = armorStand.getUniqueId();
            this.debug.log("Is ArmorStand currently in use by another player?: " + this.team.hasEntry(this.armorStandInUseId.toString()));
            if (this.team != null && !this.team.hasEntry(this.armorStandInUseId.toString())) {
                this.debug.log("ArmorStand Not on a Team and Player '" + this.getPlayer().getDisplayName() + "' has triggered to Open the Equipment Menu, Adding to In Use Team");
                this.team.addEntry(this.armorStandInUseId.toString());
                this.getPlayer().closeInventory();
                this.equipMenu = new EquipmentMenu(this, armorStand);
                this.equipMenu.openMenu();
            } else {
                this.sendMessage("asinuse", "warn");
            }
        } else {
            this.debug.log("ArmorStand Not on a Team and Player '" + this.getPlayer().getDisplayName() + "' has triggered to Open the Equipment Menu. Folia.");
            this.getPlayer().closeInventory();
            this.equipMenu = new EquipmentMenu(this, armorStand);
            this.equipMenu.openMenu();
        }
    }

    private void choosePreset(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.basic")) {
            return;
        }
        this.debug.log("Player '" + this.getPlayer().getDisplayName() + "' has triggered the Preset Poses Menu");
        this.getPlayer().closeInventory();
        this.presetPoseMenu = new PresetArmorPosesMenu(this, armorStand);
        this.presetPoseMenu.openMenu();
    }

    private void chooseSize(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.togglesize")) {
            this.sendMessage("nopermoption", "warn", "size");
            return;
        }
        if (VersionUtil.isAtLeast(this.plugin.getNmsVersion(), "1.21.4")) {
            this.debug.log("Player '" + this.getPlayer().getDisplayName() + "' has triggered the AS Attribute Size Menu");
            this.getPlayer().closeInventory();
            this.sizeModificationMenu = new SizeMenu(this, armorStand);
            this.sizeModificationMenu.openMenu();
        } else {
            armorStand.setSmall(!armorStand.isSmall());
        }
    }

    public void reverseEditArmorStand(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.basic")) {
            return;
        }
        ArmorStandManipulatedEvent event = new ArmorStandManipulatedEvent(armorStand, this.getPlayer());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        armorStand = this.attemptTarget(armorStand);
        switch (this.eMode) {
            case LEFTARM: {
                armorStand.setLeftArmPose(this.addEulerAngle(armorStand.getLeftArmPose()));
                break;
            }
            case RIGHTARM: {
                armorStand.setRightArmPose(this.addEulerAngle(armorStand.getRightArmPose()));
                break;
            }
            case BODY: {
                armorStand.setBodyPose(this.addEulerAngle(armorStand.getBodyPose()));
                break;
            }
            case HEAD: {
                armorStand.setHeadPose(this.addEulerAngle(armorStand.getHeadPose()));
                break;
            }
            case LEFTLEG: {
                armorStand.setLeftLegPose(this.addEulerAngle(armorStand.getLeftLegPose()));
                break;
            }
            case RIGHTLEG: {
                armorStand.setRightLegPose(this.addEulerAngle(armorStand.getRightLegPose()));
                break;
            }
            case PLACEMENT: {
                this.reverseMove(armorStand);
                break;
            }
            case ROTATE: {
                this.reverseRotate(armorStand);
                break;
            }
            default: {
                this.editArmorStand(armorStand);
            }
        }
    }

    private void move(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.movement")) {
            return;
        }
        ArmorStandManipulatedEvent event = new ArmorStandManipulatedEvent(armorStand, this.getPlayer());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Location loc = armorStand.getLocation();
        switch (this.axis) {
            case X: {
                loc.add(this.movChange, 0.0, 0.0);
                break;
            }
            case Y: {
                loc.add(0.0, this.movChange, 0.0);
                break;
            }
            case Z: {
                loc.add(0.0, 0.0, this.movChange);
            }
        }
        this.debug.log("Armorstand will be teleported to: " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ", near player " + this.getPlayer().getDisplayName());
        Scheduler.teleport((Entity)armorStand, loc);
    }

    private void reverseMove(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.movement")) {
            return;
        }
        Location loc = armorStand.getLocation();
        switch (this.axis) {
            case X: {
                loc.subtract(this.movChange, 0.0, 0.0);
                break;
            }
            case Y: {
                loc.subtract(0.0, this.movChange, 0.0);
                break;
            }
            case Z: {
                loc.subtract(0.0, 0.0, this.movChange);
            }
        }
        this.debug.log("Armorstand will be teleported to: " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ", near player " + this.getPlayer().getDisplayName());
        Scheduler.teleport((Entity)armorStand, loc);
    }

    private void rotate(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.rotation")) {
            return;
        }
        Location loc = armorStand.getLocation();
        float yaw = loc.getYaw();
        loc.setYaw((yaw + 180.0f + (float)this.degreeAngleChange) % 360.0f - 180.0f);
        this.debug.log("Armorstand will be teleported to: " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ", near player " + this.getPlayer().getDisplayName());
        Scheduler.teleport((Entity)armorStand, loc);
    }

    private void reverseRotate(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.rotation")) {
            return;
        }
        Location loc = armorStand.getLocation();
        float yaw = loc.getYaw();
        loc.setYaw((yaw + 180.0f - (float)this.degreeAngleChange) % 360.0f - 180.0f);
        this.debug.log("Armorstand will be teleported to: " + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + ", near player " + this.getPlayer().getDisplayName());
        Scheduler.teleport((Entity)armorStand, loc);
    }

    private void copy(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.copy")) {
            this.copySlots.copyDataToSlot(armorStand);
            this.debug.log("ArmorStand Items, Stats and Attributes has been copied to " + (this.copySlots.currentSlot + 1) + ", near player " + this.getPlayer().getDisplayName());
            this.sendMessage("copied", "" + (this.copySlots.currentSlot + 1));
            this.setMode(EditMode.PASTE);
        } else {
            this.sendMessage("nopermoption", "warn", "copy");
        }
    }

    private void paste(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.paste")) {
            ArmorStandData data = this.copySlots.getDataToPaste();
            this.debug.log("Pasting ArmorStand Attributes and Settings from: " + (this.copySlots.currentSlot + 1) + ", near player " + this.getPlayer().getDisplayName());
            if (data == null) {
                return;
            }
            armorStand.setHeadPose(data.headPos);
            armorStand.setBodyPose(data.bodyPos);
            armorStand.setLeftArmPose(data.leftArmPos);
            armorStand.setRightArmPose(data.rightArmPos);
            armorStand.setLeftLegPose(data.leftLegPos);
            armorStand.setRightLegPose(data.rightLegPos);
            if (VersionUtil.isAtLeast(this.plugin.getNmsVersion(), "1.21.4")) {
                armorStand.getAttribute(Attribute.SCALE).setBaseValue(data.attributeScale);
            } else {
                armorStand.setSmall(data.size);
            }
            armorStand.setGravity(data.gravity);
            armorStand.setBasePlate(data.basePlate);
            armorStand.setArms(data.showArms);
            armorStand.setVisible(data.visible);
            if (this.getPlayer().getGameMode() == GameMode.CREATIVE) {
                armorStand.getEquipment().setHelmet(data.head);
                armorStand.getEquipment().setChestplate(data.body);
                armorStand.getEquipment().setLeggings(data.legs);
                armorStand.getEquipment().setBoots(data.feetsies);
                armorStand.getEquipment().setItemInMainHand(data.rightHand);
                armorStand.getEquipment().setItemInOffHand(data.leftHand);
            }
            this.sendMessage("pasted", "" + (this.copySlots.currentSlot + 1));
        } else {
            this.sendMessage("nopermoption", "warn", "paste");
        }
    }

    private void resetPosition(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.reset")) {
            this.debug.log("Resetting ArmorStand near the Player " + this.getPlayer().getDisplayName());
            armorStand.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
            armorStand.setBodyPose(new EulerAngle(0.0, 0.0, 0.0));
            armorStand.setLeftArmPose(new EulerAngle(0.0, 0.0, 0.0));
            armorStand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            armorStand.setLeftLegPose(new EulerAngle(0.0, 0.0, 0.0));
            armorStand.setRightLegPose(new EulerAngle(0.0, 0.0, 0.0));
        } else {
            this.sendMessage("nopermoption", "warn", "reset");
        }
    }

    private void toggleDisableSlots(ArmorStand armorStand) {
        if (!this.getPlayer().hasPermission("asedit.disableSlots")) {
            this.sendMessage("nopermoption", "warn", "disableslots");
        } else {
            this.debug.log("Adding DisabledSlots on ArmorStand near the Player " + this.getPlayer().getDisplayName());
            if (armorStand.hasEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.REMOVING_OR_CHANGING)) {
                this.team = Scheduler.isFolia() != false ? null : this.plugin.scoreboard.getTeam(this.plugin.lockedTeam);
                this.armorStandID = armorStand.getUniqueId();
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    armorStand.removeEquipmentLock(slot, ArmorStand.LockType.REMOVING_OR_CHANGING);
                    armorStand.removeEquipmentLock(slot, ArmorStand.LockType.ADDING);
                }
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.team != null) {
                    this.team.removeEntry(this.armorStandID.toString());
                    armorStand.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 50, 1, false, false));
                }
            } else {
                this.debug.log("Removing DisabledSlots on ArmorStand near the Player " + this.getPlayer().getDisplayName());
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    armorStand.addEquipmentLock(slot, ArmorStand.LockType.REMOVING_OR_CHANGING);
                    armorStand.addEquipmentLock(slot, ArmorStand.LockType.ADDING);
                }
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ITEM_ARMOR_EQUIP_IRON, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.team != null) {
                    this.team.addEntry(this.armorStandID.toString());
                    armorStand.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 50, 1, false, false));
                }
            }
            this.sendMessage("disabledslots", null);
        }
    }

    private void toggleInvulnerability(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.toggleInvulnerability")) {
            this.debug.log("Making an ArmorStand vulnerable/invulnerable (set armorStand.isInvulnerable() = '" + !armorStand.isInvulnerable() + "') near player: " + this.getPlayer().getDisplayName());
            armorStand.setInvulnerable(!armorStand.isInvulnerable());
            this.sendMessage("toggleinvulnerability", String.valueOf(armorStand.isInvulnerable()));
        } else {
            this.sendMessage("nopermoption", "warn", "vulnerability");
        }
    }

    private void toggleGravity(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.togglegravity")) {
            this.debug.log("Toggling the Gravity of an ArmorStand near player: " + this.getPlayer().getDisplayName());
            armorStand.setGravity(!armorStand.hasGravity());
            this.sendMessage("setgravity", String.valueOf(armorStand.hasGravity()));
        } else {
            this.sendMessage("nopermoption", "warn", "gravity");
        }
    }

    void togglePlate(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.togglebaseplate")) {
            this.debug.log("Toggling the Baseplate of an ArmorStand near player: " + this.getPlayer().getDisplayName());
            armorStand.setBasePlate(!armorStand.hasBasePlate());
        } else {
            this.sendMessage("nopermoption", "warn", "baseplate");
        }
    }

    void toggleGlowing(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.togglearmorstandglow")) {
            this.debug.log("Toggling the Glowing Ability of an ArmorStand near player: " + this.getPlayer().getDisplayName());
            armorStand.setGlowing(!armorStand.isGlowing());
        } else {
            this.sendMessage("nopermoption", "warn", "armorstandglow");
        }
    }

    void toggleArms(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.togglearms")) {
            this.debug.log("Toggling the Showing of Arms of an ArmorStand near player: " + this.getPlayer().getDisplayName());
            armorStand.setArms(!armorStand.hasArms());
        } else {
            this.sendMessage("nopermoption", "warn", "showarms");
        }
    }

    void toggleVisible(ArmorStand armorStand) {
        if (this.getPlayer().hasPermission("asedit.togglearmorstandvisibility") || this.plugin.getArmorStandVisibility()) {
            this.debug.log("Toggling the Visiblity of an ArmorStand near player: " + this.getPlayer().getDisplayName());
            armorStand.setVisible(!armorStand.isVisible());
        } else {
            this.sendMessage("nopermoption", "warn", "armorstandvisibility");
        }
    }

    void toggleItemFrameVisible(ItemFrame itemFrame) {
        if (this.getPlayer().hasPermission("asedit.toggleitemframevisibility") || this.plugin.invisibleItemFrames) {
            this.debug.log("Toggling the Visibility of an ItemFrame near player: " + this.getPlayer().getDisplayName());
            itemFrame.setVisible(!itemFrame.isVisible());
        } else {
            this.sendMessage("nopermoption", "warn", "itemframevisibility");
        }
    }

    void cycleAxis(int i) {
        int index = this.axis.ordinal();
        index += i;
        index %= Axis.values().length;
        while (index < 0) {
            index += Axis.values().length;
        }
        this.setAxis(Axis.values()[index]);
    }

    private EulerAngle addEulerAngle(EulerAngle angle) {
        switch (this.axis) {
            case X: {
                angle = angle.setX(Util.addAngle(angle.getX(), this.eulerAngleChange));
                break;
            }
            case Y: {
                angle = angle.setY(Util.addAngle(angle.getY(), this.eulerAngleChange));
                break;
            }
            case Z: {
                angle = angle.setZ(Util.addAngle(angle.getZ(), this.eulerAngleChange));
                break;
            }
        }
        return angle;
    }

    private EulerAngle subEulerAngle(EulerAngle angle) {
        switch (this.axis) {
            case X: {
                angle = angle.setX(Util.subAngle(angle.getX(), this.eulerAngleChange));
                break;
            }
            case Y: {
                angle = angle.setY(Util.subAngle(angle.getY(), this.eulerAngleChange));
                break;
            }
            case Z: {
                angle = angle.setZ(Util.subAngle(angle.getZ(), this.eulerAngleChange));
                break;
            }
        }
        return angle;
    }

    public void setTarget(ArrayList<ArmorStand> armorStands) {
        if (armorStands == null || armorStands.isEmpty()) {
            this.target = null;
            this.targetList = null;
            this.sendMessage("notarget", "armorstand");
        } else {
            if (this.targetList == null) {
                this.targetList = armorStands;
                this.targetIndex = 0;
                this.sendMessage("target", null);
            } else {
                boolean same;
                boolean bl = same = this.targetList.size() == armorStands.size();
                if (same) {
                    ArmorStand as;
                    Iterator<ArmorStand> iterator = armorStands.iterator();
                    while (iterator.hasNext() && (same = this.targetList.contains(as = iterator.next()))) {
                    }
                }
                if (same) {
                    ++this.targetIndex;
                    this.targetIndex %= this.targetList.size();
                } else {
                    this.targetList = armorStands;
                    this.targetIndex = 0;
                    this.sendMessage("target", null);
                }
            }
            ArmorStandTargetedEvent e = new ArmorStandTargetedEvent(this.targetList.get(this.targetIndex), this.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
            this.target = this.targetList.get(this.targetIndex);
            this.highlight(this.target);
        }
    }

    public void setFrameTarget(ArrayList<ItemFrame> itemFrames) {
        if (itemFrames == null || itemFrames.isEmpty()) {
            this.frameTarget = null;
            this.frameTargetList = null;
            this.sendMessage("notarget", "itemframe");
        } else if (this.frameTargetList == null) {
            this.frameTargetList = itemFrames;
            this.frameTargetIndex = 0;
            this.sendMessage("frametarget", null);
        } else {
            boolean same;
            boolean bl = same = this.frameTargetList.size() == itemFrames.size();
            if (same) {
                ItemFrame itemf;
                Iterator<ItemFrame> iterator = itemFrames.iterator();
                while (iterator.hasNext() && (same = this.frameTargetList.contains(itemf = iterator.next()))) {
                }
            }
            if (same) {
                ++this.frameTargetIndex;
                this.frameTargetIndex %= this.frameTargetList.size();
            } else {
                this.frameTargetList = itemFrames;
                this.frameTargetIndex = 0;
                this.sendMessage("frametarget", null);
            }
            ItemFrameTargetedEvent e = new ItemFrameTargetedEvent(this.frameTargetList.get(this.frameTargetIndex), this.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
            this.frameTarget = this.frameTargetList.get(this.frameTargetIndex);
        }
    }

    ArmorStand attemptTarget(ArmorStand armorStand) {
        if (this.target == null || !this.target.isValid() || this.target.getWorld() != this.getPlayer().getWorld() || this.target.getLocation().distanceSquared(this.getPlayer().getLocation()) > 100.0) {
            return armorStand;
        }
        armorStand = this.target;
        return armorStand;
    }

    void sendMessage(String path, String format, String option) {
        String message = this.plugin.getLang().getMessage(path, format, option);
        if (this.plugin.sendToActionBar) {
            if (ArmorStandEditorPlugin.instance().getHasPaper() || ArmorStandEditorPlugin.instance().getHasSpigot()) {
                this.plugin.getServer().getPlayer(this.getUUID()).spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            } else {
                String rawText = this.plugin.getLang().getRawMessage(path, format, option);
                String command = "minecraft:title %s actionbar %s".formatted(this.plugin.getServer().getPlayer(this.getUUID()).getName(), rawText);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        } else {
            this.plugin.getServer().getPlayer(this.getUUID()).sendMessage(message);
        }
    }

    void sendMessage(String path, String option) {
        this.sendMessage(path, "info", option);
    }

    private void highlight(ArmorStand armorStand) {
        armorStand.removePotionEffect(PotionEffectType.GLOWING);
        armorStand.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 50, 1, false, false));
    }

    public PlayerEditorManager getManager() {
        return this.plugin.editorManager;
    }

    public Player getPlayer() {
        return this.plugin.getServer().getPlayer(this.getUUID());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void openMenu() {
        if (!this.isMenuCancelled()) {
            Scheduler.runTaskLater((Plugin)this.plugin, new OpenMenuTask(), 1L);
        }
    }

    public void cancelOpenMenu() {
        this.lastCancelled = this.getManager().getTime();
    }

    boolean isMenuCancelled() {
        return this.getManager().getTime() - this.lastCancelled < 2L;
    }

    private class OpenMenuTask
    implements Runnable {
        private OpenMenuTask() {
        }

        @Override
        public void run() {
            if (PlayerEditor.this.isMenuCancelled()) {
                return;
            }
            PlayerOpenMenuEvent event = new PlayerOpenMenuEvent(PlayerEditor.this.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            PlayerEditor.this.chestMenu.openMenu();
        }
    }
}

