/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

import com.google.common.collect.ImmutableList;
import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.PlayerEditor;
import io.github.rypofalem.armorstandeditor.Scheduler;
import io.github.rypofalem.armorstandeditor.api.ArmorStandRenameEvent;
import io.github.rypofalem.armorstandeditor.api.ItemFrameGlowEvent;
import io.github.rypofalem.armorstandeditor.libs.paperlib.PaperLib;
import io.github.rypofalem.armorstandeditor.menu.ASEHolder;
import io.github.rypofalem.armorstandeditor.protections.BentoBoxProtection;
import io.github.rypofalem.armorstandeditor.protections.GriefDefenderProtection;
import io.github.rypofalem.armorstandeditor.protections.GriefPreventionProtection;
import io.github.rypofalem.armorstandeditor.protections.LandsProtection;
import io.github.rypofalem.armorstandeditor.protections.PlotSquaredProtection;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import io.github.rypofalem.armorstandeditor.protections.SkyblockProtection;
import io.github.rypofalem.armorstandeditor.protections.TownyProtection;
import io.github.rypofalem.armorstandeditor.protections.WorldGuardProtection;
import io.github.rypofalem.armorstandeditor.protections.itemAdderProtection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class PlayerEditorManager
implements Listener {
    private Debug debug;
    private ArmorStandEditorPlugin plugin;
    private HashMap<UUID, PlayerEditor> players;
    private ASEHolder menuHolder = new ASEHolder();
    private ASEHolder equipmentHolder = new ASEHolder();
    private ASEHolder presetHolder = new ASEHolder();
    private ASEHolder sizeMenuHolder = new ASEHolder();
    double coarseAdj;
    double fineAdj;
    double coarseMov;
    double fineMov;
    private boolean ignoreNextInteract = false;
    private TickCounter counter;
    private ArrayList<ArmorStand> as = null;
    private ArrayList<ItemFrame> itemF = null;
    private Integer noSize = 0;
    Team team;
    private final List<Protection> protections = ImmutableList.of((Object)new GriefDefenderProtection(), (Object)new GriefPreventionProtection(), (Object)new LandsProtection(), (Object)new PlotSquaredProtection(), (Object)new SkyblockProtection(), (Object)new TownyProtection(), (Object)new WorldGuardProtection(), (Object)new itemAdderProtection(), (Object)new BentoBoxProtection());

    PlayerEditorManager(ArmorStandEditorPlugin plugin) {
        this.plugin = plugin;
        this.debug = new Debug(plugin);
        this.players = new HashMap();
        this.coarseAdj = Math.PI * 2 / plugin.coarseRot;
        this.fineAdj = Math.PI * 2 / plugin.fineRot;
        this.coarseMov = 1.0;
        this.fineMov = 0.03125;
        this.counter = new TickCounter(this);
        Scheduler.runTaskTimer((Plugin)plugin, this.counter, 1L, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onArmorStandDamage(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.plugin.isEditTool(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!(event.getEntity() instanceof ArmorStand) && !(event.getEntity() instanceof ItemFrame)) {
            event.setCancelled(true);
            this.debug.log("Open Menu Called for Player: " + player.getDisplayName());
            this.getPlayerEditor(player.getUniqueId()).openMenu();
            return;
        }
        if (event.getEntity() instanceof ArmorStand) {
            this.debug.log("Player '" + player.getDisplayName() + "' has left clicked the ArmorStand");
            ArmorStand as = (ArmorStand)event.getEntity();
            this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
            event.setCancelled(true);
            if (this.canEdit(player, (Entity)as)) {
                this.applyLeftTool(player, as);
            }
        } else if (event.getEntity() instanceof ItemFrame) {
            this.debug.log(" Player '" + player.getDisplayName() + "' has right clicked on an ItemFrame");
            ItemFrame itemf = (ItemFrame)event.getEntity();
            this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
            event.setCancelled(true);
            if (this.canEdit(player, (Entity)itemf)) {
                this.applyLeftTool(player, itemf);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        if (this.ignoreNextInteract) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!(event.getRightClicked() instanceof ArmorStand) && !(event.getRightClicked() instanceof ItemFrame)) {
            return;
        }
        if (event.getRightClicked() instanceof ArmorStand) {
            this.debug.log("Player '" + player.getDisplayName() + "' has right clicked on an ArmorStand");
            ArmorStand as = (ArmorStand)event.getRightClicked();
            if (!this.canEdit(player, (Entity)as)) {
                return;
            }
            if (this.plugin.isEditTool(player.getInventory().getItemInMainHand())) {
                this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
                event.setCancelled(true);
                this.applyRightTool(player, as);
                return;
            }
            if (player.getInventory().getItemInMainHand().getType() == Material.NAME_TAG && player.hasPermission("asedit.rename")) {
                ItemStack nameTag = player.getInventory().getItemInMainHand();
                String name = nameTag.getItemMeta() != null && nameTag.getItemMeta().hasDisplayName() ? nameTag.getItemMeta().getDisplayName().replace('&', '\u00a7') : null;
                ArmorStandRenameEvent e = new ArmorStandRenameEvent(as, player, name);
                Bukkit.getPluginManager().callEvent((Event)e);
                if (e.isCancelled()) {
                    return;
                }
                if (name == null) {
                    as.setCustomName(null);
                    as.setCustomNameVisible(false);
                    event.setCancelled(true);
                } else if (name.startsWith("\u00a7") && !player.hasPermission("asedit.rename.color")) {
                    event.setCancelled(true);
                    player.sendMessage(this.plugin.getLang().getMessage("renamestopped"));
                } else if (!name.equals("")) {
                    event.setCancelled(true);
                    if (player.getGameMode() != GameMode.CREATIVE) {
                        if (nameTag.getAmount() > 1) {
                            nameTag.setAmount(nameTag.getAmount() - 1);
                        } else {
                            nameTag = new ItemStack(Material.AIR);
                        }
                        player.getInventory().setItemInMainHand(nameTag);
                    }
                    Scheduler.runTaskLater((Plugin)this.plugin, () -> {
                        as.setCustomName(name);
                        as.setCustomNameVisible(true);
                    }, 1L);
                }
            }
        } else if (event.getRightClicked() instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)event.getRightClicked();
            if (!this.canEdit(player, (Entity)itemFrame)) {
                return;
            }
            if (this.plugin.isEditTool(player.getInventory().getItemInMainHand())) {
                this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
                if (!itemFrame.getItem().getType().equals((Object)Material.AIR)) {
                    event.setCancelled(true);
                }
                this.applyRightTool(player, itemFrame);
                return;
            }
            if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.GLOW_INK_SAC) && player.hasPermission("asedit.basic") && this.plugin.glowItemFrames && player.isSneaking()) {
                ItemFrameGlowEvent e = new ItemFrameGlowEvent(itemFrame, player);
                Bukkit.getPluginManager().callEvent((Event)e);
                if (e.isCancelled()) {
                    return;
                }
                ItemStack glowSacs = player.getInventory().getItemInMainHand();
                ItemStack contents = null;
                Rotation rotation = null;
                if (itemFrame.getItem().getType() != Material.AIR) {
                    contents = itemFrame.getItem();
                    rotation = itemFrame.getRotation();
                }
                Location itemFrameLocation = itemFrame.getLocation();
                BlockFace facing = itemFrame.getFacing();
                if (player.getGameMode() != GameMode.CREATIVE) {
                    if (glowSacs.getAmount() > 1) {
                        glowSacs.setAmount(glowSacs.getAmount() - 1);
                    } else {
                        glowSacs = new ItemStack(Material.AIR);
                    }
                }
                itemFrame.remove();
                GlowItemFrame glowFrame = (GlowItemFrame)player.getWorld().spawnEntity(itemFrameLocation, EntityType.GLOW_ITEM_FRAME);
                glowFrame.setFacingDirection(facing);
                if (contents != null) {
                    glowFrame.setItem(contents);
                    glowFrame.setRotation(rotation);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    void onArmorStandBreak(EntityDamageByEntityEvent event) {
        Player p;
        Entity entity;
        ArmorStand entityAS;
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof ArmorStand)) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof ArmorStand && (entityAS = (ArmorStand)entity2).isInvulnerable() && (entity = event.getDamager()) instanceof Player && (p = (Player)entity).getGameMode() == GameMode.CREATIVE) {
            p.sendMessage(this.plugin.getLang().getMessage("unabledestroycreative"));
            event.setCancelled(true);
        }
        if ((entity2 = event.getEntity()) instanceof ArmorStand && (entityAS = (ArmorStand)entity2).isDead()) {
            event.getEntity().setCustomName(null);
            event.getEntity().setCustomNameVisible(false);
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSwitchHands(PlayerSwapHandItemsEvent event) {
        this.debug.log("PlayerSwapHandItemsEvent trigger for Player: " + event.getPlayer().getDisplayName());
        if (!this.plugin.isEditTool(event.getOffHandItem())) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        this.as = this.getTargets(player);
        this.itemF = this.getFrameTargets(player);
        if (this.as != null && this.itemF != null && !this.as.isEmpty() && !this.itemF.isEmpty()) {
            this.getPlayerEditor(player.getUniqueId()).sendMessage("doubletarget", "warn");
        } else if (this.as != null && !this.as.isEmpty()) {
            this.getPlayerEditor(player.getUniqueId()).setTarget(this.as);
        } else if (this.itemF != null && !this.itemF.isEmpty()) {
            this.getPlayerEditor(player.getUniqueId()).setFrameTarget(this.itemF);
        } else {
            this.getPlayerEditor(player.getUniqueId()).sendMessage("nodoubletarget", "warn");
        }
    }

    private ArrayList<ArmorStand> getTargets(Player player) {
        Location eyeLaser = player.getEyeLocation();
        Vector direction = player.getLocation().getDirection();
        ArrayList<ArmorStand> armorStands = new ArrayList<ArmorStand>();
        double STEPSIZE = 0.5;
        Vector STEP = direction.multiply(STEPSIZE);
        double RANGE = 10.0;
        double LASERRADIUS = 0.3;
        List nearbyEntities = player.getNearbyEntities(RANGE, RANGE, RANGE);
        if (nearbyEntities.isEmpty()) {
            return null;
        }
        for (double i = 0.0; i < RANGE; i += STEPSIZE) {
            List nearby = (List)player.getWorld().getNearbyEntities(eyeLaser, LASERRADIUS, LASERRADIUS, LASERRADIUS);
            if (!nearby.isEmpty()) {
                boolean endLaser = false;
                for (Entity e : nearby) {
                    if (!(e instanceof ArmorStand)) continue;
                    ArmorStand stand = (ArmorStand)e;
                    armorStands.add(stand);
                    endLaser = true;
                }
                if (endLaser) break;
            }
            if (eyeLaser.getBlock().getType().isSolid()) break;
            eyeLaser.add(STEP);
        }
        return armorStands;
    }

    private ArrayList<ItemFrame> getFrameTargets(Player player) {
        Location eyeLaser = player.getEyeLocation();
        Vector direction = player.getLocation().getDirection();
        ArrayList<ItemFrame> itemFrames = new ArrayList<ItemFrame>();
        double STEPSIZE = 0.5;
        Vector STEP = direction.multiply(STEPSIZE);
        double RANGE = 10.0;
        double LASERRADIUS = 0.3;
        List nearbyEntities = player.getNearbyEntities(RANGE, RANGE, RANGE);
        if (nearbyEntities.isEmpty()) {
            return null;
        }
        for (double i = 0.0; i < RANGE; i += STEPSIZE) {
            List nearby = (List)player.getWorld().getNearbyEntities(eyeLaser, LASERRADIUS, LASERRADIUS, LASERRADIUS);
            if (!nearby.isEmpty()) {
                boolean endLaser = false;
                for (Entity e : nearby) {
                    if (!(e instanceof ItemFrame)) continue;
                    ItemFrame frame = (ItemFrame)e;
                    itemFrames.add(frame);
                    endLaser = true;
                }
                if (endLaser) break;
            }
            if (eyeLaser.getBlock().getType().isSolid()) break;
            eyeLaser.add(STEP);
        }
        return itemFrames;
    }

    boolean canEdit(Player player, Entity entity) {
        Block block = entity.getLocation().getBlock();
        return this.protections.stream().allMatch(protection -> protection.checkPermission(block, player));
    }

    void applyLeftTool(Player player, ArmorStand as) {
        this.debug.log("Applying Left Tool on ArmorStand for Player: " + player.getDisplayName());
        this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
        this.getPlayerEditor(player.getUniqueId()).editArmorStand(as);
    }

    void applyLeftTool(Player player, ItemFrame itemf) {
        this.debug.log("Applying Left Tool on ItemFrame for Player: " + player.getDisplayName());
        this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
        this.getPlayerEditor(player.getUniqueId()).editItemFrame(itemf);
    }

    void applyRightTool(Player player, ItemFrame itemf) {
        this.debug.log("Applying Right Tool on ItemFrame for Player: " + player.getDisplayName());
        this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
        this.getPlayerEditor(player.getUniqueId()).editItemFrame(itemf);
    }

    void applyRightTool(Player player, ArmorStand as) {
        this.debug.log("Applying Right Tool on ArmorStand for Player: " + player.getDisplayName());
        this.getPlayerEditor(player.getUniqueId()).cancelOpenMenu();
        this.getPlayerEditor(player.getUniqueId()).reverseEditArmorStand(as);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onRightClickTool(PlayerInteractEvent e) {
        if (e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        this.debug.log("Ran on Right Click Tool Event.");
        Player player = e.getPlayer();
        if (!this.plugin.isEditTool(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (this.plugin.requireSneaking && !player.isSneaking()) {
            return;
        }
        if (!player.hasPermission("asedit.basic")) {
            return;
        }
        if (this.plugin.enablePerWorld && !this.plugin.allowedWorldList.contains(player.getWorld().getName())) {
            this.getPlayerEditor(player.getUniqueId()).sendMessage("notincorrectworld", "warn");
            e.setCancelled(true);
            return;
        }
        e.setCancelled(true);
        this.debug.log("Open Menu Called for Player: " + player.getDisplayName());
        this.getPlayerEditor(player.getUniqueId()).openMenu();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    void onScrollNCrouch(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (!this.plugin.isEditTool(player.getInventory().getItem(e.getPreviousSlot()))) {
            return;
        }
        e.setCancelled(true);
        if (e.getNewSlot() == e.getPreviousSlot() + 1 || e.getNewSlot() == 0 && e.getPreviousSlot() == 8) {
            this.getPlayerEditor(player.getUniqueId()).cycleAxis(1);
        } else if (e.getNewSlot() == e.getPreviousSlot() - 1 || e.getNewSlot() == 8 && e.getPreviousSlot() == 0) {
            this.getPlayerEditor(player.getUniqueId()).cycleAxis(-1);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onPlayerMenuSelect(InventoryClickEvent e) {
        PlayerEditor pe;
        String itemName;
        Player player;
        ItemStack item;
        InventoryHolder holder = PaperLib.getHolder(e.getInventory(), false).getHolder();
        if (holder == null) {
            return;
        }
        if (!(holder instanceof ASEHolder)) {
            return;
        }
        if (holder == this.menuHolder) {
            e.setCancelled(true);
            item = e.getCurrentItem();
            if (item != null && item.hasItemMeta()) {
                player = (Player)e.getWhoClicked();
                String command = (String)item.getItemMeta().getPersistentDataContainer().get(this.plugin.getIconKey(), PersistentDataType.STRING);
                if (command.equals("ase ") || command == null) {
                    this.getPlayerEditor(player.getUniqueId()).sendMessage("blackGlassClick", "");
                    return;
                }
                if (command != null) {
                    player.performCommand(command);
                    return;
                }
            }
        }
        if (holder == this.equipmentHolder) {
            item = e.getCurrentItem();
            if (item == null) {
                return;
            }
            if (item.getItemMeta() == null) {
                return;
            }
            if (item.getItemMeta().getPersistentDataContainer().has(this.plugin.getIconKey(), PersistentDataType.STRING)) {
                e.setCancelled(true);
            }
        }
        if (holder == this.presetHolder) {
            e.setCancelled(true);
            item = e.getCurrentItem();
            if (item != null && item.hasItemMeta()) {
                player = (Player)e.getWhoClicked();
                itemName = item.getItemMeta().getDisplayName();
                pe = this.players.get(player.getUniqueId());
                pe.presetPoseMenu.handlePresetPose(itemName, player);
            }
        }
        if (holder == this.sizeMenuHolder) {
            e.setCancelled(true);
            item = e.getCurrentItem();
            if (item != null && item.hasItemMeta()) {
                player = (Player)e.getWhoClicked();
                itemName = item.getItemMeta().getDisplayName();
                pe = this.players.get(player.getUniqueId());
                pe.sizeModificationMenu.handleAttributeScaling(itemName, player);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onPlayerMenuClose(InventoryCloseEvent e) {
        InventoryHolder holder = PaperLib.getHolder(e.getInventory(), false).getHolder();
        if (holder == null) {
            return;
        }
        if (!(holder instanceof ASEHolder)) {
            return;
        }
        if (holder == this.equipmentHolder) {
            PlayerEditor pe = this.players.get(e.getPlayer().getUniqueId());
            pe.equipMenu.equipArmorstand();
            if (!Scheduler.isFolia().booleanValue()) {
                this.team = this.plugin.scoreboard.getTeam(this.plugin.inUseTeam);
                if (this.team != null) {
                    this.team.removeEntry(pe.armorStandInUseId.toString());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerLogOut(PlayerQuitEvent e) {
        this.removePlayerEditor(e.getPlayer().getUniqueId());
    }

    public PlayerEditor getPlayerEditor(UUID uuid) {
        return this.players.containsKey(uuid) ? this.players.get(uuid) : this.addPlayerEditor(uuid);
    }

    PlayerEditor addPlayerEditor(UUID uuid) {
        PlayerEditor pe = new PlayerEditor(uuid, this.plugin);
        this.players.put(uuid, pe);
        return pe;
    }

    private void removePlayerEditor(UUID uuid) {
        this.players.remove(uuid);
    }

    public ASEHolder getMenuHolder() {
        return this.menuHolder;
    }

    public ASEHolder getEquipmentHolder() {
        return this.equipmentHolder;
    }

    public ASEHolder getSizeMenuHolder() {
        return this.sizeMenuHolder;
    }

    public ASEHolder getPresetHolder() {
        return this.presetHolder;
    }

    long getTime() {
        return this.counter.ticks;
    }

    class TickCounter
    implements Runnable {
        long ticks = 0L;

        TickCounter(PlayerEditorManager this$0) {
        }

        @Override
        public void run() {
            ++this.ticks;
        }

        public long getTime() {
            return this.ticks;
        }
    }
}

