/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

import io.github.rypofalem.armorstandeditor.libs.paperlib.PaperLib;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class Scheduler {
    private static Boolean IS_FOLIA = null;
    private static Object GLOBAL_REGION_SCHEDULER = null;

    public static <T> T callMethod(Class<?> clazz, Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return (T)clazz.getDeclaredMethod(methodName, parameterTypes).invoke(object, args);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public static <T> T callMethod(Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        return Scheduler.callMethod(object.getClass(), object, methodName, parameterTypes, args);
    }

    public static <T> T callMethod(Class<?> clazz, String methodName) {
        return Scheduler.callMethod(clazz, null, methodName, new Class[0], new Object[0]);
    }

    private static boolean methodExist(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            clazz.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.ThreadedRegionizer");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Object getGlobalRegionScheduler() {
        if (GLOBAL_REGION_SCHEDULER == null) {
            GLOBAL_REGION_SCHEDULER = Scheduler.callMethod(Bukkit.class, "getGlobalRegionScheduler");
        }
        return GLOBAL_REGION_SCHEDULER;
    }

    public static void runTask(Plugin plugin, Runnable runnable) {
        if (Scheduler.isFolia().booleanValue()) {
            Object globalRegionScheduler = Scheduler.getGlobalRegionScheduler();
            Scheduler.callMethod(globalRegionScheduler, "run", new Class[]{Plugin.class, Consumer.class}, plugin, task -> runnable.run());
            return;
        }
        Bukkit.getScheduler().runTask(plugin, runnable);
    }

    public static void runTaskTimer(Plugin plugin, Runnable runnable, long initialDelayTicks, long periodTicks) {
        if (Scheduler.isFolia().booleanValue()) {
            Object globalRegionScheduler = Scheduler.getGlobalRegionScheduler();
            Scheduler.callMethod(globalRegionScheduler, "runAtFixedRate", new Class[]{Plugin.class, Consumer.class, Long.TYPE, Long.TYPE}, plugin, task -> runnable.run(), initialDelayTicks, periodTicks);
            return;
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, runnable, initialDelayTicks, periodTicks);
    }

    public static void runTaskLater(Plugin plugin, Runnable runnable, long delayedTicks) {
        if (Scheduler.isFolia().booleanValue()) {
            Object globalRegionScheduler = Scheduler.getGlobalRegionScheduler();
            Scheduler.callMethod(globalRegionScheduler, "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE}, plugin, task -> runnable.run(), delayedTicks);
            return;
        }
        Bukkit.getScheduler().runTaskLater(plugin, runnable, delayedTicks);
    }

    public static void teleport(Entity entity, Location location) {
        if (Scheduler.isFolia().booleanValue()) {
            PaperLib.teleportAsync(entity, location);
        } else {
            entity.teleport(location);
        }
    }
}

