/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

public abstract class Util {
    public static final double FULL_CIRCLE = Math.PI * 2;

    public static <T extends Enum<?>> String getEnumList(Class<T> enumType) {
        return Util.getEnumList(enumType, " | ");
    }

    public static <T extends Enum<?>> String getEnumList(Class<T> enumType, String delimiter) {
        StringBuilder list = new StringBuilder();
        boolean put = false;
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            list.append(e.toString()).append(delimiter);
            put = true;
        }
        if (put) {
            list = new StringBuilder(list.substring(0, list.length() - delimiter.length()));
        }
        return list.toString();
    }

    public static double addAngle(double current, double angleChange) {
        current += angleChange;
        current = Util.fixAngle(current, angleChange);
        return current;
    }

    public static double subAngle(double current, double angleChange) {
        current -= angleChange;
        current = Util.fixAngle(current, angleChange);
        return current;
    }

    private static double fixAngle(double angle, double angleChange) {
        if (angle > Math.PI * 2) {
            return 0.0;
        }
        if (angle > 0.0 && angle < angleChange && angle < angleChange / 2.0) {
            return 0.0;
        }
        if (angle > Math.PI * 2 - angle && angle > Math.PI * 2 - angleChange / 2.0) {
            return 0.0;
        }
        return angle;
    }
}

