/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor;

public final class VersionUtil {
    private VersionUtil() {
    }

    public static boolean isAtLeast(String current, String target) {
        String normCurrent = VersionUtil.normalize(current);
        String normTarget = VersionUtil.normalize(target);
        int[] curParts = VersionUtil.parseVersion(normCurrent);
        int[] tarParts = VersionUtil.parseVersion(normTarget);
        int len = Math.max(curParts.length, tarParts.length);
        for (int i = 0; i < len; ++i) {
            int t;
            int c = i < curParts.length ? curParts[i] : 0;
            int n = t = i < tarParts.length ? tarParts[i] : 0;
            if (c == t) continue;
            return c > t;
        }
        return true;
    }

    private static String normalize(String version) {
        String body;
        String[] parts;
        if (version == null) {
            return "0.0.0";
        }
        if ((version = version.trim()).startsWith("v") && version.contains("_") && (parts = (body = version.substring(1)).split("_")).length >= 3) {
            int patch;
            String majorStr = VersionUtil.digitsOnly(parts[0]);
            String minorStr = VersionUtil.digitsOnly(parts[1]);
            String rStr = VersionUtil.digitsOnly(parts[2]);
            int major = VersionUtil.parseIntOrZero(majorStr);
            int minor = VersionUtil.parseIntOrZero(minorStr);
            int r = VersionUtil.parseIntOrZero(rStr);
            if (major == 1 && minor == 21) {
                switch (r) {
                    case 1: {
                        patch = 0;
                        break;
                    }
                    case 2: {
                        patch = 2;
                        break;
                    }
                    case 3: {
                        patch = 4;
                        break;
                    }
                    case 4: {
                        patch = 5;
                        break;
                    }
                    case 5: {
                        patch = 6;
                        break;
                    }
                    default: {
                        patch = 6;
                        break;
                    }
                }
            } else {
                patch = 0;
            }
            return major + "." + minor + "." + patch;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c >= '0' && c <= '9' || c == '.') {
                sb.append(c);
                continue;
            }
            if (sb.length() > 0) break;
        }
        if (sb.length() == 0) {
            return "0.0.0";
        }
        String[] nums = sb.toString().split("\\.");
        if (nums.length == 1) {
            return nums[0] + ".0.0";
        }
        if (nums.length == 2) {
            return nums[0] + "." + nums[1] + ".0";
        }
        return sb.toString();
    }

    private static String digitsOnly(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static int parseIntOrZero(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int[] parseVersion(String version) {
        String[] parts = version.split("\\.");
        int[] result = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                result[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                result[i] = 0;
            }
        }
        return result;
    }
}

