/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.language;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class Language {
    final String DEFAULT_LANG = "en_US.yml";
    private YamlConfiguration langConfig = null;
    private YamlConfiguration defConfig = null;
    private File langFile = null;
    ArmorStandEditorPlugin plugin;

    public Language(String langFileName, ArmorStandEditorPlugin plugin) {
        this.plugin = plugin;
        this.reloadLang(langFileName);
    }

    public void reloadLang(String langFileName) {
        if (langFileName == null) {
            langFileName = "en_US.yml";
        }
        File langFolder = new File(this.plugin.getDataFolder().getPath() + File.separator + "lang");
        this.langFile = new File(langFolder, langFileName);
        InputStream input = this.plugin.getResource("lang/en_US.yml");
        assert (input != null);
        InputStreamReader defaultLangStream = new InputStreamReader(input, StandardCharsets.UTF_8);
        this.defConfig = YamlConfiguration.loadConfiguration((Reader)defaultLangStream);
        input = null;
        try {
            input = new FileInputStream(this.langFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        InputStreamReader langStream = new InputStreamReader(input, StandardCharsets.UTF_8);
        this.langConfig = YamlConfiguration.loadConfiguration((Reader)langStream);
    }

    public String getMessage(String path, String format, String option) {
        if (this.langConfig == null) {
            this.reloadLang(this.langFile.getName());
        }
        if (path == null) {
            return "";
        }
        if (option == null) {
            option = "";
        }
        format = this.getFormat((String)format);
        for (int i = 0; i < ((String)format).length(); i += 2) {
            format = ((String)format).substring(0, i) + "\u00a7" + ((String)format).substring(i);
        }
        if (this.getString(path + "." + option) != null) {
            option = this.getString(path + "." + option);
        }
        Object message = (String)format + this.getString(path + ".msg");
        message = ((String)message).replace("<x>", option);
        return message;
    }

    public String getMessage(String path, String format) {
        return this.getMessage(path, format, null);
    }

    public String getMessage(String path) {
        return this.getMessage(path, "info");
    }

    public String getRawMessage(String path, String format, String option) {
        String message = ChatColor.stripColor((String)this.getMessage(path, format, option));
        format = this.getFormat(format);
        ChatColor color = ChatColor.WHITE;
        String bold = "";
        String italic = "";
        String underlined = "";
        String obfuscated = "";
        String strikethrough = "";
        block7: for (int i = 0; i < format.length(); ++i) {
            ChatColor code = ChatColor.getByChar((char)format.charAt(i));
            switch (code) {
                case MAGIC: {
                    obfuscated = ", \"obfuscated\": true";
                    continue block7;
                }
                case BOLD: {
                    bold = ", \"bold\": true";
                    continue block7;
                }
                case STRIKETHROUGH: {
                    strikethrough = ", \"strikethrough\": true";
                    continue block7;
                }
                case UNDERLINE: {
                    underlined = ", \"underlined\": true";
                    continue block7;
                }
                case ITALIC: {
                    italic = ", \"italic\": true";
                    continue block7;
                }
                default: {
                    color = !code.isColor() ? color : code;
                }
            }
        }
        return "{\"text\":\"%s\", \"color\":\"%s\"%s%s%s%s%s}".formatted(message, color.name().toLowerCase(), obfuscated, bold, strikethrough, underlined, italic);
    }

    public String getFormat(String format) {
        return (format = this.getString(format)) == null ? "" : format;
    }

    public String getString(String path) {
        String message = null;
        if (this.langConfig.contains(path)) {
            message = this.langConfig.getString(path);
        } else if (this.defConfig.contains(path)) {
            message = this.defConfig.getString(path);
        }
        return message;
    }
}

