/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.menu;

import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.PlayerEditor;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class EquipmentMenu {
    Inventory menuInv;
    private Debug debug;
    private PlayerEditor pe;
    private ArmorStand armorstand;
    static String name = "ArmorStand Equipment";
    ItemStack helmet;
    ItemStack chest;
    ItemStack pants;
    ItemStack feetsies;
    ItemStack rightHand;
    ItemStack leftHand;

    public EquipmentMenu(PlayerEditor pe, ArmorStand as) {
        this.pe = pe;
        this.armorstand = as;
        this.debug = new Debug(pe.plugin);
        name = pe.plugin.getLang().getMessage("equiptitle", "menutitle");
        this.menuInv = Bukkit.createInventory((InventoryHolder)pe.getManager().getEquipmentHolder(), (int)18, (String)name);
    }

    private void fillInventory() {
        this.menuInv.clear();
        EntityEquipment equipment = this.armorstand.getEquipment();
        ItemStack helmet = equipment.getHelmet();
        ItemStack chest = equipment.getChestplate();
        ItemStack pants = equipment.getLeggings();
        ItemStack feetsies = equipment.getBoots();
        ItemStack rightHand = equipment.getItemInMainHand();
        ItemStack leftHand = equipment.getItemInOffHand();
        equipment.clear();
        ItemStack disabledIcon = new ItemStack(Material.BARRIER);
        ItemMeta meta = disabledIcon.getItemMeta();
        meta.setDisplayName(this.pe.plugin.getLang().getMessage("disabled", "warn"));
        meta.getPersistentDataContainer().set(this.pe.plugin.getIconKey(), PersistentDataType.STRING, (Object)"ase icon");
        disabledIcon.setItemMeta(meta);
        ItemStack helmetIcon = this.createIcon(Material.LEATHER_HELMET, "helm");
        ItemStack chestIcon = this.createIcon(Material.LEATHER_CHESTPLATE, "chest");
        ItemStack pantsIcon = this.createIcon(Material.LEATHER_LEGGINGS, "pants");
        ItemStack feetsiesIcon = this.createIcon(Material.LEATHER_BOOTS, "boots");
        ItemStack rightHandIcon = this.createIcon(Material.WOODEN_SWORD, "rhand");
        ItemStack leftHandIcon = this.createIcon(Material.SHIELD, "lhand");
        ItemStack[] items = new ItemStack[]{helmetIcon, chestIcon, pantsIcon, feetsiesIcon, rightHandIcon, leftHandIcon, disabledIcon, disabledIcon, disabledIcon, helmet, chest, pants, feetsies, rightHand, leftHand, disabledIcon, disabledIcon, disabledIcon};
        this.menuInv.setContents(items);
    }

    private ItemStack createIcon(Material mat, String slot) {
        ItemStack icon = new ItemStack(mat);
        ItemMeta meta = icon.getItemMeta();
        meta.getPersistentDataContainer().set(this.pe.plugin.getIconKey(), PersistentDataType.STRING, (Object)"ase icon");
        meta.setDisplayName(this.pe.plugin.getLang().getMessage("equipslot", "iconname", slot));
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add(this.pe.plugin.getLang().getMessage("equipslot.description", "icondescription", slot));
        meta.setLore(loreList);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        icon.setItemMeta(meta);
        return icon;
    }

    public void openMenu() {
        this.pe.getPlayer().closeInventory();
        if (this.pe.getPlayer().hasPermission("asedit.equipment")) {
            this.fillInventory();
            this.debug.log("Player '" + this.pe.getPlayer().getDisplayName() + "' has opened the Equipment Menu.");
            this.pe.getPlayer().openInventory(this.menuInv);
        }
    }

    public void equipArmorstand() {
        this.helmet = this.menuInv.getItem(9);
        this.chest = this.menuInv.getItem(10);
        this.pants = this.menuInv.getItem(11);
        this.feetsies = this.menuInv.getItem(12);
        this.rightHand = this.menuInv.getItem(13);
        this.leftHand = this.menuInv.getItem(14);
        this.debug.log("Equipping the ArmorStand with the following items: ");
        this.debug.log("Helmet: " + String.valueOf(this.helmet));
        this.debug.log("Chest: " + String.valueOf(this.chest));
        this.debug.log("Chest: " + String.valueOf(this.chest));
        this.debug.log("Pants: " + String.valueOf(this.pants));
        this.debug.log("Boots: " + String.valueOf(this.feetsies));
        this.debug.log("R-Hand: " + String.valueOf(this.rightHand));
        this.debug.log("L-Hand: " + String.valueOf(this.leftHand));
        this.armorstand.getEquipment().setHelmet(this.helmet);
        this.armorstand.getEquipment().setChestplate(this.chest);
        this.armorstand.getEquipment().setLeggings(this.pants);
        this.armorstand.getEquipment().setBoots(this.feetsies);
        this.armorstand.getEquipment().setItemInMainHand(this.rightHand);
        this.armorstand.getEquipment().setItemInOffHand(this.leftHand);
    }

    public static String getName() {
        return name;
    }
}

