/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.menu;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.PlayerEditor;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Menu {
    private final Inventory menuInv;
    private final PlayerEditor pe;
    private static String name = "Armor Stand Editor Menu";
    private Debug debug;

    public Menu(PlayerEditor pe) {
        this.pe = pe;
        this.debug = new Debug(pe.plugin);
        name = pe.plugin.getLang().getMessage("mainmenutitle", "menutitle");
        this.menuInv = Bukkit.createInventory((InventoryHolder)pe.getManager().getMenuHolder(), (int)54, (String)name);
        this.fillInventory();
    }

    private void fillInventory() {
        ItemStack itemFrameVisible;
        ItemStack visibility;
        this.menuInv.clear();
        ItemStack rotate = null;
        ItemStack size = null;
        ItemStack plate = null;
        ItemStack copy = null;
        ItemStack paste = null;
        ItemStack slot1 = null;
        ItemStack slot2 = null;
        ItemStack slot3 = null;
        ItemStack slot4 = null;
        ItemStack presetItem = null;
        ItemStack place = null;
        ItemStack equipment = null;
        ItemStack disableSlots = null;
        ItemStack gravity = null;
        ItemStack playerHead = null;
        ItemStack toggleVulnerabilty = null;
        ItemStack blankSlot = this.createIcon(new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1), "blankslot", "");
        ItemStack xAxis = this.createIcon(new ItemStack(Material.RED_CONCRETE, 1), "xaxis", "axis x");
        ItemStack yAxis = this.createIcon(new ItemStack(Material.GREEN_CONCRETE, 1), "yaxis", "axis y");
        ItemStack zAxis = this.createIcon(new ItemStack(Material.BLUE_CONCRETE, 1), "zaxis", "axis z");
        ItemStack coarseAdj = this.createIcon(new ItemStack(Material.COARSE_DIRT, 1), "coarseadj", "adj coarse");
        ItemStack fineAdj = this.createIcon(new ItemStack(Material.SMOOTH_SANDSTONE), "fineadj", "adj fine");
        ItemStack reset = this.createIcon(new ItemStack(Material.WATER_BUCKET), "reset", "mode reset");
        ItemStack headPos = this.createIcon(new ItemStack(Material.IRON_HELMET), "head", "mode head");
        ItemStack bodyPos = this.createIcon(new ItemStack(Material.IRON_CHESTPLATE), "body", "mode body");
        ItemStack leftLegPos = this.createIcon(new ItemStack(Material.IRON_LEGGINGS), "leftleg", "mode leftleg");
        ItemStack rightLegPos = this.createIcon(new ItemStack(Material.IRON_LEGGINGS), "rightleg", "mode rightleg");
        ItemStack leftArmPos = this.createIcon(new ItemStack(Material.STICK), "leftarm", "mode leftarm");
        ItemStack rightArmPos = this.createIcon(new ItemStack(Material.STICK), "rightarm", "mode rightarm");
        ItemStack showArms = this.createIcon(new ItemStack(Material.STICK), "showarms", "mode showarms");
        presetItem = this.createIcon(new ItemStack(Material.BOOKSHELF), "presetmenu", "mode preset");
        if (this.pe.getPlayer().hasPermission("asedit.togglearmorstandvisibility") || this.pe.plugin.getArmorStandVisibility()) {
            visibility = new ItemStack(Material.POTION, 1);
            PotionMeta potionMeta = (PotionMeta)visibility.getItemMeta();
            PotionEffect effect = new PotionEffect(PotionEffectType.INVISIBILITY, 1, 0);
            if (potionMeta != null) {
                potionMeta.addCustomEffect(effect, true);
            }
            visibility.setItemMeta((ItemMeta)potionMeta);
            this.createIcon(visibility, "invisible", "mode invisible");
        } else {
            visibility = blankSlot;
        }
        if (this.pe.getPlayer().hasPermission("asedit.toggleitemframevisibility") || this.pe.plugin.getItemFrameVisibility()) {
            itemFrameVisible = new ItemStack(Material.ITEM_FRAME, 1);
            this.createIcon(itemFrameVisible, "itemframevisible", "mode itemframe");
        } else {
            itemFrameVisible = blankSlot;
        }
        toggleVulnerabilty = this.pe.getPlayer().hasPermission("asedit.toggleInvulnerability") ? this.createIcon(new ItemStack(Material.TOTEM_OF_UNDYING, 1), "vulnerability", "mode vulnerability") : blankSlot;
        size = this.pe.getPlayer().hasPermission("asedit.togglesize") ? this.createIcon(new ItemStack(Material.PUFFERFISH, 1), "size", "mode size") : blankSlot;
        disableSlots = this.pe.getPlayer().hasPermission("asedit.disableslots") ? this.createIcon(new ItemStack(Material.BARRIER), "disableslots", "mode disableslots") : blankSlot;
        gravity = this.pe.getPlayer().hasPermission("asedit.togglegravity") ? this.createIcon(new ItemStack(Material.SAND), "gravity", "mode gravity") : blankSlot;
        plate = this.pe.getPlayer().hasPermission("asedit.togglebaseplate") ? this.createIcon(new ItemStack(Material.SMOOTH_STONE_SLAB, 1), "baseplate", "mode baseplate") : blankSlot;
        place = this.pe.getPlayer().hasPermission("asedit.movement") ? this.createIcon(new ItemStack(Material.RAIL, 1), "placement", "mode placement") : blankSlot;
        rotate = this.pe.getPlayer().hasPermission("asedit.rotation") ? this.createIcon(new ItemStack(Material.COMPASS, 1), "rotate", "mode rotate") : blankSlot;
        equipment = this.pe.getPlayer().hasPermission("asedit.equipment") ? this.createIcon(new ItemStack(Material.CHEST, 1), "equipment", "mode equipment") : blankSlot;
        if (this.pe.getPlayer().hasPermission("asedit.copy")) {
            copy = this.createIcon(new ItemStack(Material.FLOWER_BANNER_PATTERN), "copy", "mode copy");
            slot1 = this.createIcon(new ItemStack(Material.BOOK), "copyslot", "slot 1", "1");
            slot2 = this.createIcon(new ItemStack(Material.BOOK, 2), "copyslot", "slot 2", "2");
            slot3 = this.createIcon(new ItemStack(Material.BOOK, 3), "copyslot", "slot 3", "3");
            slot4 = this.createIcon(new ItemStack(Material.BOOK, 4), "copyslot", "slot 4", "4");
        }
        if (this.pe.getPlayer().hasPermission("asedit.paste")) {
            paste = this.createIcon(new ItemStack(Material.FEATHER), "paste", "mode paste");
        }
        playerHead = this.pe.getPlayer().hasPermission("asedit.head") || this.pe.plugin.getallowedToRetrieveOwnPlayerHead() ? this.createIcon(new ItemStack(Material.PLAYER_HEAD, 1), "playerheadmenu", "playerhead") : blankSlot;
        ItemStack glowing = this.pe.getPlayer().hasPermission("asedit.togglearmorstandglow") ? this.createIcon(new ItemStack(Material.GLOW_INK_SAC, 1), "armorstandglow", "mode armorstandglow") : blankSlot;
        ItemStack help = this.createIcon(new ItemStack(Material.NETHER_STAR), "helpgui", "help");
        ItemStack[] items = new ItemStack[]{blankSlot, blankSlot, blankSlot, xAxis, yAxis, zAxis, blankSlot, blankSlot, help, copy, paste, blankSlot, playerHead, headPos, reset, blankSlot, itemFrameVisible, glowing, slot1, slot2, blankSlot, rightArmPos, bodyPos, leftArmPos, blankSlot, rotate, place, slot3, slot4, blankSlot, rightLegPos, equipment, leftLegPos, blankSlot, coarseAdj, fineAdj, presetItem, blankSlot, blankSlot, blankSlot, blankSlot, blankSlot, blankSlot, blankSlot, disableSlots, blankSlot, showArms, visibility, size, blankSlot, plate, toggleVulnerabilty, gravity, blankSlot};
        this.menuInv.setContents(items);
    }

    private ItemStack createIcon(ItemStack icon, String path, String command) {
        return this.createIcon(icon, path, command, null);
    }

    private ItemStack createIcon(ItemStack icon, String path, String command, String option) {
        ItemMeta meta = icon.getItemMeta();
        assert (meta != null);
        meta.getPersistentDataContainer().set(ArmorStandEditorPlugin.instance().getIconKey(), PersistentDataType.STRING, (Object)("ase " + command));
        meta.setDisplayName(this.getIconName(path, option));
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add(this.getIconDescription(path, option));
        meta.setLore(loreList);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        icon.setItemMeta(meta);
        return icon;
    }

    private String getIconName(String path, String option) {
        return this.pe.plugin.getLang().getMessage(path, "iconname", option);
    }

    private String getIconDescription(String path, String option) {
        return this.pe.plugin.getLang().getMessage(path + ".description", "icondescription", option);
    }

    public void openMenu() {
        if (this.pe.getPlayer().hasPermission("asedit.basic")) {
            this.fillInventory();
            this.debug.log("Player '" + this.pe.getPlayer().getDisplayName() + "' has opened the Main ASE Menu");
            this.pe.getPlayer().openInventory(this.menuInv);
        }
    }

    public static String getName() {
        return name;
    }
}

