/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.menu;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.PlayerEditor;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.EulerAngle;

public class PresetArmorPosesMenu {
    Inventory menuInv;
    private Debug debug;
    private final PlayerEditor pe;
    public ArmorStandEditorPlugin plugin = ArmorStandEditorPlugin.instance();
    private ArmorStand armorStand;
    static String name;
    final String VALUETOREPLACE = "\u00a7" + this.plugin.getLang().getFormat("info");
    final String SITTING = this.plugin.getLang().getMessage("sitting").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String WAVING = this.plugin.getLang().getMessage("waving").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String GREETING_1 = this.plugin.getLang().getMessage("greeting 1").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String GREETING_2 = this.plugin.getLang().getMessage("greeting 2").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String CHEERS = this.plugin.getLang().getMessage("cheers").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String ARCHER = this.plugin.getLang().getMessage("archer").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String DANCING = this.plugin.getLang().getMessage("dancing").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String HANGING = this.plugin.getLang().getMessage("hanging").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String PRESENTING = this.plugin.getLang().getMessage("present").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String FISHING = this.plugin.getLang().getMessage("fishing").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String BACKTOMENU = this.plugin.getLang().getMessage("backtomenu").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");
    final String HOWTO = this.plugin.getLang().getMessage("howtopreset").replace(this.VALUETOREPLACE, "\u00a72\u00a7n");

    public PresetArmorPosesMenu(PlayerEditor pe, ArmorStand as) {
        this.pe = pe;
        this.armorStand = as;
        this.debug = new Debug(pe.plugin);
        name = this.plugin.getLang().getMessage("presettitle", "menutitle");
        this.menuInv = Bukkit.createInventory((InventoryHolder)pe.getManager().getPresetHolder(), (int)36, (String)name);
    }

    private void fillInventory() {
        this.menuInv.clear();
        ItemStack blank = this.createIcon(new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1), "blankslot");
        ItemStack sitting = this.createIcon(new ItemStack(Material.ARMOR_STAND, 1), "sitting");
        ItemStack waving = this.createIcon(new ItemStack(Material.ARMOR_STAND, 2), "waving");
        ItemStack greet1 = this.createIcon(new ItemStack(Material.ARMOR_STAND, 3), "greeting 1");
        ItemStack greet2 = this.createIcon(new ItemStack(Material.ARMOR_STAND, 4), "greeting 2");
        ItemStack cheer = this.createIcon(new ItemStack(Material.ARMOR_STAND, 5), "cheers");
        ItemStack archer = this.createIcon(new ItemStack(Material.ARMOR_STAND, 6), "archer");
        ItemStack dancing = this.createIcon(new ItemStack(Material.ARMOR_STAND, 7), "dancing");
        ItemStack hanging = this.createIcon(new ItemStack(Material.ARMOR_STAND, 8), "hanging");
        ItemStack present = this.createIcon(new ItemStack(Material.ARMOR_STAND, 9), "present");
        ItemStack fishing = this.createIcon(new ItemStack(Material.ARMOR_STAND, 10), "fishing");
        ItemStack backToMenu = this.createIcon(new ItemStack(Material.RED_WOOL, 1), "backtomenu");
        ItemStack howToPreset = this.createIcon(new ItemStack(Material.BOOK, 1), "howtopreset");
        ItemStack[] items = new ItemStack[]{blank, blank, blank, blank, blank, blank, blank, blank, blank, blank, backToMenu, sitting, waving, greet1, greet2, cheer, archer, blank, blank, howToPreset, dancing, hanging, present, fishing, blank, blank, blank, blank, blank, blank, blank, blank, blank, blank, blank, blank};
        this.menuInv.setContents(items);
    }

    private ItemStack createIcon(ItemStack icon, String path) {
        ItemMeta meta = icon.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(this.getIconName(path));
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add(this.getIconDescription(path));
        meta.setLore(loreList);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        icon.setItemMeta(meta);
        return icon;
    }

    private String getIconName(String path) {
        return this.plugin.getLang().getMessage(path, "iconname");
    }

    private String getIconDescription(String path) {
        return this.plugin.getLang().getMessage(path + ".description", "icondescription");
    }

    public void openMenu() {
        if (this.pe.getPlayer().hasPermission("asedit.basic")) {
            this.fillInventory();
            this.debug.log("Player '" + this.pe.getPlayer().getDisplayName() + "' has opened the armorStand Preset Menu");
            this.pe.getPlayer().openInventory(this.menuInv);
        }
    }

    public static String getName() {
        return name;
    }

    public void handlePresetPose(String itemName, Player player) {
        if (itemName == null) {
            return;
        }
        if (player == null) {
            return;
        }
        this.debug.log("Player '" + player.getDisplayName() + "' has chosen the Preset AS Pose '" + itemName + "'");
        if (itemName.equals(this.SITTING)) {
            this.setPresetPose(player, 345.0, 0.0, 10.0, 350.0, 0.0, 350.0, 280.0, 20.0, 0.0, 280.0, 340.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.WAVING)) {
            this.setPresetPose(player, 220.0, 20.0, 0.0, 350.0, 0.0, 350.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.GREETING_1)) {
            this.setPresetPose(player, 260.0, 20.0, 0.0, 260.0, 340.0, 0.0, 340.0, 0.0, 0.0, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.GREETING_2)) {
            this.setPresetPose(player, 260.0, 10.0, 0.0, 260.0, 350.0, 0.0, 320.0, 0.0, 0.0, 10.0, 0.0, 0.0, 340.0, 0.0, 350.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.ARCHER)) {
            this.setPresetPose(player, 270.0, 350.0, 0.0, 280.0, 50.0, 0.0, 340.0, 0.0, 10.0, 20.0, 0.0, 350.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.DANCING)) {
            this.setPresetPose(player, 14.0, 0.0, 110.0, 20.0, 0.0, 250.0, 250.0, 330.0, 0.0, 15.0, 330.0, 0.0, 350.0, 350.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.CHEERS)) {
            this.setPresetPose(player, 250.0, 60.0, 0.0, 20.0, 10.0, 0.0, 10.0, 0.0, 0.0, 350.0, 0.0, 0.0, 340.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.HANGING)) {
            this.setPresetPose(player, 1.0, 33.0, 67.0, -145.0, -33.0, -4.0, -42.0, 21.0, 1.0, -100.0, 0.0, -1.0, -29.0, -38.0, -18.0, 0.0, -4.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.PRESENTING)) {
            this.setPresetPose(player, 280.0, 330.0, 0.0, 10.0, 0.0, 350.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.FISHING)) {
            this.setPresetPose(player, 300.0, 320.0, 0.0, 300.0, 40.0, 0.0, 280.0, 20.0, 0.0, 280.0, 340.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        } else if (itemName.equals(this.BACKTOMENU)) {
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
            this.pe.openMenu();
        } else if (itemName.equals(this.HOWTO)) {
            player.sendMessage(this.pe.plugin.getLang().getMessage("howtopresetmsg"));
            player.sendMessage(this.pe.plugin.getLang().getMessage("helpurl"));
            player.sendMessage(this.pe.plugin.getLang().getMessage("helpdiscord"));
            player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
            player.closeInventory();
        }
    }

    public void setPresetPose(Player player, double rightArmRoll, double rightArmYaw, double rightArmPitch, double leftArmRoll, double leftArmYaw, double leftArmPitch, double rightLegRoll, double rightLegYaw, double rightLegPitch, double leftLegRoll, double LeftLegYaw, double llp_yaw, double headRoll, double headYaw, double headPitch, double bodyRoll, double bodyYaw, double bodyPitch) {
        if (!this.armorStand.isValid()) {
            return;
        }
        if (!player.hasPermission("asedit.basic")) {
            return;
        }
        this.armorStand.setRightArmPose(new EulerAngle(Math.toRadians(rightArmRoll), Math.toRadians(rightArmYaw), Math.toRadians(rightArmPitch)));
        this.armorStand.setLeftArmPose(new EulerAngle(Math.toRadians(leftArmRoll), Math.toRadians(leftArmYaw), Math.toRadians(leftArmPitch)));
        this.armorStand.setRightLegPose(new EulerAngle(Math.toRadians(rightLegRoll), Math.toRadians(rightLegYaw), Math.toRadians(rightLegPitch)));
        this.armorStand.setLeftLegPose(new EulerAngle(Math.toRadians(leftLegRoll), Math.toRadians(LeftLegYaw), Math.toRadians(llp_yaw)));
        this.armorStand.setBodyPose(new EulerAngle(Math.toRadians(bodyRoll), Math.toRadians(bodyYaw), Math.toRadians(bodyPitch)));
        this.armorStand.setHeadPose(new EulerAngle(Math.toRadians(headRoll), Math.toRadians(headYaw), Math.toRadians(headPitch)));
    }
}

