/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.menu;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.PlayerEditor;
import io.github.rypofalem.armorstandeditor.menu.ASEHolder;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class SizeMenu
extends ASEHolder {
    public ArmorStandEditorPlugin plugin = ArmorStandEditorPlugin.instance();
    Inventory menuInv;
    private Debug debug;
    private PlayerEditor pe;
    private ArmorStand as;
    static String name = "Size Menu";
    final String VALUETOREPLACE = "\u00a7" + this.plugin.getLang().getFormat("info");
    final String VALUEWEWANT = "\u00a7" + this.plugin.getLang().getFormat("iconname").substring(0, 1) + "\u00a7" + this.plugin.getLang().getFormat("iconname").substring(1);
    final String SCALE1 = this.plugin.getLang().getMessage("scale1").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE2 = this.plugin.getLang().getMessage("scale2").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE3 = this.plugin.getLang().getMessage("scale3").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE4 = this.plugin.getLang().getMessage("scale4").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE5 = this.plugin.getLang().getMessage("scale5").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE6 = this.plugin.getLang().getMessage("scale6").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE7 = this.plugin.getLang().getMessage("scale7").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE8 = this.plugin.getLang().getMessage("scale8").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE9 = this.plugin.getLang().getMessage("scale9").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALE10 = this.plugin.getLang().getMessage("scale10").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALEPLUS12 = this.plugin.getLang().getMessage("scaleadd12").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALEMINUS12 = this.plugin.getLang().getMessage("scaleremove12").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALEPLUS110 = this.plugin.getLang().getMessage("scaleadd110").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String SCALEMINUS110 = this.plugin.getLang().getMessage("scaleremove110").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String BACKTOMENU = this.plugin.getLang().getMessage("backtomenu").replace(this.VALUETOREPLACE, this.VALUEWEWANT);
    final String RESET = this.plugin.getLang().getMessage("reset").replace(this.VALUETOREPLACE, this.VALUEWEWANT);

    public SizeMenu(PlayerEditor pe, ArmorStand as) {
        this.pe = pe;
        this.as = as;
        this.debug = new Debug(pe.plugin);
        name = pe.plugin.getLang().getMessage("sizeMenu", "menutitle");
        this.menuInv = Bukkit.createInventory((InventoryHolder)pe.getManager().getSizeMenuHolder(), (int)27, (String)name);
    }

    private void fillInventory() {
        this.menuInv.clear();
        ItemStack blankSlot = this.createIcon(new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1), "blankslot");
        ItemStack base10 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 1), "scale1");
        ItemStack base20 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 2), "scale2");
        ItemStack base30 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 3), "scale3");
        ItemStack base40 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 4), "scale4");
        ItemStack base50 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 5), "scale5");
        ItemStack base60 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 6), "scale6");
        ItemStack base70 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 7), "scale7");
        ItemStack base80 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 8), "scale8");
        ItemStack base90 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 9), "scale9");
        ItemStack base100 = this.createIcon(new ItemStack(Material.RED_CONCRETE, 10), "scale10");
        ItemStack add12toBase = this.createIcon(new ItemStack(Material.ORANGE_CONCRETE, 1), "scaleadd12");
        ItemStack remove12fromBase = this.createIcon(new ItemStack(Material.GREEN_CONCRETE, 1), "scaleremove12");
        ItemStack add110fromBase = this.createIcon(new ItemStack(Material.ORANGE_CONCRETE, 2), "scaleadd110");
        ItemStack remove110fromBase = this.createIcon(new ItemStack(Material.GREEN_CONCRETE, 2), "scaleremove110");
        ItemStack backToMenu = this.createIcon(new ItemStack(Material.RED_WOOL, 1), "backtomenu");
        ItemStack resetIcon = this.createIcon(new ItemStack(Material.NETHER_STAR, 1), "reset");
        ItemStack[] items = new ItemStack[]{backToMenu, blankSlot, base10, base20, base30, base40, base50, base60, blankSlot, resetIcon, blankSlot, base70, base80, base90, base100, blankSlot, add12toBase, remove12fromBase, blankSlot, blankSlot, blankSlot, blankSlot, blankSlot, blankSlot, blankSlot, add110fromBase, remove110fromBase};
        this.menuInv.setContents(items);
    }

    private ItemStack createIcon(ItemStack icon, String path) {
        return this.createIcon(icon, path, null);
    }

    private ItemStack createIcon(ItemStack icon, String path, String option) {
        ItemMeta meta = icon.getItemMeta();
        assert (meta != null);
        meta.getPersistentDataContainer().set(ArmorStandEditorPlugin.instance().getIconKey(), PersistentDataType.STRING, (Object)("ase " + option));
        meta.setDisplayName(this.getIconName(path, option));
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add(this.getIconDescription(path, option));
        meta.setLore(loreList);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        icon.setItemMeta(meta);
        return icon;
    }

    private String getIconName(String path, String option) {
        return this.pe.plugin.getLang().getMessage(path, "iconname", option);
    }

    private String getIconDescription(String path, String option) {
        return this.pe.plugin.getLang().getMessage(path + ".description", "icondescription", option);
    }

    public void handleAttributeScaling(String itemName, Player player) {
        if (itemName == null || player == null) {
            return;
        }
        Map positiveScaleMap = Map.ofEntries(Map.entry(this.SCALE1, 1.0), Map.entry(this.SCALE2, 2.0), Map.entry(this.SCALE3, 3.0), Map.entry(this.SCALE4, 4.0), Map.entry(this.SCALE5, 5.0), Map.entry(this.SCALE6, 6.0), Map.entry(this.SCALE7, 7.0), Map.entry(this.SCALE8, 8.0), Map.entry(this.SCALE9, 9.0), Map.entry(this.SCALE10, 10.0), Map.entry(this.SCALEPLUS12, 0.5), Map.entry(this.SCALEPLUS110, 0.1));
        Map negativeScaleMap = Map.ofEntries(Map.entry(this.SCALEMINUS12, 0.5), Map.entry(this.SCALEMINUS110, 0.1));
        if (positiveScaleMap.containsKey(itemName)) {
            this.handleScaleChange(player, itemName, (Double)positiveScaleMap.get(itemName));
        } else if (negativeScaleMap.containsKey(itemName)) {
            this.handleScaleChange(player, itemName, (Double)negativeScaleMap.get(itemName));
        } else if (itemName.equals(this.BACKTOMENU)) {
            this.handleBackToMenu(player);
        } else if (itemName.equals(this.RESET)) {
            this.handleReset(player);
        }
    }

    private void handleScaleChange(Player player, String itemName, double scale) {
        this.setArmorStandScale(player, itemName, scale);
        this.playChimeSound(player);
        player.closeInventory();
    }

    private void handleBackToMenu(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
        player.closeInventory();
        this.pe.openMenu();
    }

    private void handleReset(Player player) {
        this.setArmorStandScale(player, this.RESET, 1.0);
        this.playChimeSound(player);
        player.closeInventory();
    }

    private void playChimeSound(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
    }

    private void setArmorStandScale(Player player, String itemName, double scaleValue) {
        this.debug.log("Setting the Scale of the ArmorStand");
        double currentScaleValue = 0.0;
        if (!this.as.isValid()) {
            return;
        }
        if (!player.hasPermission("asedit.togglesize")) {
            return;
        }
        if (itemName.equals(this.SCALE1) || itemName.equals(this.SCALE2) || itemName.equals(this.SCALE3) || itemName.equals(this.SCALE4) || itemName.equals(this.SCALE5) || itemName.equals(this.SCALE6) || itemName.equals(this.SCALE7) || itemName.equals(this.SCALE8) || itemName.equals(this.SCALE9) || itemName.equals(this.SCALE10)) {
            double newScaleValue = currentScaleValue + scaleValue;
            this.debug.log("Result of the scale Calculation: " + newScaleValue);
            if (newScaleValue > this.plugin.getMaxScaleValue()) {
                this.pe.getPlayer().sendMessage(this.plugin.getLang().getMessage("scalemaxwarn", "warn"));
            } else if (newScaleValue < this.plugin.getMinScaleValue()) {
                this.pe.getPlayer().sendMessage(this.plugin.getLang().getMessage("scaleminwarn", "warn"));
            } else {
                this.as.getAttribute(Attribute.SCALE).setBaseValue(newScaleValue);
            }
        } else if (itemName.equals(this.SCALEPLUS12) || itemName.equals(this.SCALEPLUS110)) {
            currentScaleValue = this.as.getAttribute(Attribute.SCALE).getBaseValue();
            double newScaleValue = currentScaleValue + scaleValue;
            this.debug.log("Result of the scale Calculation: " + newScaleValue);
            if (newScaleValue > this.plugin.getMaxScaleValue()) {
                this.pe.getPlayer().sendMessage(this.plugin.getLang().getMessage("scalemaxwarn", "warn"));
                return;
            }
            this.as.getAttribute(Attribute.SCALE).setBaseValue(newScaleValue);
        } else if (itemName.equals(this.SCALEMINUS12) || itemName.equals(this.SCALEMINUS110)) {
            currentScaleValue = this.as.getAttribute(Attribute.SCALE).getBaseValue();
            double newScaleValue = currentScaleValue - scaleValue;
            this.debug.log("Result of the scale Calculation: " + newScaleValue);
            if (newScaleValue < this.plugin.getMinScaleValue()) {
                this.pe.getPlayer().sendMessage(this.plugin.getLang().getMessage("scaleminwarn", "warn"));
                return;
            }
            this.as.getAttribute(Attribute.SCALE).setBaseValue(newScaleValue);
        } else if (itemName.equals(this.RESET)) {
            double newScaleValue = 1.0;
            this.as.getAttribute(Attribute.SCALE).setBaseValue(newScaleValue);
        }
    }

    public void openMenu() {
        if (this.pe.getPlayer().hasPermission("asedit.togglesize")) {
            this.fillInventory();
            this.debug.log("Player '" + this.pe.getPlayer().getDisplayName() + "' has opened the Sizing Attribute Menu");
            this.pe.getPlayer().openInventory(this.menuInv);
        }
    }
}

