/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.AddonsManager;
import world.bentobox.bentobox.managers.IslandsManager;

public class BentoBoxProtection
implements Protection {
    private final boolean bentoEnabled = Bukkit.getPluginManager().isPluginEnabled("BentoBox");
    private boolean bSkyBlockEnabled;
    private boolean aOneBlockEnabled;

    @Override
    public boolean checkPermission(Block block, Player player) {
        if (!this.bentoEnabled || player.isOp() || player.hasPermission("asedit.ignoreProtection.bentobox") || player.hasPermission("bentobox.admin")) {
            return true;
        }
        BentoBox myBento = BentoBox.getInstance();
        if (myBento == null) {
            return true;
        }
        IslandsManager islandsManager = myBento.getIslandsManager();
        AddonsManager addonsManager = myBento.getAddonsManager();
        this.bSkyBlockEnabled = addonsManager.getAddonByName("BSkyblock").isPresent();
        this.aOneBlockEnabled = addonsManager.getAddonByName("AOneBlock").isPresent();
        if (ArmorStandEditorPlugin.instance().isDebug()) {
            if (this.bSkyBlockEnabled && !this.aOneBlockEnabled) {
                Bukkit.getServer().getLogger().log(Level.INFO, "[ArmorStandEditor-Debug] BentoBox Protection for ASE is looking at: BSkyBlock.");
            }
            if (this.aOneBlockEnabled && !this.bSkyBlockEnabled) {
                Bukkit.getServer().getLogger().log(Level.INFO, "[ArmorStandEditor-Debug] BentoBox Protection for ASE is looking at: AOneBlock.");
            }
            if (!this.bSkyBlockEnabled && !this.aOneBlockEnabled) {
                Bukkit.getServer().getLogger().log(Level.INFO, "[ArmorStandEditor-Debug] BentoBox Protection is currently not using anything. This will automatically allow edits.");
            }
        }
        if (!this.bSkyBlockEnabled && !this.aOneBlockEnabled) {
            return true;
        }
        Optional islandOptional = islandsManager.getIslandAt(block.getLocation());
        if (islandOptional.isEmpty()) {
            return true;
        }
        if (islandsManager.isOwner(block.getWorld(), player.getUniqueId())) {
            return true;
        }
        Island theIsland = (Island)islandOptional.get();
        if (theIsland.getRank(player.getUniqueId()) == 400) {
            return true;
        }
        return theIsland.isAllowed(User.getInstance((Player)player), Flags.BREAK_BLOCKS);
    }
}

