/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.TrustTypes;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GriefDefenderProtection
implements Protection {
    private final boolean gdEnabled = Bukkit.getPluginManager().isPluginEnabled("GriefDefender");

    @Override
    public boolean checkPermission(Block block, Player player) {
        if (!this.gdEnabled) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission("asedit.ignoreProtection.griefDefender")) {
            return true;
        }
        if (player.hasPermission("griefdefender.admin.bypass.border-check")) {
            return true;
        }
        Location blockLoc = block.getLocation();
        if (GriefDefender.getCore().getClaimAt((Object)blockLoc) != null) {
            Claim landClaim = GriefDefender.getCore().getClaimAt((Object)blockLoc);
            if (landClaim == null || landClaim.isWilderness() || landClaim.isAdminClaim()) {
                return true;
            }
            return !landClaim.isBasicClaim() || landClaim.isUserTrusted(player.getUniqueId(), TrustTypes.BUILDER) || landClaim.allowEdit(player.getUniqueId());
        }
        return true;
    }
}

