/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import io.github.rypofalem.armorstandeditor.protections.Protection;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GriefPreventionProtection
implements Protection {
    private boolean gpEnabled = Bukkit.getPluginManager().isPluginEnabled("GriefPrevention");
    private GriefPrevention griefPrevention = null;

    public GriefPreventionProtection() {
        if (!this.gpEnabled) {
            return;
        }
        this.griefPrevention = (GriefPrevention)Bukkit.getPluginManager().getPlugin("GriefPrevention");
    }

    @Override
    public boolean checkPermission(Block block, Player player) {
        if (!this.gpEnabled) {
            return true;
        }
        if (player.hasPermission("asedit.ignoreProtection.griefPrevention")) {
            return true;
        }
        Location blockLoc = block.getLocation();
        if (GriefPrevention.instance.claimsEnabledForWorld(blockLoc.getWorld())) {
            Claim landClaim = this.griefPrevention.dataStore.getClaimAt(blockLoc, false, null);
            Material blockMat = block.getType();
            if (landClaim != null && landClaim.allowEdit(player) != null && landClaim.allowBuild(player, blockMat) != null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + landClaim.allowEdit(player));
                player.sendMessage(String.valueOf(ChatColor.RED) + landClaim.allowBuild(player, blockMat));
                return false;
            }
        } else {
            return true;
        }
        return true;
    }
}

