/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import java.util.UUID;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.LandWorld;
import me.angeschossen.lands.api.player.LandPlayer;
import me.angeschossen.lands.api.role.Role;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LandsProtection
implements Protection {
    private final boolean landsEnabled = Bukkit.getPluginManager().isPluginEnabled("Lands");
    private LandsIntegration landsAPI;

    public LandsProtection() {
        if (this.landsEnabled) {
            this.landsAPI = LandsIntegration.of((Plugin)ArmorStandEditorPlugin.instance());
        }
    }

    @Override
    public boolean checkPermission(Block block, Player player) {
        if (!this.landsEnabled || player.hasPermission("asedit.ignoreProtection.lands") || player.isOp()) {
            return true;
        }
        UUID playerUUID = player.getUniqueId();
        LandPlayer landPlayer = this.landsAPI.getLandPlayer(playerUUID);
        LandWorld landWorld = this.landsAPI.getWorld(player.getWorld());
        if (landWorld != null) {
            Area landAreaOfAS = this.landsAPI.getArea(block.getLocation());
            Area landAreaOfPlayer = this.landsAPI.getArea(player.getLocation());
            if (landAreaOfAS != null) {
                if (landAreaOfPlayer == landAreaOfAS) {
                    Role visitorRole = landAreaOfAS.getVisitorRole();
                    if (landAreaOfAS.getRole(playerUUID) == visitorRole) {
                        return false;
                    }
                    if (landAreaOfAS.isTrusted(playerUUID) || landAreaOfAS.getOwnerUID() == landPlayer.getUID()) {
                        return true;
                    }
                    return landAreaOfAS.hasRoleFlag(playerUUID, Flags.BLOCK_BREAK) || landAreaOfAS.hasRoleFlag(playerUUID, Flags.BLOCK_PLACE) || landAreaOfAS.hasRoleFlag(playerUUID, Flags.INTERACT_CONTAINER) || landAreaOfAS.hasRoleFlag(playerUUID, Flags.INTERACT_GENERAL);
                }
                return false;
            }
            return true;
        }
        return true;
    }
}

