/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import com.plotsquared.core.PlotAPI;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.sk89q.worldedit.math.BlockVector3;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class PlotSquaredProtection
implements Protection {
    private final boolean psEnabled = Bukkit.getPluginManager().isPluginEnabled("PlotSquared");
    private PlotAPI plotAPI;

    public PlotSquaredProtection() {
        if (!this.psEnabled) {
            return;
        }
    }

    @Override
    public boolean checkPermission(Block block, Player player) {
        Location plotLocation;
        PlotArea area;
        if (!this.psEnabled) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission("asedit.ignoreProtection.plotSquared")) {
            return true;
        }
        if (this.plotAPI == null) {
            this.plotAPI = new PlotAPI();
        }
        if ((area = (plotLocation = Location.at((String)block.getWorld().getName(), (BlockVector3)BlockVector3.at((int)block.getX(), (int)block.getY(), (int)block.getZ()))).getPlotArea()) == null) {
            return true;
        }
        Plot plot = area.getPlot(plotLocation);
        if (plot == null) {
            return player.hasPermission("plots.admin.build.road");
        }
        PlotPlayer plotPlayer = this.plotAPI.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return true;
        }
        UUID uuid = plotPlayer.getUUID();
        return plot.isAdded(uuid) || plotPlayer.hasPermission("plots.admin.build.other");
    }
}

