/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import io.github.rypofalem.armorstandeditor.ArmorStandEditorPlugin;
import io.github.rypofalem.armorstandeditor.Debug;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class TownyProtection
implements Protection {
    private final boolean tEnabled;
    private Debug debug;
    private ArmorStandEditorPlugin plugin = ArmorStandEditorPlugin.instance();

    public TownyProtection() {
        this.debug = new Debug(this.plugin);
        this.tEnabled = Bukkit.getPluginManager().isPluginEnabled("Towny");
    }

    @Override
    public boolean checkPermission(Block block, Player player) {
        if (!this.tEnabled || player.isOp() || player.hasPermission("asedit.ignoreProtection.towny")) {
            return true;
        }
        TownyAPI towny = TownyAPI.getInstance();
        Location playerLoc = player.getLocation();
        Location asLoc = block.getLocation();
        ArmorStand entityOnBlock = this.findArmorStandOnBlock(asLoc);
        if (entityOnBlock == null) {
            this.debug.log("No ArmorStand has been found therefore we will continue as intended");
            return true;
        }
        this.debug.log("Editing ArmorStand: " + String.valueOf(entityOnBlock.getUniqueId()));
        if (towny.isWilderness(playerLoc)) {
            if (player.hasPermission("asedit.townyProtection.canEditInWild")) {
                this.debug.log("User '" + player.getDisplayName() + "' is in the Wilderness and has the permission asedit.townyProtection.canEditInWild set to TRUE. Edits are allowed!");
                return true;
            }
            player.sendMessage(this.plugin.getLang().getMessage("townyNoWildEdit", "warn"));
            return false;
        }
        return PlayerCacheUtil.getCachePermission((Player)player, (Location)entityOnBlock.getLocation(), (Material)Material.ARMOR_STAND, (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
    }

    private ArmorStand findArmorStandOnBlock(Location asLoc) {
        BoundingBox bbox = BoundingBox.of((Location)asLoc, (double)1.0, (double)1.0, (double)1.0).shift(0.0, 1.0, 0.0);
        for (Entity entity : asLoc.getWorld().getNearbyEntities(bbox)) {
            if (!(entity instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)entity;
            Location entityLoc = stand.getLocation();
            this.debug.log("ArmorStand Found at X: " + entityLoc.getBlockX() + ", Y: " + entityLoc.getBlockY() + ", Z: " + entityLoc.getBlockZ());
            if (entityLoc.getBlockX() != asLoc.getBlockX() || entityLoc.getBlockZ() != asLoc.getBlockZ() || entityLoc.getBlockY() != asLoc.getBlockY() + 1) continue;
            return stand;
        }
        this.debug.log("Entity found at X: " + asLoc.getBlockX() + ", Y: " + asLoc.getBlockY() + "1, Z: " + asLoc.getBlockZ() + " is not an ArmorStand. So we will return NULL - Will do so for ItemFrames etc.");
        return null;
    }
}

