/*
 * Decompiled with CFR 0.152.
 */
package io.github.rypofalem.armorstandeditor.protections;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import io.github.rypofalem.armorstandeditor.protections.Protection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class WorldGuardProtection
implements Protection {
    private final boolean wgEnabled = Bukkit.getPluginManager().isPluginEnabled("WorldGuard");
    private RegionQuery regionQry;

    public WorldGuardProtection() {
        if (!this.wgEnabled) {
            return;
        }
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        this.regionQry = regionContainer.createQuery();
    }

    @Override
    public boolean checkPermission(Block block, Player player) {
        if (!this.wgEnabled) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission("asedit.ignoreProtection.worldGuard")) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        return this.regionQry.testState(BukkitAdapter.adapt((Location)block.getLocation()), localPlayer, new StateFlag[]{Flags.BUILD});
    }
}

