/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.animation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.animation.ParticleAnimation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lur/kryz/rtp/animation/ParticleManager;", "Lorg/bukkit/scheduler/BukkitRunnable;", "plugin", "Lorg/bukkit/plugin/Plugin;", "(Lorg/bukkit/plugin/Plugin;)V", "activeAnimations", "", "Ljava/util/UUID;", "Lur/kryz/rtp/animation/ParticleManager$AnimationState;", "running", "", "isRunning", "run", "", "startFor", "player", "Lorg/bukkit/entity/Player;", "animation", "Lur/kryz/rtp/animation/ParticleAnimation;", "stopFor", "AnimationState", "NextRTP"})
public final class ParticleManager
extends BukkitRunnable {
    @NotNull
    private final Plugin plugin;
    private boolean running;
    @NotNull
    private final Map<UUID, AnimationState> activeAnimations;

    public ParticleManager(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.activeAnimations = new HashMap();
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void startFor(@NotNull Player player, @Nullable ParticleAnimation animation) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (animation == null) {
            return;
        }
        Map<UUID, AnimationState> map = this.activeAnimations;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uUID2 = uUID;
        AnimationState animationState = new AnimationState(player, animation, 0.0);
        map.put(uUID2, animationState);
        if (!this.running) {
            this.runTaskTimerAsynchronously(this.plugin, 0L, 1L);
            this.running = true;
        }
    }

    public final void stopFor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.activeAnimations.remove(player.getUniqueId());
    }

    public void run() {
        if (this.activeAnimations.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, AnimationState>> it = this.activeAnimations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, AnimationState> entry = it.next();
            AnimationState state = entry.getValue();
            if (!state.getPlayer().isOnline()) {
                it.remove();
                continue;
            }
            state.setT(state.getT() + 0.05);
            state.getAnimation().tick(state.getPlayer(), state.getT());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lur/kryz/rtp/animation/ParticleManager$AnimationState;", "", "player", "Lorg/bukkit/entity/Player;", "animation", "Lur/kryz/rtp/animation/ParticleAnimation;", "t", "", "(Lorg/bukkit/entity/Player;Lur/kryz/rtp/animation/ParticleAnimation;D)V", "getAnimation", "()Lur/kryz/rtp/animation/ParticleAnimation;", "getPlayer", "()Lorg/bukkit/entity/Player;", "getT", "()D", "setT", "(D)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "NextRTP"})
    private static final class AnimationState {
        @NotNull
        private final Player player;
        @NotNull
        private final ParticleAnimation animation;
        private double t;

        public AnimationState(@NotNull Player player, @NotNull ParticleAnimation animation, double t) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(animation, "animation");
            this.player = player;
            this.animation = animation;
            this.t = t;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final ParticleAnimation getAnimation() {
            return this.animation;
        }

        public final double getT() {
            return this.t;
        }

        public final void setT(double d) {
            this.t = d;
        }

        @NotNull
        public final Player component1() {
            return this.player;
        }

        @NotNull
        public final ParticleAnimation component2() {
            return this.animation;
        }

        public final double component3() {
            return this.t;
        }

        @NotNull
        public final AnimationState copy(@NotNull Player player, @NotNull ParticleAnimation animation, double t) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(animation, "animation");
            return new AnimationState(player, animation, t);
        }

        public static /* synthetic */ AnimationState copy$default(AnimationState animationState, Player player, ParticleAnimation particleAnimation, double d, int n, Object object) {
            if ((n & 1) != 0) {
                player = animationState.player;
            }
            if ((n & 2) != 0) {
                particleAnimation = animationState.animation;
            }
            if ((n & 4) != 0) {
                d = animationState.t;
            }
            return animationState.copy(player, particleAnimation, d);
        }

        @NotNull
        public String toString() {
            return "AnimationState(player=" + this.player + ", animation=" + this.animation + ", t=" + this.t + ")";
        }

        public int hashCode() {
            int result = this.player.hashCode();
            result = result * 31 + this.animation.hashCode();
            result = result * 31 + Double.hashCode(this.t);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnimationState)) {
                return false;
            }
            AnimationState animationState = (AnimationState)other;
            if (!Intrinsics.areEqual(this.player, animationState.player)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.animation, animationState.animation)) {
                return false;
            }
            return Double.compare(this.t, animationState.t) == 0;
        }
    }
}

