/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.animation;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.animation.ParticleAnimation;
import ur.kryz.rtp.animation.impl.DNAAnimation;
import ur.kryz.rtp.animation.impl.DoubleSpiralAnimation;
import ur.kryz.rtp.animation.impl.HaloAnimation;
import ur.kryz.rtp.animation.impl.OrbitalAnimation;
import ur.kryz.rtp.animation.impl.SpiralAnimation;
import ur.kryz.rtp.animation.impl.VortexAnimation;
import ur.kryz.rtp.animation.impl.WaveSpiralAnimation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lur/kryz/rtp/animation/ParticleProvider;", "", "()V", "get", "Lur/kryz/rtp/animation/ParticleAnimation;", "type", "", "NextRTP"})
public final class ParticleProvider {
    @NotNull
    public static final ParticleProvider INSTANCE = new ParticleProvider();

    private ParticleProvider() {
    }

    @JvmStatic
    @Nullable
    public static final ParticleAnimation get(@NotNull String type) {
        Intrinsics.checkNotNullParameter(type, "type");
        return switch (type) {
            case "SPIRAL" -> new SpiralAnimation();
            case "DOUBLE_SPIRAL" -> new DoubleSpiralAnimation();
            case "HALO" -> new HaloAnimation();
            case "VORTEX" -> new VortexAnimation();
            case "ORBITAL" -> new OrbitalAnimation();
            case "DNA" -> new DNAAnimation();
            case "WAVE" -> new WaveSpiralAnimation();
            case "" -> null;
            default -> null;
        };
    }
}

