/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.file.YamlSection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J:\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\rH\u0002J\u001b\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010\"J#\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010#\u001a\u0002H!H\u0007\u00a2\u0006\u0002\u0010$J4\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010(\u001a\u00020\u001bJ\u0006\u0010)\u001a\u00020\u001bJ\u0016\u0010*\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0001J.\u0010,\u001a\u00020\u001b2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0001H\u0002R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lur/kryz/rtp/file/YamlFile;", "", "file", "Ljava/io/File;", "stream", "Ljava/io/InputStream;", "(Ljava/io/File;Ljava/io/InputStream;)V", "all", "", "", "getAll", "()Ljava/util/Map;", "flatCache", "", "keys", "", "getKeys", "()Ljava/util/Set;", "rawData", "sectionCache", "Lur/kryz/rtp/file/YamlSection;", "yaml", "Lorg/yaml/snakeyaml/Yaml;", "contains", "", "path", "createParentDirs", "", "flattenMap", "prefix", "source", "target", "get", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "def", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getNestedMap", "map", "getSection", "load", "save", "set", "value", "setInNestedMap", "Companion", "NextRTP"})
@SourceDebugExtension(value={"SMAP\nYamlFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlFile.kt\nur/kryz/rtp/file/YamlFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,170:1\n1#2:171\n731#3,9:172\n731#3,9:183\n37#4,2:181\n37#4,2:192\n*S KotlinDebug\n*F\n+ 1 YamlFile.kt\nur/kryz/rtp/file/YamlFile\n*L\n123#1:172,9\n143#1:183,9\n123#1:181,2\n143#1:192,2\n*E\n"})
public final class YamlFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final InputStream stream;
    @NotNull
    private final Yaml yaml;
    @Nullable
    private Map<String, Object> rawData;
    @NotNull
    private final Map<String, Object> flatCache;
    @NotNull
    private final Map<String, YamlSection> sectionCache;

    public YamlFile(@NotNull File file, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(stream, "stream");
        this.file = file;
        this.stream = stream;
        this.flatCache = new HashMap();
        this.sectionCache = new HashMap();
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer(options);
        representer.getPropertyUtils().setSkipMissingProperties(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        SafeConstructor constructor = new SafeConstructor(loaderOptions);
        this.yaml = new Yaml((BaseConstructor)constructor, representer, options);
        this.load();
    }

    private final void createParentDirs() {
        Path path = this.file.toPath();
        try {
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    boolean bl = false;
                    String string = "Unable to create parent directories for " + path;
                    throw new IllegalStateException(string.toString());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create parent directories for " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        Object object;
        Object object2;
        Object path;
        if (!this.file.exists()) {
            path = this.file.toPath();
            this.rawData = new LinkedHashMap();
            this.createParentDirs();
            try {
                object2 = this.stream;
                object = null;
                try {
                    InputStream input22 = (InputStream)object2;
                    boolean bl = false;
                    long input22 = Files.copy(input22, (Path)path, new CopyOption[0]);
                }
                catch (Throwable input22) {
                    object = input22;
                    throw input22;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to copy default configuration from resource to " + (Path)path, e);
            }
        }
        try {
            path = new FileInputStream(this.file);
            object2 = null;
            try {
                FileInputStream input = (FileInputStream)path;
                boolean bl = false;
                Object loaded = this.yaml.load((InputStream)input);
                this.rawData = loaded instanceof Map ? TypeIntrinsics.asMutableMap(loaded) : (Map)new LinkedHashMap();
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)path, (Throwable)object2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.rawData = new LinkedHashMap();
        }
        this.flatCache.clear();
        this.sectionCache.clear();
        this.flattenMap("", this.rawData, this.flatCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        try {
            Closeable closeable = new FileWriter(this.file);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                this.yaml.dump(this.rawData, (Writer)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void flattenMap(String prefix, Map<String, ? extends Object> source, Map<String, Object> target) {
        Map<String, ? extends Object> map = source;
        Intrinsics.checkNotNull(map);
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String key;
            String key1 = entry.getKey();
            Object value = entry.getValue();
            String string = key = ((CharSequence)prefix).length() == 0 ? key1 : prefix + "." + key1;
            if (value instanceof Map) {
                this.flattenMap(key, (Map)value, target);
                continue;
            }
            target.put(key, value);
        }
    }

    @Nullable
    public final <T> T get(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return (T)this.flatCache.get(path);
    }

    @Nonnull
    public final <T> T get(@NotNull String path, T def) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object value = this.flatCache.get(path);
        Object object = value;
        if (object == null) {
            object = def;
        }
        return (T)object;
    }

    public final boolean contains(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.flatCache.containsKey(path);
    }

    public final void set(@NotNull String path, @NotNull Object value) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(value, "value");
        this.setInNestedMap(this.rawData, path, value);
        this.flatCache.put(path, value);
        this.sectionCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void setInNestedMap(Map<String, Object> map, String path, Object value) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Object object = path;
        Regex regex = new Regex("\\.");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] keys2 = thisCollection$iv.toArray(new String[0]);
        Map current = map;
        int n2 = keys2.length - 1;
        for (int i = 0; i < n2; ++i) {
            Map map2 = current;
            Intrinsics.checkNotNull(map2);
            Object object2 = map2.computeIfAbsent((String)keys2[i], arg_0 -> YamlFile.setInNestedMap$lambda$5(setInNestedMap.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            current = TypeIntrinsics.asMutableMap(object2);
        }
        Map map3 = current;
        Intrinsics.checkNotNull(map3);
        map3.put((String)keys2[keys2.length - 1], (Object)value);
    }

    @Nullable
    public final YamlSection getSection(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (this.sectionCache.containsKey(path)) {
            return this.sectionCache.get(path);
        }
        Map<String, Object> map = this.getNestedMap(this.rawData, path);
        if (map == null) {
            return null;
        }
        Map<String, Object> section = map;
        YamlSection yamlSection = new YamlSection(path, section);
        this.sectionCache.put(path, yamlSection);
        return yamlSection;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getNestedMap(Map<String, ? extends Object> map, String path) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Object object = path;
        Regex regex = new Regex("\\.");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] keys2 = thisCollection$iv.toArray(new String[0]);
        Object current = map;
        for (String key : keys2) {
            if (!(current instanceof Map)) {
                return null;
            }
            current = current.get(key);
        }
        return current instanceof Map ? current : null;
    }

    @NotNull
    public final Set<String> getKeys() {
        return this.flatCache.keySet();
    }

    @NotNull
    public final Map<String, Object> getAll() {
        return this.flatCache;
    }

    private static final Object setInNestedMap$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final YamlFile load(@NotNull String name, @NotNull NextRTPPlugin plugin) {
        return Companion.load(name, plugin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lur/kryz/rtp/file/YamlFile$Companion;", "", "()V", "load", "Lur/kryz/rtp/file/YamlFile;", "name", "", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "NextRTP"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final YamlFile load(@NotNull String name, @NotNull NextRTPPlugin plugin) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            File file = new File(plugin.getDataFolder(), name);
            InputStream inputStream = plugin.getResource(name);
            if (inputStream == null) {
                throw new IllegalStateException("Resource not found: " + name);
            }
            InputStream stream = inputStream;
            return new YamlFile(file, stream);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

