/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.hook;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.manager.CooldownManager;
import ur.kryz.rtp.modules.main.RandomTeleportModule;
import ur.kryz.rtp.modules.main.task.RtpContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lur/kryz/rtp/hook/PlaceholderAPIHook;", "", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "(Lur/kryz/rtp/NextRTPPlugin;)V", "enabled", "", "expansion", "Lur/kryz/rtp/hook/PlaceholderAPIHook$Expansion;", "register", "", "setPlaceholders", "", "player", "Lorg/bukkit/entity/Player;", "msg", "Companion", "Expansion", "NextRTP"})
public final class PlaceholderAPIHook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NextRTPPlugin plugin;
    private boolean enabled;
    @Nullable
    private Expansion expansion;
    private static PlaceholderAPIHook instance;

    public PlaceholderAPIHook(@NotNull NextRTPPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        instance = this;
        this.enabled = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        if (this.enabled) {
            this.expansion = new Expansion(this.plugin);
        }
    }

    public final void register() {
        block0: {
            Expansion expansion = this.expansion;
            if (expansion == null) break block0;
            expansion.register();
        }
    }

    @NotNull
    public final String setPlaceholders(@NotNull Player player, @NotNull String msg) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(msg, "msg");
        String msg2 = msg;
        if (this.enabled) {
            String string = PlaceholderAPI.setBracketPlaceholders((Player)player, (String)msg2);
            Intrinsics.checkNotNullExpressionValue(string, "setBracketPlaceholders(...)");
            msg2 = string;
            String string2 = PlaceholderAPI.setPlaceholders((Player)player, (String)msg2);
            Intrinsics.checkNotNullExpressionValue(string2, "setPlaceholders(...)");
            return string2;
        }
        return msg2;
    }

    @JvmStatic
    @NotNull
    public static final PlaceholderAPIHook getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lur/kryz/rtp/hook/PlaceholderAPIHook$Companion;", "", "()V", "instance", "Lur/kryz/rtp/hook/PlaceholderAPIHook;", "getInstance", "NextRTP"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PlaceholderAPIHook getInstance() {
            PlaceholderAPIHook placeholderAPIHook = instance;
            if (placeholderAPIHook == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                placeholderAPIHook = null;
            }
            return placeholderAPIHook;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lur/kryz/rtp/hook/PlaceholderAPIHook$Expansion;", "Lme/clip/placeholderapi/expansion/PlaceholderExpansion;", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "(Lur/kryz/rtp/NextRTPPlugin;)V", "getAuthor", "", "getIdentifier", "getPlaceholders", "", "getVersion", "onRequest", "player", "Lorg/bukkit/OfflinePlayer;", "params", "NextRTP"})
    public static final class Expansion
    extends PlaceholderExpansion {
        @NotNull
        private final NextRTPPlugin plugin;

        public Expansion(@NotNull NextRTPPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            this.plugin = plugin;
        }

        @NotNull
        public String getIdentifier() {
            return "nextrtp";
        }

        @NotNull
        public String getAuthor() {
            List list = this.plugin.getPluginMeta().getAuthors();
            Intrinsics.checkNotNullExpressionValue(list, "getAuthors(...)");
            Object t = CollectionsKt.first(list);
            Intrinsics.checkNotNullExpressionValue(t, "first(...)");
            return (String)t;
        }

        @NotNull
        public String getVersion() {
            String string = this.plugin.getPluginMeta().getVersion();
            Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
            return string;
        }

        @NotNull
        public List<String> getPlaceholders() {
            String[] stringArray = new String[]{"teleport_progress_time", "teleport_cooldown", "teleport_money"};
            return CollectionsKt.listOf(stringArray);
        }

        @NotNull
        public String onRequest(@NotNull OfflinePlayer player, @NotNull String params) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(params, "params");
            if (!(player instanceof Player)) {
                return "";
            }
            RandomTeleportModule module = this.plugin.getModuleManager().getModule(RandomTeleportModule.class);
            return switch (params) {
                case "teleport_progress_time" -> {
                    RtpContainer container = module.getTask().getContainer((Player)player);
                    if (container == null) {
                        module.getConfig().get("teleport.delay");
                    }
                    RtpContainer v0 = container;
                    Intrinsics.checkNotNull(v0);
                    int seconds = v0.getSeconds();
                    yield String.valueOf(seconds);
                }
                case "teleport_cooldown" -> {
                    CooldownManager cooldownManager = module.getCooldownManager();
                    if (!cooldownManager.isOnCooldown((Player)player)) {
                        module.getConfig().get("teleport.cooldown");
                    }
                    long left = cooldownManager.getTimeLeft((Player)player) / 1000L;
                    yield String.valueOf(left);
                }
                case "teleport_money" -> {
                    Number money;
                    Number v2 = money = (Number)module.getConfig().get("teleport.money");
                    Intrinsics.checkNotNull(v2);
                    yield String.valueOf(v2.doubleValue());
                }
                default -> "";
            };
        }
    }
}

