/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lur/kryz/rtp/manager/CooldownManager;", "", "cooldownSeconds", "", "(I)V", "cooldownDurationMillis", "", "cooldowns", "", "Ljava/util/UUID;", "applyCooldown", "", "player", "Lorg/bukkit/entity/Player;", "clear", "getTimeLeft", "isOnCooldown", "", "NextRTP"})
public final class CooldownManager {
    @NotNull
    private final Map<UUID, Long> cooldowns = new HashMap();
    private final long cooldownDurationMillis;

    public CooldownManager(int cooldownSeconds) {
        this.cooldownDurationMillis = (long)cooldownSeconds * 1000L;
    }

    public final boolean isOnCooldown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        long now = System.currentTimeMillis();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return ((Number)this.cooldowns.getOrDefault(uUID, 0L)).longValue() > now;
    }

    public final long getTimeLeft(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        long now = System.currentTimeMillis();
        double d = 0.0;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        double d2 = ((Number)this.cooldowns.getOrDefault(uUID, 0L)).longValue() - now;
        return (long)Math.max(d, d2);
    }

    public final void applyCooldown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Map<UUID, Long> map = this.cooldowns;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uUID2 = uUID;
        Long l = System.currentTimeMillis() + this.cooldownDurationMillis;
        map.put(uUID2, l);
    }

    public final void clear(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.cooldowns.remove(player.getUniqueId());
    }
}

