/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.manager;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.file.YamlSection;
import ur.kryz.rtp.hook.PlaceholderAPIHook;
import ur.kryz.rtp.parser.LegacyParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005&'()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J1\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\nJ \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\bH\u0007J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lur/kryz/rtp/manager/TitleAnimationManager;", "", "()V", "activeAnimations", "", "Ljava/util/UUID;", "Lur/kryz/rtp/manager/TitleAnimationManager$ActiveAnimation;", "config", "Lur/kryz/rtp/file/YamlFile;", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "init", "", "isAnimating", "", "player", "Lorg/bukkit/entity/Player;", "loadAnimation", "T", "pathName", "", "delay", "", "factory", "Lur/kryz/rtp/manager/TitleAnimationManager$AnimationFactory;", "(Ljava/lang/String;ILur/kryz/rtp/manager/TitleAnimationManager$AnimationFactory;)Ljava/lang/Object;", "reload", "set", "pluginInstance", "setPlaceholders", "ins", "Lur/kryz/rtp/hook/PlaceholderAPIHook;", "frame", "start", "yaml", "stop", "ActionBarAnimation", "ActiveAnimation", "AnimationFactory", "SubTitleAnimation", "TitleAnimation", "NextRTP"})
public final class TitleAnimationManager {
    @NotNull
    public static final TitleAnimationManager INSTANCE = new TitleAnimationManager();
    @NotNull
    private static final Map<UUID, ActiveAnimation> activeAnimations = new HashMap();
    @NotNull
    private static final ScheduledExecutorService scheduler;
    private static NextRTPPlugin plugin;
    @Nullable
    private static YamlFile config;

    private TitleAnimationManager() {
    }

    public final void reload() {
        YamlFile yamlFile = config;
        Intrinsics.checkNotNull(yamlFile);
        yamlFile.load();
    }

    public final void init() {
        NextRTPPlugin nextRTPPlugin = plugin;
        if (nextRTPPlugin == null) {
            Intrinsics.throwUninitializedPropertyAccessException("plugin");
            nextRTPPlugin = null;
        }
        config = YamlFile.Companion.load("animations.yml", nextRTPPlugin);
        PlaceholderAPIHook instance2 = PlaceholderAPIHook.Companion.getInstance();
        scheduler.scheduleAtFixedRate(() -> TitleAnimationManager.init$lambda$0(instance2), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public final void set(@NotNull NextRTPPlugin pluginInstance) {
        Intrinsics.checkNotNullParameter((Object)pluginInstance, "pluginInstance");
        plugin = pluginInstance;
    }

    @JvmStatic
    public static final void start(@NotNull Player player, @NotNull YamlFile yaml) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(yaml, "yaml");
        if (!yaml.get("titles.enabled", false).booleanValue()) {
            return;
        }
        if (!yaml.get("titles.delay.ui.enabled", false).booleanValue()) {
            return;
        }
        YamlSection yamlSection = yaml.getSection("titles.delay.ui");
        if (yamlSection == null) {
            throw new NoSuchElementException("The path 'titles.delay.ui' was not found, please add it.");
        }
        YamlSection path = yamlSection;
        int delay = ((Number)yaml.get("teleport.delay", 5)).intValue();
        String titleValue = path.get("title", "");
        String subtitleValue = path.get("subtitle", "");
        String actionbarValue = path.get("actionbar", "");
        TitleAnimation title = INSTANCE.loadAnimation(titleValue, delay, TitleAnimationManager::start$lambda$1);
        SubTitleAnimation subTitle = INSTANCE.loadAnimation(subtitleValue, delay, TitleAnimationManager::start$lambda$2);
        ActionBarAnimation actionBar = INSTANCE.loadAnimation(actionbarValue, delay, TitleAnimationManager::start$lambda$3);
        Map<UUID, ActiveAnimation> map = activeAnimations;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uUID2 = uUID;
        ActiveAnimation activeAnimation = new ActiveAnimation(title, subTitle, actionBar);
        map.put(uUID2, activeAnimation);
    }

    private final <T> T loadAnimation(String pathName, int delay, AnimationFactory<T> factory) {
        YamlFile yamlFile = config;
        Intrinsics.checkNotNull(yamlFile);
        if (yamlFile.getSection("animations." + pathName) == null || StringsKt.isBlank(pathName)) {
            return factory.create(CollectionsKt.listOf(LegacyParser.parse(pathName)), delay * 1000);
        }
        YamlFile yamlFile2 = config;
        Intrinsics.checkNotNull(yamlFile2);
        Integer interval = (Integer)yamlFile2.get("animations." + pathName + ".interval");
        YamlFile yamlFile3 = config;
        Intrinsics.checkNotNull(yamlFile3);
        Object t = yamlFile3.get("animations." + pathName + ".value");
        Intrinsics.checkNotNull(t);
        List rawFrames = (List)t;
        List parsedFrames = new ArrayList();
        for (String frame : rawFrames) {
            parsedFrames.add(LegacyParser.parse(frame));
        }
        Integer n = interval;
        Intrinsics.checkNotNull(n);
        return factory.create(parsedFrames, n);
    }

    @JvmStatic
    public static final void stop(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        activeAnimations.remove(player.getUniqueId());
    }

    public final boolean isAnimating(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return activeAnimations.containsKey(player.getUniqueId());
    }

    private final String setPlaceholders(PlaceholderAPIHook ins, Player player, String frame) {
        return ins.setPlaceholders(player, frame);
    }

    private static final void init$lambda$0(PlaceholderAPIHook $instance) {
        Intrinsics.checkNotNullParameter($instance, "$instance");
        long now = System.currentTimeMillis();
        List toRemove = new ArrayList();
        for (Map.Entry<UUID, ActiveAnimation> entry : activeAnimations.entrySet()) {
            String frame;
            UUID uuid = entry.getKey();
            ActiveAnimation anim = entry.getValue();
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) {
                toRemove.add(uuid);
                continue;
            }
            MiniMessage m = NextRTPPlugin.MINI_MESSAGE;
            boolean updateTitle = false;
            boolean updateSubtitle = false;
            if (anim.getTitle() != null && now - anim.getLastTitleUpdate() >= (long)anim.getTitle().interval()) {
                frame = anim.getTitle().frames().get(anim.getTitleIndex());
                anim.setTitleIndex((anim.getTitleIndex() + 1) % anim.getTitle().frames().size());
                anim.setLastTitleUpdate(now);
                Component component = m.deserialize((Object)INSTANCE.setPlaceholders($instance, player, frame));
                Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                anim.setLastTitle(component);
                updateTitle = true;
            }
            if (anim.getSubTitle() != null && now - anim.getLastSubTitleUpdate() >= (long)anim.getSubTitle().interval()) {
                frame = anim.getSubTitle().frames().get(anim.getSubTitleIndex());
                anim.setSubTitleIndex((anim.getSubTitleIndex() + 1) % anim.getSubTitle().frames().size());
                anim.setLastSubTitleUpdate(now);
                Component component = m.deserialize((Object)INSTANCE.setPlaceholders($instance, player, frame));
                Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                anim.setLastSubtitle(component);
                updateSubtitle = true;
            }
            if (updateTitle || updateSubtitle) {
                Title t;
                Title.Times time;
                int interval = anim.getTitle() != null ? anim.getTitle().interval() : (anim.getSubTitle() != null ? anim.getSubTitle().interval() : 1000);
                Intrinsics.checkNotNullExpressionValue(Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(interval + 80), (Duration)Duration.ofMillis(0L)), "times(...)");
                Intrinsics.checkNotNullExpressionValue(Title.title((Component)anim.getLastTitle(), (Component)anim.getLastSubtitle(), (Title.Times)time), "title(...)");
                player.showTitle(t);
            }
            if (anim.getActionBar() == null || now - anim.getLastActionBarUpdate() < (long)anim.getActionBar().interval()) continue;
            String frame2 = anim.getActionBar().frames().get(anim.getActionBarIndex());
            anim.setActionBarIndex((anim.getActionBarIndex() + 1) % anim.getActionBar().frames().size());
            anim.setLastActionBarUpdate(now);
            player.sendActionBar(m.deserialize((Object)INSTANCE.setPlaceholders($instance, player, frame2)));
        }
        for (UUID uuid : toRemove) {
            activeAnimations.remove(uuid);
        }
    }

    private static final TitleAnimation start$lambda$1(List frames, int interval) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new TitleAnimation(frames, interval);
    }

    private static final SubTitleAnimation start$lambda$2(List frames, int interval) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new SubTitleAnimation(frames, interval);
    }

    private static final ActionBarAnimation start$lambda$3(List frames, int interval) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new ActionBarAnimation(frames, interval);
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "newSingleThreadScheduledExecutor(...)");
        scheduler = scheduledExecutorService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J#\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\t\u00a8\u0006\u0013"}, d2={"Lur/kryz/rtp/manager/TitleAnimationManager$ActionBarAnimation;", "Ljava/lang/Record;", "frames", "", "", "interval", "", "(Ljava/util/List;I)V", "()Ljava/util/List;", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "NextRTP"})
    public static final class ActionBarAnimation
    extends Record {
        @NotNull
        private final List<String> frames;
        private final int interval;

        public ActionBarAnimation(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            this.frames = frames;
            this.interval = interval;
        }

        @NotNull
        public final List<String> frames() {
            return this.frames;
        }

        public final int interval() {
            return this.interval;
        }

        @NotNull
        public final List<String> component1() {
            return this.frames;
        }

        public final int component2() {
            return this.interval;
        }

        @NotNull
        public final ActionBarAnimation copy(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            return new ActionBarAnimation(frames, interval);
        }

        public static /* synthetic */ ActionBarAnimation copy$default(ActionBarAnimation actionBarAnimation, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = actionBarAnimation.frames;
            }
            if ((n2 & 2) != 0) {
                n = actionBarAnimation.interval;
            }
            return actionBarAnimation.copy(list, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "ActionBarAnimation(frames=" + this.frames + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.frames).hashCode();
            result = result * 31 + Integer.hashCode(this.interval);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActionBarAnimation)) {
                return false;
            }
            ActionBarAnimation actionBarAnimation = (ActionBarAnimation)other;
            if (!Intrinsics.areEqual(this.frames, actionBarAnimation.frames)) {
                return false;
            }
            return this.interval == actionBarAnimation.interval;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0014\"\u0004\b%\u0010\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u000e\"\u0004\b*\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u000e\"\u0004\b/\u0010\u0010\u00a8\u00060"}, d2={"Lur/kryz/rtp/manager/TitleAnimationManager$ActiveAnimation;", "", "title", "Lur/kryz/rtp/manager/TitleAnimationManager$TitleAnimation;", "subTitle", "Lur/kryz/rtp/manager/TitleAnimationManager$SubTitleAnimation;", "actionBar", "Lur/kryz/rtp/manager/TitleAnimationManager$ActionBarAnimation;", "(Lur/kryz/rtp/manager/TitleAnimationManager$TitleAnimation;Lur/kryz/rtp/manager/TitleAnimationManager$SubTitleAnimation;Lur/kryz/rtp/manager/TitleAnimationManager$ActionBarAnimation;)V", "getActionBar", "()Lur/kryz/rtp/manager/TitleAnimationManager$ActionBarAnimation;", "actionBarIndex", "", "getActionBarIndex", "()I", "setActionBarIndex", "(I)V", "lastActionBarUpdate", "", "getLastActionBarUpdate", "()J", "setLastActionBarUpdate", "(J)V", "lastSubTitleUpdate", "getLastSubTitleUpdate", "setLastSubTitleUpdate", "lastSubtitle", "Lnet/kyori/adventure/text/Component;", "getLastSubtitle", "()Lnet/kyori/adventure/text/Component;", "setLastSubtitle", "(Lnet/kyori/adventure/text/Component;)V", "lastTitle", "getLastTitle", "setLastTitle", "lastTitleUpdate", "getLastTitleUpdate", "setLastTitleUpdate", "getSubTitle", "()Lur/kryz/rtp/manager/TitleAnimationManager$SubTitleAnimation;", "subTitleIndex", "getSubTitleIndex", "setSubTitleIndex", "getTitle", "()Lur/kryz/rtp/manager/TitleAnimationManager$TitleAnimation;", "titleIndex", "getTitleIndex", "setTitleIndex", "NextRTP"})
    public static final class ActiveAnimation {
        @Nullable
        private final TitleAnimation title;
        @Nullable
        private final SubTitleAnimation subTitle;
        @Nullable
        private final ActionBarAnimation actionBar;
        private long lastTitleUpdate;
        private long lastSubTitleUpdate;
        private long lastActionBarUpdate;
        private int titleIndex;
        private int subTitleIndex;
        private int actionBarIndex;
        @NotNull
        private Component lastTitle;
        @NotNull
        private Component lastSubtitle;

        public ActiveAnimation(@Nullable TitleAnimation title, @Nullable SubTitleAnimation subTitle, @Nullable ActionBarAnimation actionBar) {
            this.title = title;
            this.subTitle = subTitle;
            this.actionBar = actionBar;
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
            this.lastTitle = (Component)textComponent;
            TextComponent textComponent2 = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent2, "empty(...)");
            this.lastSubtitle = (Component)textComponent2;
        }

        @Nullable
        public final TitleAnimation getTitle() {
            return this.title;
        }

        @Nullable
        public final SubTitleAnimation getSubTitle() {
            return this.subTitle;
        }

        @Nullable
        public final ActionBarAnimation getActionBar() {
            return this.actionBar;
        }

        public final long getLastTitleUpdate() {
            return this.lastTitleUpdate;
        }

        public final void setLastTitleUpdate(long l) {
            this.lastTitleUpdate = l;
        }

        public final long getLastSubTitleUpdate() {
            return this.lastSubTitleUpdate;
        }

        public final void setLastSubTitleUpdate(long l) {
            this.lastSubTitleUpdate = l;
        }

        public final long getLastActionBarUpdate() {
            return this.lastActionBarUpdate;
        }

        public final void setLastActionBarUpdate(long l) {
            this.lastActionBarUpdate = l;
        }

        public final int getTitleIndex() {
            return this.titleIndex;
        }

        public final void setTitleIndex(int n) {
            this.titleIndex = n;
        }

        public final int getSubTitleIndex() {
            return this.subTitleIndex;
        }

        public final void setSubTitleIndex(int n) {
            this.subTitleIndex = n;
        }

        public final int getActionBarIndex() {
            return this.actionBarIndex;
        }

        public final void setActionBarIndex(int n) {
            this.actionBarIndex = n;
        }

        @NotNull
        public final Component getLastTitle() {
            return this.lastTitle;
        }

        public final void setLastTitle(@NotNull Component component) {
            Intrinsics.checkNotNullParameter(component, "<set-?>");
            this.lastTitle = component;
        }

        @NotNull
        public final Component getLastSubtitle() {
            return this.lastSubtitle;
        }

        public final void setLastSubtitle(@NotNull Component component) {
            Intrinsics.checkNotNullParameter(component, "<set-?>");
            this.lastSubtitle = component;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00e2\u0080\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J#\u0010\u0003\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lur/kryz/rtp/manager/TitleAnimationManager$AnimationFactory;", "T", "", "create", "frames", "", "", "interval", "", "(Ljava/util/List;I)Ljava/lang/Object;", "NextRTP"})
    private static interface AnimationFactory<T> {
        public T create(@NotNull List<String> var1, int var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J#\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\t\u00a8\u0006\u0013"}, d2={"Lur/kryz/rtp/manager/TitleAnimationManager$SubTitleAnimation;", "Ljava/lang/Record;", "frames", "", "", "interval", "", "(Ljava/util/List;I)V", "()Ljava/util/List;", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "NextRTP"})
    public static final class SubTitleAnimation
    extends Record {
        @NotNull
        private final List<String> frames;
        private final int interval;

        public SubTitleAnimation(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            this.frames = frames;
            this.interval = interval;
        }

        @NotNull
        public final List<String> frames() {
            return this.frames;
        }

        public final int interval() {
            return this.interval;
        }

        @NotNull
        public final List<String> component1() {
            return this.frames;
        }

        public final int component2() {
            return this.interval;
        }

        @NotNull
        public final SubTitleAnimation copy(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            return new SubTitleAnimation(frames, interval);
        }

        public static /* synthetic */ SubTitleAnimation copy$default(SubTitleAnimation subTitleAnimation, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = subTitleAnimation.frames;
            }
            if ((n2 & 2) != 0) {
                n = subTitleAnimation.interval;
            }
            return subTitleAnimation.copy(list, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "SubTitleAnimation(frames=" + this.frames + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.frames).hashCode();
            result = result * 31 + Integer.hashCode(this.interval);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubTitleAnimation)) {
                return false;
            }
            SubTitleAnimation subTitleAnimation = (SubTitleAnimation)other;
            if (!Intrinsics.areEqual(this.frames, subTitleAnimation.frames)) {
                return false;
            }
            return this.interval == subTitleAnimation.interval;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J#\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\t\u00a8\u0006\u0013"}, d2={"Lur/kryz/rtp/manager/TitleAnimationManager$TitleAnimation;", "Ljava/lang/Record;", "frames", "", "", "interval", "", "(Ljava/util/List;I)V", "()Ljava/util/List;", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "NextRTP"})
    public static final class TitleAnimation
    extends Record {
        @NotNull
        private final List<String> frames;
        private final int interval;

        public TitleAnimation(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            this.frames = frames;
            this.interval = interval;
        }

        @NotNull
        public final List<String> frames() {
            return this.frames;
        }

        public final int interval() {
            return this.interval;
        }

        @NotNull
        public final List<String> component1() {
            return this.frames;
        }

        public final int component2() {
            return this.interval;
        }

        @NotNull
        public final TitleAnimation copy(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            return new TitleAnimation(frames, interval);
        }

        public static /* synthetic */ TitleAnimation copy$default(TitleAnimation titleAnimation, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = titleAnimation.frames;
            }
            if ((n2 & 2) != 0) {
                n = titleAnimation.interval;
            }
            return titleAnimation.copy(list, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "TitleAnimation(frames=" + this.frames + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.frames).hashCode();
            result = result * 31 + Integer.hashCode(this.interval);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TitleAnimation)) {
                return false;
            }
            TitleAnimation titleAnimation = (TitleAnimation)other;
            if (!Intrinsics.areEqual(this.frames, titleAnimation.frames)) {
                return false;
            }
            return this.interval == titleAnimation.interval;
        }
    }
}

