/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.modules.PluginModule;
import ur.kryz.rtp.modules.main.RandomTeleportModule;
import ur.kryz.rtp.modules.sign.SignModule;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0006\u0010\f\u001a\u00020\nJ#\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011J\u001e\u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u000e*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007J\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lur/kryz/rtp/modules/ModuleManager;", "", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "(Lur/kryz/rtp/NextRTPPlugin;)V", "moduleMap", "", "Ljava/lang/Class;", "Lur/kryz/rtp/modules/PluginModule;", "disableModule", "", "clazz", "disableModules", "getModule", "T", "(Ljava/lang/Class;)Lur/kryz/rtp/modules/PluginModule;", "getModules", "", "isModuleEnabled", "", "loadModules", "register", "pluginModule", "NextRTP"})
public final class ModuleManager {
    @NotNull
    private final NextRTPPlugin plugin;
    @NotNull
    private final Map<Class<?>, PluginModule> moduleMap;

    public ModuleManager(@NotNull NextRTPPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.moduleMap = new HashMap();
    }

    public final void loadModules() {
        long ms = System.currentTimeMillis();
        this.register(new RandomTeleportModule(this.plugin));
        this.register(new SignModule(this.plugin));
        long total = System.currentTimeMillis() - ms;
        this.plugin.consoleMessage("<gold>" + this.moduleMap.size() + "</gold> modules loaded in <gold>" + total + "ms</gold>");
    }

    public final void disableModules() {
        List<Class> keys2 = CollectionsKt.toList((Iterable)this.moduleMap.keySet());
        for (Class s : keys2) {
            this.disableModule(s);
        }
    }

    @NotNull
    public final <T extends PluginModule> T getModule(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        PluginModule pluginModule = this.moduleMap.get(clazz);
        Intrinsics.checkNotNull(pluginModule);
        return (T)pluginModule;
    }

    @NotNull
    public final Set<PluginModule> getModules() {
        Set hash = new HashSet();
        Set<Map.Entry<Class<?>, PluginModule>> entries = this.moduleMap.entrySet();
        for (Map.Entry<Class<?>, PluginModule> entry : entries) {
            hash.add(entry.getValue());
        }
        return hash;
    }

    private final void register(PluginModule pluginModule) {
        if (pluginModule instanceof RandomTeleportModule) {
            this.moduleMap.put(pluginModule.getClass(), pluginModule);
            pluginModule.setEnabled(true);
            return;
        }
        if (this.plugin.getConfig().getBoolean("modules." + pluginModule.id(), true)) {
            this.moduleMap.put(pluginModule.getClass(), pluginModule);
            pluginModule.setEnabled(true);
        }
    }

    public final <T extends PluginModule> boolean isModuleEnabled(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        PluginModule pluginModule = this.moduleMap.get(clazz);
        Intrinsics.checkNotNull(pluginModule);
        return pluginModule.isEnabled();
    }

    private final void disableModule(Class<?> clazz) {
        PluginModule pluginModule = this.moduleMap.remove(clazz);
        Intrinsics.checkNotNull(pluginModule);
        PluginModule module = pluginModule;
        if (module.isEnabled()) {
            this.plugin.consoleMessage("Disabling <gold>" + module.getModuleName() + "</gold>");
            module.setEnabled(false);
        }
    }
}

