/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.main;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.animation.ParticleManager;
import ur.kryz.rtp.command.paper.NextRootCommand;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.manager.CooldownManager;
import ur.kryz.rtp.modules.PluginModule;
import ur.kryz.rtp.modules.main.RandomTeleportProcessor;
import ur.kryz.rtp.modules.main.command.RtpCommand;
import ur.kryz.rtp.modules.main.command.RtpSudoCommand;
import ur.kryz.rtp.modules.main.command.RtpWorldCommand;
import ur.kryz.rtp.modules.main.task.RtpTask;
import ur.kryz.rtp.modules.main.task.TeleportScheduler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lur/kryz/rtp/modules/main/RandomTeleportModule;", "Lur/kryz/rtp/modules/PluginModule;", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "(Lur/kryz/rtp/NextRTPPlugin;)V", "_cooldown", "Lur/kryz/rtp/manager/CooldownManager;", "_particle", "Lur/kryz/rtp/animation/ParticleManager;", "_task", "Lur/kryz/rtp/modules/main/task/RtpTask;", "config", "Lur/kryz/rtp/file/YamlFile;", "getConfig", "()Lur/kryz/rtp/file/YamlFile;", "cooldownManager", "getCooldownManager", "()Lur/kryz/rtp/manager/CooldownManager;", "particleAnimationManager", "getParticleAnimationManager", "()Lur/kryz/rtp/animation/ParticleManager;", "task", "getTask", "()Lur/kryz/rtp/modules/main/task/RtpTask;", "yaml", "id", "", "onDisable", "", "onEnable", "reload", "NextRTP"})
public final class RandomTeleportModule
extends PluginModule {
    private YamlFile yaml;
    private RtpTask _task;
    private ParticleManager _particle;
    @Nullable
    private CooldownManager _cooldown;

    public RandomTeleportModule(@NotNull NextRTPPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        super(plugin);
    }

    @Override
    public void onEnable() {
        this.yaml = this.loadConfig("rtp.yml");
        NextRootCommand.add(new RtpCommand(this));
        NextRootCommand.add(new RtpSudoCommand(this));
        NextRootCommand.add(new RtpWorldCommand(this));
        YamlFile yamlFile = this.yaml;
        if (yamlFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlFile = null;
        }
        RandomTeleportProcessor.INSTANCE.set(yamlFile);
        this._task = new RtpTask(this);
        RtpTask rtpTask = this._task;
        if (rtpTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask = null;
        }
        rtpTask.runTaskTimerAsynchronously((Plugin)this.getPlugin(), 0L, 5L);
        YamlFile yamlFile2 = this.yaml;
        if (yamlFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlFile2 = null;
        }
        this._cooldown = new CooldownManager(((Number)yamlFile2.get("teleport.cooldown", 30)).intValue());
        this._particle = new ParticleManager((Plugin)this.getPlugin());
    }

    @Override
    public void onDisable() {
        if (this.isEnabled()) {
            RtpTask rtpTask = this._task;
            if (rtpTask == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_task");
                rtpTask = null;
            }
            rtpTask.cancel();
            ParticleManager particleManager = this._particle;
            if (particleManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_particle");
                particleManager = null;
            }
            if (particleManager.isRunning()) {
                ParticleManager particleManager2 = this._particle;
                if (particleManager2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_particle");
                    particleManager2 = null;
                }
                particleManager2.cancel();
            }
        }
    }

    @Override
    public void reload() {
        YamlFile yamlFile = this.yaml;
        if (yamlFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlFile = null;
        }
        yamlFile.load();
        RtpTask rtpTask = this._task;
        if (rtpTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask = null;
        }
        rtpTask.set(new TeleportScheduler(this));
        RtpTask rtpTask2 = this._task;
        if (rtpTask2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask2 = null;
        }
        rtpTask2.loadSounds();
        YamlFile yamlFile2 = this.yaml;
        if (yamlFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlFile2 = null;
        }
        this._cooldown = new CooldownManager(((Number)yamlFile2.get("teleport.cooldown", 30)).intValue());
        RandomTeleportProcessor.INSTANCE.reload();
    }

    @Override
    @NotNull
    public String id() {
        return "rtp";
    }

    @NotNull
    public final YamlFile getConfig() {
        YamlFile yamlFile = this.yaml;
        if (yamlFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlFile = null;
        }
        return yamlFile;
    }

    @NotNull
    public final RtpTask getTask() {
        RtpTask rtpTask = this._task;
        if (rtpTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask = null;
        }
        return rtpTask;
    }

    @NotNull
    public final ParticleManager getParticleAnimationManager() {
        ParticleManager particleManager = this._particle;
        if (particleManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_particle");
            particleManager = null;
        }
        return particleManager;
    }

    @NotNull
    public final CooldownManager getCooldownManager() {
        CooldownManager cooldownManager = this._cooldown;
        if (cooldownManager == null) {
            throw new IllegalStateException("CooldownManager is null.".toString());
        }
        return cooldownManager;
    }
}

