/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.adapter.BiomeAdapter;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.file.YamlSection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001dJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0011H\u0002JF\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019H\u0002J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0%*\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lur/kryz/rtp/modules/main/RandomTeleportProcessor;", "", "()V", "blacklistBiomes", "", "", "blacklistBlocks", "Lorg/bukkit/Material;", "file", "Lur/kryz/rtp/file/YamlFile;", "playerRandomTeleports", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "random", "Ljava/util/Random;", "findValidTeleportLocation", "Lorg/bukkit/Location;", "locations", "", "getSafeY", "", "world", "Lorg/bukkit/World;", "x", "", "z", "maxY", "load", "", "reload", "resolveTeleportArea", "Lur/kryz/rtp/modules/main/RandomTeleportProcessor$TeleportArea;", "section", "Lur/kryz/rtp/file/YamlSection;", "set", "teleport", "Ljava/util/concurrent/CompletableFuture;", "player", "Lorg/bukkit/entity/Player;", "location", "tryTeleport", "baseX", "baseZ", "radius", "attempts", "TeleportArea", "NextRTP"})
@SourceDebugExtension(value={"SMAP\nRandomTeleportProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomTeleportProcessor.kt\nur/kryz/rtp/modules/main/RandomTeleportProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n288#2,2:148\n1549#2:150\n1620#2,3:151\n*S KotlinDebug\n*F\n+ 1 RandomTeleportProcessor.kt\nur/kryz/rtp/modules/main/RandomTeleportProcessor\n*L\n78#1:148,2\n136#1:150\n136#1:151,3\n*E\n"})
public final class RandomTeleportProcessor {
    @NotNull
    public static final RandomTeleportProcessor INSTANCE = new RandomTeleportProcessor();
    @NotNull
    private static final ConcurrentHashMap<UUID, Boolean> playerRandomTeleports = new ConcurrentHashMap();
    @NotNull
    private static final Random random = new Random();
    private static YamlFile file;
    @NotNull
    private static final Set<Material> blacklistBlocks;
    @NotNull
    private static final Set<String> blacklistBiomes;

    private RandomTeleportProcessor() {
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<Boolean> random(@NotNull Player $this$random, @NotNull World world) {
        YamlSection section;
        YamlSection yamlSection;
        Intrinsics.checkNotNullParameter($this$random, "<this>");
        Intrinsics.checkNotNullParameter(world, "world");
        Map map = playerRandomTeleports;
        UUID uUID = $this$random.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uUID2 = uUID;
        Object object = true;
        map.put(uUID2, object);
        YamlFile yamlFile = file;
        if (yamlFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
            yamlFile = null;
        }
        int attempts = ((Number)yamlFile.get("teleport.attempts", 10)).intValue();
        YamlFile yamlFile2 = file;
        if (yamlFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
            yamlFile2 = null;
        }
        if ((yamlSection = (section = yamlFile2.getSection("teleport.area.per_world." + world.getName()))) == null) {
            YamlFile yamlFile3 = file;
            if (yamlFile3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("file");
                yamlFile3 = null;
            }
            if ((yamlSection = yamlFile3.getSection("teleport.area")) == null) {
                throw new IllegalStateException("teleport.area key not found in rtp.yml".toString());
            }
        }
        object = INSTANCE.resolveTeleportArea(yamlSection, world);
        double centerX = ((TeleportArea)object).component1();
        double centerZ = ((TeleportArea)object).component2();
        int radius = ((TeleportArea)object).component3();
        int maxY = ((TeleportArea)object).component4();
        return INSTANCE.tryTeleport($this$random, world, maxY, centerX, centerZ, radius, attempts);
    }

    private final TeleportArea resolveTeleportArea(YamlSection section, World world) {
        Pair<Object, Object> pair;
        boolean useWorldBorder = section.get("use_world_border", false);
        int maxY = ((Number)section.get("max_y", 100)).intValue();
        int radius = ((Number)section.get("radius", 100)).intValue();
        if (useWorldBorder) {
            Location location = world.getWorldBorder().getCenter();
            Intrinsics.checkNotNullExpressionValue(location, "getCenter(...)");
            Location center = location;
            pair = TuplesKt.to(center.getX(), center.getZ());
        } else {
            pair = TuplesKt.to(section.get("center_x"), section.get("center_z"));
        }
        Pair pair2 = pair;
        Double centerX = (Double)pair2.component1();
        Double centerZ = (Double)pair2.component2();
        Double d = centerX;
        Intrinsics.checkNotNull(d);
        double d2 = d;
        Double d3 = centerZ;
        Intrinsics.checkNotNull(d3);
        return new TeleportArea(d2, d3, radius, maxY);
    }

    private final CompletableFuture<Boolean> tryTeleport(Player player, World world, int maxY, double baseX, double baseZ, int radius, int attempts) {
        CompletableFuture<Boolean> completableFuture;
        List candidateLocations = new ArrayList();
        int n = 0;
        while (n < attempts) {
            int it = n++;
            boolean bl = false;
            int blockX = random.nextInt((int)(baseX - (double)radius), (int)(baseX + (double)radius));
            int blockZ = random.nextInt((int)(baseZ - (double)radius), (int)(baseZ + (double)radius));
            double safeY = INSTANCE.getSafeY(world, blockX, blockZ, maxY);
            candidateLocations.add(new Location(world, (double)blockX + 0.5, safeY, (double)blockZ + 0.5));
        }
        Location validLocation = this.findValidTeleportLocation(candidateLocations);
        if (validLocation != null) {
            completableFuture = this.teleport(player, validLocation);
        } else {
            CompletableFuture<Boolean> completableFuture2 = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNull(completableFuture2);
            completableFuture = completableFuture2;
        }
        return completableFuture;
    }

    private final Location findValidTeleportLocation(List<Location> locations) {
        Object v4;
        block2: {
            Iterable $this$firstOrNull$iv = locations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Material belowMaterial;
                Material material;
                Location loc = (Location)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(loc.getBlock().getType(), "getType(...)");
                BiomeAdapter biomeAdapter = BiomeAdapter.Companion.getInstance();
                Biome biome = loc.getBlock().getBiome();
                Intrinsics.checkNotNullExpressionValue(biome, "getBiome(...)");
                NamespacedKey key = (NamespacedKey)biomeAdapter.getKey(biome);
                String stringKey = "";
                if (key != null) {
                    String string = key.getKey();
                    Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
                    stringKey = string;
                }
                Intrinsics.checkNotNullExpressionValue(loc.clone().add(0.0, -1.0, 0.0).getBlock().getType(), "getType(...)");
                boolean bl2 = !(blacklistBlocks.contains(material) || blacklistBlocks.contains(belowMaterial) || blacklistBiomes.contains(stringKey));
                if (!bl2) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        return v4;
    }

    private final CompletableFuture<Boolean> teleport(Player player, Location location) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN).whenComplete((arg_0, arg_1) -> RandomTeleportProcessor.teleport$lambda$2(new Function2<Boolean, Throwable, Unit>(future, player){
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ Player $player;
            {
                this.$future = $future;
                this.$player = $player;
                super(2);
            }

            public final void invoke(Boolean success, Throwable throwable) {
                if (throwable != null) {
                    this.$future.completeExceptionally(throwable);
                } else {
                    Intrinsics.checkNotNull(success);
                    if (success.booleanValue()) {
                        RandomTeleportProcessor.access$getPlayerRandomTeleports$p().remove(this.$player.getUniqueId());
                    }
                    this.$future.complete(success);
                }
            }
        }, arg_0, arg_1));
        return future;
    }

    private final double getSafeY(World world, int x, int z, int maxY) {
        int y;
        int minY = world.getMinHeight();
        if (minY <= (y = maxY)) {
            while (true) {
                Location loc;
                if ((loc = new Location(world, (double)x, (double)y, (double)z)).getBlock().getType() == Material.WATER) {
                    return y;
                }
                if (loc.getBlock().getType().isSolid()) {
                    return y + 1;
                }
                if (y == minY) break;
                --y;
            }
        }
        return world.getHighestBlockYAt(x, z) + 1;
    }

    public final void set(@NotNull YamlFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        RandomTeleportProcessor.file = file;
        this.load();
    }

    /*
     * WARNING - void declaration
     */
    private final void load() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        YamlFile yamlFile = file;
        if (yamlFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
            yamlFile = null;
        }
        Iterable iterable = yamlFile.get("teleport.blacklisted_blocks", CollectionsKt.emptyList());
        Set<Material> set = blacklistBlocks;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Material.valueOf((String)p0));
        }
        set.addAll(CollectionsKt.toSet((List)destination$iv$iv));
        YamlFile yamlFile2 = file;
        if (yamlFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
            yamlFile2 = null;
        }
        blacklistBiomes.addAll(CollectionsKt.toSet(yamlFile2.get("teleport.blacklisted_biomes", CollectionsKt.emptyList())));
    }

    public final void reload() {
        this.load();
    }

    private static final void teleport$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPlayerRandomTeleports$p() {
        return playerRandomTeleports;
    }

    static {
        blacklistBlocks = new HashSet();
        blacklistBiomes = new HashSet();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lur/kryz/rtp/modules/main/RandomTeleportProcessor$TeleportArea;", "", "centerX", "", "centerZ", "radius", "", "maxY", "(DDII)V", "getCenterX", "()D", "getCenterZ", "getMaxY", "()I", "getRadius", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "NextRTP"})
    private static final class TeleportArea {
        private final double centerX;
        private final double centerZ;
        private final int radius;
        private final int maxY;

        public TeleportArea(double centerX, double centerZ, int radius, int maxY) {
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.radius = radius;
            this.maxY = maxY;
        }

        public final double getCenterX() {
            return this.centerX;
        }

        public final double getCenterZ() {
            return this.centerZ;
        }

        public final int getRadius() {
            return this.radius;
        }

        public final int getMaxY() {
            return this.maxY;
        }

        public final double component1() {
            return this.centerX;
        }

        public final double component2() {
            return this.centerZ;
        }

        public final int component3() {
            return this.radius;
        }

        public final int component4() {
            return this.maxY;
        }

        @NotNull
        public final TeleportArea copy(double centerX, double centerZ, int radius, int maxY) {
            return new TeleportArea(centerX, centerZ, radius, maxY);
        }

        public static /* synthetic */ TeleportArea copy$default(TeleportArea teleportArea, double d, double d2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                d = teleportArea.centerX;
            }
            if ((n3 & 2) != 0) {
                d2 = teleportArea.centerZ;
            }
            if ((n3 & 4) != 0) {
                n = teleportArea.radius;
            }
            if ((n3 & 8) != 0) {
                n2 = teleportArea.maxY;
            }
            return teleportArea.copy(d, d2, n, n2);
        }

        @NotNull
        public String toString() {
            return "TeleportArea(centerX=" + this.centerX + ", centerZ=" + this.centerZ + ", radius=" + this.radius + ", maxY=" + this.maxY + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.centerX);
            result = result * 31 + Double.hashCode(this.centerZ);
            result = result * 31 + Integer.hashCode(this.radius);
            result = result * 31 + Integer.hashCode(this.maxY);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TeleportArea)) {
                return false;
            }
            TeleportArea teleportArea = (TeleportArea)other;
            if (Double.compare(this.centerX, teleportArea.centerX) != 0) {
                return false;
            }
            if (Double.compare(this.centerZ, teleportArea.centerZ) != 0) {
                return false;
            }
            if (this.radius != teleportArea.radius) {
                return false;
            }
            return this.maxY == teleportArea.maxY;
        }
    }
}

