/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.main.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.brigadier.ExceptionConstants;
import ur.kryz.rtp.command.paper.SubCommand;
import ur.kryz.rtp.manager.CooldownManager;
import ur.kryz.rtp.modules.main.RandomTeleportModule;
import ur.kryz.rtp.modules.main.task.RtpTask;
import ur.kryz.rtp.utils.DateFormatUtil;
import ur.kryz.rtp.utils.Permissions;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lur/kryz/rtp/modules/main/command/RtpCommand;", "Lur/kryz/rtp/command/paper/SubCommand;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "module", "Lur/kryz/rtp/modules/main/RandomTeleportModule;", "(Lur/kryz/rtp/modules/main/RandomTeleportModule;)V", "build", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "builder", "execute", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "Util", "NextRTP"})
public final class RtpCommand
implements SubCommand<CommandSourceStack> {
    @NotNull
    private final RandomTeleportModule module;

    public RtpCommand(@NotNull RandomTeleportModule module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build(@NotNull LiteralArgumentBuilder<CommandSourceStack> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)builder.requires(RtpCommand::build$lambda$0)).executes(arg_0 -> RtpCommand.build$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "executes(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @Override
    public int execute(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Intrinsics.checkNotNullParameter(context, "context");
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            CommandSyntaxException commandSyntaxException = ExceptionConstants.INSTANCE.getBAD_SOURCE().create();
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "create(...)");
            throw (Throwable)commandSyntaxException;
        }
        Player sender = player;
        World world = sender.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        Util.rtp(this.module, sender, world);
        return 1;
    }

    private static final boolean build$lambda$0(CommandSourceStack source) {
        Intrinsics.checkNotNullParameter(source, "source");
        String[] stringArray = new String[]{"nextrtp.command.rtp"};
        boolean perm = Permissions.anyPermissions(source, stringArray);
        return perm;
    }

    private static final int build$lambda$1(RtpCommand this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(context, "context");
        return this$0.execute((CommandContext<CommandSourceStack>)context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lur/kryz/rtp/modules/main/command/RtpCommand$Util;", "", "()V", "rtp", "", "module", "Lur/kryz/rtp/modules/main/RandomTeleportModule;", "player", "Lorg/bukkit/entity/Player;", "world", "Lorg/bukkit/World;", "NextRTP"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @JvmStatic
        public static final void rtp(@NotNull RandomTeleportModule module, @NotNull Player player, @NotNull World world) {
            Intrinsics.checkNotNullParameter(module, "module");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(world, "world");
            if (module.getTask().isQueued(player)) {
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.progress", new TagResolver.Single[0]);
                return;
            }
            Number money = module.getConfig().get("teleport.money", 100.0);
            double doubleMoney = money.doubleValue();
            String permString = "nextrtp.world." + world.getName();
            if (!player.hasPermission(permString) && !player.hasPermission("nextrtp.world.*")) {
                CommandSender commandSender = (CommandSender)player;
                TagResolver.Single[] singleArray = new TagResolver.Single[1];
                Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"world_name", (String)world.getName()), "unparsed(...)");
                PlayerUtil.sendParsed(commandSender, "messages.world.not_allowed", singleArray);
                return;
            }
            if (!PlayerUtil.hasMoney(player, doubleMoney) && !player.hasPermission("nextrtp.bypass.money")) {
                CommandSender commandSender = (CommandSender)player;
                TagResolver.Single[] singleArray = new TagResolver.Single[1];
                Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"money", (String)String.valueOf(doubleMoney)), "unparsed(...)");
                PlayerUtil.sendParsed(commandSender, "messages.currency.no_money", singleArray);
                return;
            }
            CooldownManager cooldownManager = module.getCooldownManager();
            if (cooldownManager.isOnCooldown(player)) {
                long left = cooldownManager.getTimeLeft(player) / (long)1000;
                CommandSender commandSender = (CommandSender)player;
                TagResolver.Single[] singleArray = new TagResolver.Single[1];
                Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"time", (String)DateFormatUtil.formatTime((int)left)), "unparsed(...)");
                PlayerUtil.sendParsed(commandSender, "messages.teleport.cooldown", singleArray);
                return;
            }
            RtpTask rtpTask = module.getTask();
            Object t = module.getConfig().get("teleport.delay");
            Intrinsics.checkNotNull(t);
            rtpTask.queue(player, ((Number)t).intValue(), world);
        }
    }
}

