/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.main.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.brigadier.Arguments;
import ur.kryz.rtp.brigadier.ExceptionConstants;
import ur.kryz.rtp.command.paper.SubCommand;
import ur.kryz.rtp.command.paper.UsageDisplayable;
import ur.kryz.rtp.modules.main.RandomTeleportModule;
import ur.kryz.rtp.modules.main.command.RtpCommand;
import ur.kryz.rtp.utils.Permissions;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lur/kryz/rtp/modules/main/command/RtpWorldCommand;", "Lur/kryz/rtp/command/paper/SubCommand;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "Lur/kryz/rtp/command/paper/UsageDisplayable;", "module", "Lur/kryz/rtp/modules/main/RandomTeleportModule;", "(Lur/kryz/rtp/modules/main/RandomTeleportModule;)V", "build", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "builder", "execute", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "usage", "NextRTP"})
public final class RtpWorldCommand
implements SubCommand<CommandSourceStack>,
UsageDisplayable {
    @NotNull
    private final RandomTeleportModule module;

    public RtpWorldCommand(@NotNull RandomTeleportModule module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build(@NotNull LiteralArgumentBuilder<CommandSourceStack> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        ArgumentBuilder argumentBuilder = builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"world").requires(RtpWorldCommand::build$lambda$0)).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)Arguments.INSTANCE.bukkitWorld())).executes(arg_0 -> RtpWorldCommand.build$lambda$1(this, arg_0)))).executes(arg_0 -> RtpWorldCommand.build$lambda$2(this, arg_0)));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @Override
    public int execute(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = context.getArgument("world", Optional.class);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.Optional<org.bukkit.World>");
        Optional world = (Optional)object;
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            CommandSyntaxException commandSyntaxException = ExceptionConstants.INSTANCE.getBAD_SOURCE().create();
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "create(...)");
            throw (Throwable)commandSyntaxException;
        }
        Player sender = player;
        World w = world.orElse(null);
        if (w == null) {
            PlayerUtil.sendParsed((CommandSender)sender, "messages.command.invalid_world", new TagResolver.Single[0]);
            return 1;
        }
        RtpCommand.Util.rtp(this.module, sender, w);
        return 1;
    }

    @Override
    public int usage(@NotNull CommandContext<CommandSourceStack> context) {
        Intrinsics.checkNotNullParameter(context, "context");
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Intrinsics.checkNotNull(sender);
        PlayerUtil.sendParsed(sender, "messages.usage.rtp_world", new TagResolver.Single[0]);
        return 1;
    }

    private static final boolean build$lambda$0(CommandSourceStack source) {
        CommandSourceStack commandSourceStack = source;
        Intrinsics.checkNotNull(commandSourceStack);
        String[] stringArray = new String[]{"nextrtp.command.world"};
        return Permissions.anyPermissions(commandSourceStack, stringArray);
    }

    private static final int build$lambda$1(RtpWorldCommand this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(context, "context");
        return this$0.execute((CommandContext<CommandSourceStack>)context);
    }

    private static final int build$lambda$2(RtpWorldCommand this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(context, "context");
        return this$0.usage((CommandContext<CommandSourceStack>)context);
    }
}

