/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.main.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.animation.ParticleProvider;
import ur.kryz.rtp.api.events.RandomTeleportEndEvent;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.file.YamlSection;
import ur.kryz.rtp.manager.TitleAnimationManager;
import ur.kryz.rtp.modules.main.RandomTeleportModule;
import ur.kryz.rtp.modules.main.RandomTeleportProcessor;
import ur.kryz.rtp.modules.main.task.RtpContainer;
import ur.kryz.rtp.modules.main.task.Scheduler;
import ur.kryz.rtp.modules.main.task.TeleportScheduler;
import ur.kryz.rtp.parser.LegacyParser;
import ur.kryz.rtp.utils.DateFormatUtil;
import ur.kryz.rtp.utils.PlayerUtil;
import ur.kryz.rtp.utils.RTPUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0014J\u0010\u0010'\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010\u0014J\u0006\u0010(\u001a\u00020%J\u001e\u0010\u0012\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020%H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\"\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\b\u00a8\u00060"}, d2={"Lur/kryz/rtp/modules/main/task/TeleportScheduler;", "Lur/kryz/rtp/modules/main/task/Scheduler;", "module", "Lur/kryz/rtp/modules/main/RandomTeleportModule;", "(Lur/kryz/rtp/modules/main/RandomTeleportModule;)V", "actionbar", "", "getActionbar", "()Ljava/lang/String;", "delaySound", "Lnet/kyori/adventure/sound/Sound;", "isSendSound", "", "()Z", "isSendSuccessSound", "isShowSuccessMessage", "isShowSuccessTitles", "isShowTitles", "queue", "", "Lorg/bukkit/entity/Player;", "Lur/kryz/rtp/modules/main/task/RtpContainer;", "getQueue", "()Ljava/util/Map;", "sendDelaySound", "showDelayMessages", "subtitle", "getSubtitle", "<set-?>", "successSound", "getSuccessSound", "()Lnet/kyori/adventure/sound/Sound;", "teleportMoney", "", "title", "getTitle", "cancel", "", "player", "isQueued", "loadSounds", "time", "", "world", "Lorg/bukkit/World;", "teleportNow", "tick", "Companion", "NextRTP"})
public final class TeleportScheduler
implements Scheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RandomTeleportModule module;
    private final boolean showDelayMessages;
    private final boolean isShowSuccessMessage;
    private final boolean isShowTitles;
    @NotNull
    private final String title;
    private final boolean isShowSuccessTitles;
    @NotNull
    private final String subtitle;
    @NotNull
    private final String actionbar;
    @NotNull
    private final Number teleportMoney;
    @Nullable
    private net.kyori.adventure.sound.Sound delaySound;
    @Nullable
    private net.kyori.adventure.sound.Sound successSound;
    private final boolean isSendSound;
    private final boolean sendDelaySound;
    private final boolean isSendSuccessSound;
    @NotNull
    private static final Map<Player, RtpContainer> QUEUE = new HashMap();

    public TeleportScheduler(@NotNull RandomTeleportModule module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
        YamlFile file = this.module.getConfig();
        this.showDelayMessages = file.get("titles.delay.message", false);
        this.isShowSuccessMessage = file.get("titles.success.message", true);
        this.isShowTitles = file.get("titles.enabled", false);
        this.teleportMoney = file.get("teleport.money", 100.0);
        this.isShowSuccessTitles = file.get("titles.success.ui.enabled", false);
        this.title = LegacyParser.parse(file.get("titles.success.ui.title", ""));
        this.subtitle = LegacyParser.parse(file.get("titles.success.ui.subtitle", ""));
        this.actionbar = LegacyParser.parse(file.get("titles.success.ui.actionbar", ""));
        this.isSendSound = file.get("sounds.enabled", false);
        this.sendDelaySound = file.get("sounds.delay.enabled", false);
        this.isSendSuccessSound = file.get("sounds.success.enabled", false);
        this.loadSounds();
    }

    public final boolean isShowSuccessMessage() {
        return this.isShowSuccessMessage;
    }

    public final boolean isShowTitles() {
        return this.isShowTitles;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final boolean isShowSuccessTitles() {
        return this.isShowSuccessTitles;
    }

    @NotNull
    public final String getSubtitle() {
        return this.subtitle;
    }

    @NotNull
    public final String getActionbar() {
        return this.actionbar;
    }

    @Nullable
    public final net.kyori.adventure.sound.Sound getSuccessSound() {
        return this.successSound;
    }

    public final boolean isSendSound() {
        return this.isSendSound;
    }

    public final boolean isSendSuccessSound() {
        return this.isSendSuccessSound;
    }

    @Override
    public void tick() {
        Iterator<Map.Entry<Player, RtpContainer>> iterator2 = QUEUE.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Player, RtpContainer> entry = iterator2.next();
            Player player = entry.getKey();
            RtpContainer container = entry.getValue();
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (!container.isEquals(location)) {
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.cancelled", new TagResolver.Single[0]);
                TitleAnimationManager.stop(player);
                this.module.getParticleAnimationManager().stopFor(player);
                iterator2.remove();
                continue;
            }
            if (container.getTeleporting()) continue;
            int tickCounter = container.getTickCounter();
            int maxTicks = container.getTime() * 20;
            if (tickCounter % 20 == 0 && tickCounter < maxTicks) {
                container.setSeconds((int)Math.max(0.0, (double)(container.getTime() - tickCounter / 20)));
                NextRTPPlugin.Companion.runTask(() -> TeleportScheduler.tick$lambda$0(this, player, container));
            }
            if (tickCounter >= maxTicks) {
                container.setTeleporting(true);
                this.cancel(player);
                this.teleportNow(player, container.getWorld());
                continue;
            }
            container.setTickCounter(tickCounter + 5);
        }
    }

    private final void teleportNow(Player player, World world) {
        RandomTeleportEndEvent event = new RandomTeleportEndEvent(player);
        PluginManager pluginManager = Bukkit.getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        PluginManager pm = pluginManager;
        RandomTeleportProcessor.random(player, world).thenAccept(arg_0 -> TeleportScheduler.teleportNow$lambda$1(new Function1<Boolean, Unit>(event, this, player, pm){
            final /* synthetic */ RandomTeleportEndEvent $event;
            final /* synthetic */ TeleportScheduler this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ PluginManager $pm;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                this.$player = $player;
                this.$pm = $pm;
                super(1);
            }

            public final void invoke(boolean success) {
                NextRTPPlugin.Companion.runTask(() -> teleportNow.1.invoke$lambda$0(success, this.$event, this.this$0, this.$player, this.$pm));
            }

            private static final void invoke$lambda$0(boolean $success, RandomTeleportEndEvent $event, TeleportScheduler this$0, Player $player, PluginManager $pm) {
                Intrinsics.checkNotNullParameter((Object)((Object)$event), "$event");
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNullParameter($pm, "$pm");
                if ($success) {
                    $event.setFailed(false);
                    RTPUtils.processSuccess(TeleportScheduler.access$getModule$p(this$0).getCooldownManager(), this$0, $player, TeleportScheduler.access$getTeleportMoney$p(this$0).doubleValue());
                    $pm.callEvent((Event)$event);
                } else {
                    $event.setFailed(true);
                    PlayerUtil.sendParsed((CommandSender)$player, "messages.teleport.failed", new TagResolver.Single[0]);
                    $pm.callEvent((Event)$event);
                }
            }
        }, arg_0));
    }

    public final void queue(@NotNull Player player, int time, @NotNull World world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.start", new TagResolver.Single[0]);
        try {
            Object t = this.module.getConfig().get("teleport.particle_animation");
            Intrinsics.checkNotNull(t);
            Object object = (String)t;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            String animName = string;
            this.module.getParticleAnimationManager().startFor(player, ParticleProvider.get(animName));
            object = QUEUE;
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            RtpContainer rtpContainer = new RtpContainer(time, location, world, false, 0);
            object.put(player, rtpContainer);
            TitleAnimationManager.start(player, this.module.getConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final boolean isQueued(@Nullable Player player) {
        return QUEUE.containsKey(player);
    }

    public final void cancel(@Nullable Player player) {
        RtpContainer container = (RtpContainer)TypeIntrinsics.asMutableMap(QUEUE).remove(player);
        if (container != null) {
            Player player2 = player;
            Intrinsics.checkNotNull(player2);
            TitleAnimationManager.stop(player2);
            this.module.getParticleAnimationManager().stopFor(player);
        }
    }

    @NotNull
    public final Map<Player, RtpContainer> getQueue() {
        return QUEUE;
    }

    public final void loadSounds() {
        YamlSection success;
        YamlSection yamlSection = this.module.getConfig().getSection("sounds");
        if (yamlSection == null) {
            throw new NoSuchElementException("Sounds key not found, please add it into rtp.yml");
        }
        YamlSection section = yamlSection;
        YamlSection delay = section.getSection("delay");
        if (delay != null) {
            Number v1 = delay.get("volume", Float.valueOf(1.0f));
            Number p1 = delay.get("pitch", Float.valueOf(1.0f));
            String sound1 = delay.get("sound", "BLOCK_NOTE_BLOCK_HAT");
            Sound s1 = Sound.valueOf((String)sound1);
            this.delaySound = net.kyori.adventure.sound.Sound.sound((Key)s1.key(), (Sound.Source)Sound.Source.MASTER, (float)v1.floatValue(), (float)p1.floatValue());
        }
        if ((success = section.getSection("success")) != null) {
            Number v2 = success.get("volume", Float.valueOf(1.0f));
            Number p2 = success.get("pitch", Float.valueOf(1.0f));
            String sound2 = success.get("sound", "ENTITY_ENDERMAN_TELEPORT");
            Sound s2 = Sound.valueOf((String)sound2);
            this.successSound = net.kyori.adventure.sound.Sound.sound((Key)s2.key(), (Sound.Source)Sound.Source.MASTER, (float)v2.floatValue(), (float)p2.floatValue());
        }
    }

    private static final void tick$lambda$0(TeleportScheduler this$0, Player $player, RtpContainer $container) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($container, "$container");
        if (this$0.sendDelaySound) {
            net.kyori.adventure.sound.Sound sound = this$0.delaySound;
            Intrinsics.checkNotNull(sound);
            $player.playSound(sound);
        }
        if (this$0.showDelayMessages) {
            CommandSender commandSender = (CommandSender)$player;
            TagResolver.Single[] singleArray = new TagResolver.Single[1];
            Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"time", (String)DateFormatUtil.formatTime($container.getSeconds())), "unparsed(...)");
            PlayerUtil.sendParsed(commandSender, "messages.teleport.delay", singleArray);
        }
    }

    private static final void teleportNow$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ RandomTeleportModule access$getModule$p(TeleportScheduler $this) {
        return $this.module;
    }

    public static final /* synthetic */ Number access$getTeleportMoney$p(TeleportScheduler $this) {
        return $this.teleportMoney;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lur/kryz/rtp/modules/main/task/TeleportScheduler$Companion;", "", "()V", "QUEUE", "", "Lorg/bukkit/entity/Player;", "Lur/kryz/rtp/modules/main/task/RtpContainer;", "NextRTP"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

