/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.sign.listener;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.api.events.SignTeleportStartEvent;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.modules.main.RandomTeleportModule;
import ur.kryz.rtp.modules.main.command.RtpCommand;
import ur.kryz.rtp.modules.sign.SignModule;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lur/kryz/rtp/modules/sign/listener/SignListener;", "Lorg/bukkit/event/Listener;", "module", "Lur/kryz/rtp/modules/sign/SignModule;", "(Lur/kryz/rtp/modules/sign/SignModule;)V", "namespacedKey", "Lorg/bukkit/NamespacedKey;", "plain", "Lnet/kyori/adventure/text/serializer/plain/PlainTextComponentSerializer;", "Lorg/jetbrains/annotations/NotNull;", "isRtpSign", "", "lines", "", "Lnet/kyori/adventure/text/Component;", "expectedLine", "", "ignoreCase", "onBlockInteract", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onSign", "Lorg/bukkit/event/block/SignChangeEvent;", "NextRTP"})
public final class SignListener
implements Listener {
    @NotNull
    private final SignModule module;
    @NotNull
    private final NamespacedKey namespacedKey;
    @NotNull
    private final PlainTextComponentSerializer plain;

    public SignListener(@NotNull SignModule module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
        this.namespacedKey = new NamespacedKey((Plugin)this.module.getPlugin(), "rtp_sign");
        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
        Intrinsics.checkNotNullExpressionValue(plainTextComponentSerializer, "plainText(...)");
        this.plain = plainTextComponentSerializer;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onSign(@NotNull SignChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        List list = event.lines();
        Intrinsics.checkNotNullExpressionValue(list, "lines(...)");
        List lines = list;
        YamlFile config = this.module.getSignFile();
        if (!player2.hasPermission("urrtp.sign")) {
            return;
        }
        YamlFile yamlFile = config;
        Intrinsics.checkNotNull(yamlFile);
        if (!this.isRtpSign(lines, (String)yamlFile.get("sign.line"), config.get("sign.ignore-case", true))) {
            return;
        }
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        BlockState blockState = block2.getState();
        Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.Sign");
        Sign sign = (Sign)blockState;
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location l = location;
        PersistentDataContainer persistentDataContainer = sign.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        Boolean is = (Boolean)container.get(this.namespacedKey, PersistentDataType.BOOLEAN);
        if (container.has(this.namespacedKey)) {
            return;
        }
        if (Intrinsics.areEqual(is, false) || is != null) {
            return;
        }
        container.set(this.namespacedKey, PersistentDataType.BOOLEAN, (Object)true);
        if (!sign.update()) {
            throw new UnsupportedOperationException("The update of the sign not success.");
        }
        CommandSender commandSender = (CommandSender)player2;
        TagResolver.Single[] singleArray = new TagResolver.Single[3];
        Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"x", (String)String.valueOf(l.getX())), "unparsed(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"y", (String)String.valueOf(l.getY())), "unparsed(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.unparsed((String)"z", (String)String.valueOf(l.getZ())), "unparsed(...)");
        PlayerUtil.sendParsed(commandSender, "messages.sign.success", singleArray);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onBlockInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        BlockState blockState = block2.getState();
        Sign sign = blockState instanceof Sign ? (Sign)blockState : null;
        if (sign == null) {
            return;
        }
        Sign state = sign;
        PersistentDataContainer persistentDataContainer = state.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        Boolean bl = (Boolean)container.get(this.namespacedKey, PersistentDataType.BOOLEAN);
        if (bl == null) {
            return;
        }
        boolean is = bl;
        if (!is) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        SignTeleportStartEvent mE = new SignTeleportStartEvent(player2, state);
        Bukkit.getPluginManager().callEvent((Event)mE);
        if (mE.isCancelled()) {
            return;
        }
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        RtpCommand.Util.rtp(this.module.getPlugin().getModuleManager().getModule(RandomTeleportModule.class), player2, world);
    }

    private final boolean isRtpSign(List<? extends Component> lines, String expectedLine, boolean ignoreCase) {
        for (Component component : lines) {
            String text;
            Intrinsics.checkNotNullExpressionValue(this.plain.serialize(component), "serialize(...)");
            if (!(ignoreCase ? StringsKt.equals(text, expectedLine, true) : Intrinsics.areEqual(text, expectedLine))) continue;
            return true;
        }
        return false;
    }
}

