/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.animation.ParticleManager;
import ur.kryz.rtp.core.RandomTeleportProcessor;
import ur.kryz.rtp.core.command.RtpCommand;
import ur.kryz.rtp.core.command.RtpSudoCommand;
import ur.kryz.rtp.core.command.RtpWorldCommand;
import ur.kryz.rtp.core.command.paper.NextRootCommand;
import ur.kryz.rtp.core.config.RTPConfiguration;
import ur.kryz.rtp.core.manager.CooldownManager;
import ur.kryz.rtp.core.task.CyclicTaskScheduler;
import ur.kryz.rtp.core.task.RtpTask;
import ur.kryz.rtp.core.task.TeleportScheduler;
import ur.kryz.rtp.file.FileManager;
import ur.kryz.rtp.libs.YamlDocument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lur/kryz/rtp/core/Core;", "", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "<init>", "(Lur/kryz/rtp/NextRTPPlugin;)V", "yaml", "Lur/kryz/rtp/libs/YamlDocument;", "_task", "Lur/kryz/rtp/core/task/RtpTask;", "_particle", "Lur/kryz/rtp/animation/ParticleManager;", "_cooldown", "Lur/kryz/rtp/core/manager/CooldownManager;", "onEnable", "", "reload", "config", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "task", "getTask", "()Lur/kryz/rtp/core/task/RtpTask;", "particleAnimationManager", "getParticleAnimationManager", "()Lur/kryz/rtp/animation/ParticleManager;", "cooldownManager", "getCooldownManager", "()Lur/kryz/rtp/core/manager/CooldownManager;", "NextRTP"})
public final class Core {
    @NotNull
    private final NextRTPPlugin plugin;
    private YamlDocument yaml;
    private RtpTask _task;
    private ParticleManager _particle;
    @Nullable
    private CooldownManager _cooldown;

    public Core(@NotNull NextRTPPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.onEnable();
    }

    private final void onEnable() {
        this.yaml = FileManager.load("rtp.yml", this.plugin);
        RTPConfiguration.INSTANCE.reload();
        NextRootCommand.add(new RtpCommand(this));
        NextRootCommand.add(new RtpWorldCommand(this));
        NextRootCommand.add(new RtpSudoCommand(this));
        YamlDocument yamlDocument = this.yaml;
        if (yamlDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlDocument = null;
        }
        RandomTeleportProcessor.INSTANCE.set(yamlDocument);
        this._task = new RtpTask(this);
        RtpTask rtpTask = this._task;
        if (rtpTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask = null;
        }
        CyclicTaskScheduler.Companion.register(rtpTask, 250L);
        YamlDocument yamlDocument2 = this.yaml;
        if (yamlDocument2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlDocument2 = null;
        }
        Integer n = yamlDocument2.getInt("teleport.cooldown", (Integer)30);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        this._cooldown = new CooldownManager(((Number)n).intValue());
        this._particle = new ParticleManager(this.plugin);
    }

    public final void reload() {
        YamlDocument yamlDocument = this.yaml;
        if (yamlDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlDocument = null;
        }
        yamlDocument.reload();
        RtpTask rtpTask = this._task;
        if (rtpTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask = null;
        }
        rtpTask.set(new TeleportScheduler(this));
        YamlDocument yamlDocument2 = this.yaml;
        if (yamlDocument2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlDocument2 = null;
        }
        Integer n = yamlDocument2.getInt("teleport.cooldown", (Integer)30);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        this._cooldown = new CooldownManager(((Number)n).intValue());
        RandomTeleportProcessor.INSTANCE.reload();
        RTPConfiguration.INSTANCE.reload();
    }

    @NotNull
    public final YamlDocument getConfig() {
        YamlDocument yamlDocument = this.yaml;
        if (yamlDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException("yaml");
            yamlDocument = null;
        }
        return yamlDocument;
    }

    @NotNull
    public final RtpTask getTask() {
        RtpTask rtpTask = this._task;
        if (rtpTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_task");
            rtpTask = null;
        }
        return rtpTask;
    }

    @NotNull
    public final ParticleManager getParticleAnimationManager() {
        ParticleManager particleManager = this._particle;
        if (particleManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_particle");
            particleManager = null;
        }
        return particleManager;
    }

    @NotNull
    public final CooldownManager getCooldownManager() {
        CooldownManager cooldownManager = this._cooldown;
        if (cooldownManager == null) {
            throw new IllegalStateException("CooldownManager is null.".toString());
        }
        return cooldownManager;
    }
}

