/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.core.adapter.BiomeAdapter;
import ur.kryz.rtp.core.task.processor.GeoLocation;
import ur.kryz.rtp.core.task.processor.RandomPoint;
import ur.kryz.rtp.core.task.processor.TeleportRandom;
import ur.kryz.rtp.libs.YamlDocument;
import ur.kryz.rtp.libs.block.implementation.Section;
import ur.kryz.rtp.utils.Debug;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JH\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011*\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cJ\u0018\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010'\u001a\u00020#H\u0002J(\u0010(\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010,\u001a\u00020-2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010.\u001a\u00020-R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lur/kryz/rtp/core/RandomTeleportProcessor;", "", "<init>", "()V", "playerRandomTeleports", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "random", "Ljava/util/Random;", "file", "Lur/kryz/rtp/libs/YamlDocument;", "blacklistBlocks", "", "Lorg/bukkit/Material;", "blacklistBiomes", "", "Ljava/util/concurrent/CompletableFuture;", "Lorg/bukkit/entity/Player;", "world", "Lorg/bukkit/World;", "resolveTeleportArea", "Lur/kryz/rtp/core/RandomTeleportProcessor$TeleportArea;", "section", "Lur/kryz/rtp/libs/block/implementation/Section;", "teleportWithInfo", "player", "maxY", "", "baseX", "", "baseZ", "radius", "attempts", "findValidTeleportLocation", "Lorg/bukkit/Location;", "locations", "", "teleport", "location", "getSafeY", "x", "z", "getSafeYAsync", "set", "", "reload", "TeleportArea", "NextRTP"})
@SourceDebugExtension(value={"SMAP\nRandomTeleportProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomTeleportProcessor.kt\nur/kryz/rtp/core/RandomTeleportProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n295#2,2:166\n*S KotlinDebug\n*F\n+ 1 RandomTeleportProcessor.kt\nur/kryz/rtp/core/RandomTeleportProcessor\n*L\n83#1:166,2\n*E\n"})
public final class RandomTeleportProcessor {
    @NotNull
    public static final RandomTeleportProcessor INSTANCE = new RandomTeleportProcessor();
    @NotNull
    private static final ConcurrentHashMap<UUID, Boolean> playerRandomTeleports = new ConcurrentHashMap();
    @NotNull
    private static final Random random = new Random();
    private static YamlDocument file;
    @NotNull
    private static final Set<Material> blacklistBlocks;
    @NotNull
    private static final Set<String> blacklistBiomes;

    private RandomTeleportProcessor() {
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<Boolean> random(@NotNull Player $this$random, @NotNull World world) {
        Section section;
        Section section2;
        Intrinsics.checkNotNullParameter($this$random, "<this>");
        Intrinsics.checkNotNullParameter(world, "world");
        Debug.INSTANCE.log("--------------------------------------------------", new Object[0]);
        Debug.INSTANCE.log("Executing RandomTeleportProcessor#random for " + $this$random, new Object[0]);
        ((Map)playerRandomTeleports).put($this$random.getUniqueId(), true);
        YamlDocument yamlDocument = file;
        if (yamlDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
            yamlDocument = null;
        }
        Integer n = yamlDocument.getInt("teleport.attempts", (Integer)10);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        int attempts = ((Number)n).intValue();
        YamlDocument yamlDocument2 = file;
        if (yamlDocument2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
            yamlDocument2 = null;
        }
        if ((section2 = (section = yamlDocument2.getSection("teleport.area.per_world." + world.getName()))) == null) {
            YamlDocument yamlDocument3 = file;
            if (yamlDocument3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("file");
                yamlDocument3 = null;
            }
            if ((section2 = yamlDocument3.getSection("teleport.area")) == null) {
                throw new IllegalStateException("teleport.area key not found in rtp.yml".toString());
            }
        }
        TeleportArea teleportArea = INSTANCE.resolveTeleportArea(section2, world);
        double centerX = teleportArea.component1();
        double centerZ = teleportArea.component2();
        int radius = teleportArea.component3();
        int maxY = teleportArea.component4();
        return INSTANCE.teleportWithInfo($this$random, $this$random, world, maxY, centerX, centerZ, radius, attempts);
    }

    private final TeleportArea resolveTeleportArea(Section section, World world) {
        Pair<Double, Double> pair;
        Boolean useWorldBorder = section.getBoolean("use_world_border", (Boolean)false);
        Integer n = section.getInt("max_y", (Integer)100);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        int maxY = ((Number)n).intValue();
        Integer n2 = section.getInt("radius", (Integer)100);
        Intrinsics.checkNotNullExpressionValue(n2, "getInt(...)");
        Number radius = n2;
        if (useWorldBorder.booleanValue()) {
            Location location = world.getWorldBorder().getCenter();
            Intrinsics.checkNotNullExpressionValue(location, "getCenter(...)");
            Location center = location;
            pair = TuplesKt.to(center.getX(), center.getZ());
        } else {
            pair = TuplesKt.to(section.getNumber("center_x", (Number)0).doubleValue(), section.getNumber("center_z", (Number)0).doubleValue());
        }
        Pair<Double, Double> pair2 = pair;
        double centerX = ((Number)pair2.component1()).doubleValue();
        double centerZ = ((Number)pair2.component2()).doubleValue();
        return new TeleportArea(centerX, centerZ, radius.intValue(), maxY);
    }

    @NotNull
    public final CompletableFuture<Boolean> teleportWithInfo(@NotNull Player $this$teleportWithInfo, @NotNull Player player, @NotNull World world, int maxY, double baseX, double baseZ, int radius, int attempts) {
        Intrinsics.checkNotNullParameter($this$teleportWithInfo, "<this>");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Debug.INSTANCE.log("Teleporting with info for " + player + ":", new Object[0]);
        Debug.INSTANCE.log("World: " + world, new Object[0]);
        Debug.INSTANCE.log("Max Y: " + maxY, new Object[0]);
        Debug.INSTANCE.log("Center X: " + baseX, new Object[0]);
        Debug.INSTANCE.log("Center Z: " + baseZ, new Object[0]);
        Debug.INSTANCE.log("Radius: " + radius, new Object[0]);
        Debug.INSTANCE.log("Attempts: " + attempts, new Object[0]);
        return TeleportRandom.INSTANCE.teleport(world, RandomPoint.Algorithm.SQUARE, maxY, radius, (int)baseX, (int)baseZ, (Entity)player, attempts);
    }

    private final Location findValidTeleportLocation(List<? extends Location> locations) {
        Object v2;
        block2: {
            Iterable $this$firstOrNull$iv = locations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Material belowMaterial;
                Material aboveMaterial;
                Material material;
                Location loc = (Location)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(loc.getBlock().getType(), "getType(...)");
                BiomeAdapter biomeAdapter = BiomeAdapter.Companion.getInstance();
                Biome biome = loc.getBlock().getBiome();
                Intrinsics.checkNotNullExpressionValue(biome, "getBiome(...)");
                NamespacedKey key = (NamespacedKey)biomeAdapter.getKey(biome);
                String stringKey = "";
                if (key != null) {
                    stringKey = key.getKey();
                }
                int x = loc.getBlockX();
                int y = loc.getBlockY();
                int z = loc.getBlockZ();
                World world = loc.getWorld();
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y - 1, z).getType(), "getType(...)");
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y + 1, z).getType(), "getType(...)");
                boolean isAirSpace = material == Material.AIR && aboveMaterial == Material.AIR;
                boolean isGroundSafe = belowMaterial.isSolid() && !blacklistBlocks.contains(belowMaterial);
                boolean isBiomeAllowed = !blacklistBiomes.contains(stringKey);
                if (!(isAirSpace && isGroundSafe && isBiomeAllowed && !blacklistBlocks.contains(material))) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final CompletableFuture<Boolean> teleport(Player player, Location location) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN).whenComplete((arg_0, arg_1) -> RandomTeleportProcessor.teleport$lambda$2((arg_0, arg_1) -> RandomTeleportProcessor.teleport$lambda$1(future, player, arg_0, arg_1), arg_0, arg_1));
        return future;
    }

    private final double getSafeY(World world, int x, int z, int maxY) {
        int y;
        int minY = world.getMinHeight();
        if (minY <= (y = maxY)) {
            while (true) {
                Block loc;
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y, z), "getBlockAt(...)");
                if (loc.getType() == Material.WATER) {
                    return y;
                }
                if (loc.getType().isSolid()) {
                    return y + 1;
                }
                if (y == minY) break;
                --y;
            }
        }
        return world.getHighestBlockYAt(x, z) + 1;
    }

    private final CompletableFuture<Double> getSafeYAsync(World world, int x, int z, int maxY) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        CompletionStage completionStage = world.getChunkAtAsync(chunkX, chunkZ).thenApply(arg_0 -> RandomTeleportProcessor.getSafeYAsync$lambda$4(arg_0 -> RandomTeleportProcessor.getSafeYAsync$lambda$3(world, maxY, x, z, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    public final void set(@NotNull YamlDocument file) {
        Intrinsics.checkNotNullParameter(file, "file");
        RandomTeleportProcessor.file = file;
        GeoLocation.INSTANCE.reload();
    }

    public final void reload() {
        GeoLocation.INSTANCE.reload();
    }

    private static final Unit teleport$lambda$1(CompletableFuture $future, Player $player, Boolean success, Throwable throwable) {
        Intrinsics.checkNotNullParameter($future, "$future");
        Intrinsics.checkNotNullParameter($player, "$player");
        if (throwable != null) {
            v0 = $future.completeExceptionally(throwable);
        } else {
            if (success.booleanValue()) {
                playerRandomTeleports.remove($player.getUniqueId());
            }
            v0 = $future.complete(success);
        }
        return Unit.INSTANCE;
    }

    private static final void teleport$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Double getSafeYAsync$lambda$3(World $world, int $maxY, int $x, int $z, Chunk chunk) {
        Intrinsics.checkNotNullParameter($world, "$world");
        int minY = $world.getMinHeight();
        int y = $maxY;
        if (minY <= y) {
            while (true) {
                Block block;
                Intrinsics.checkNotNullExpressionValue($world.getBlockAt($x, y, $z), "getBlockAt(...)");
                if (block.getType() == Material.WATER) {
                    return y;
                }
                if (block.getType().isSolid()) {
                    return y + 1;
                }
                if (y == minY) break;
                --y;
            }
        }
        return $world.getHighestBlockYAt($x, $z) + 1;
    }

    private static final Double getSafeYAsync$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Double)$tmp0.invoke(p0);
    }

    static {
        blacklistBlocks = new HashSet();
        blacklistBiomes = new HashSet();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lur/kryz/rtp/core/RandomTeleportProcessor$TeleportArea;", "", "centerX", "", "centerZ", "radius", "", "maxY", "<init>", "(DDII)V", "getCenterX", "()D", "getCenterZ", "getRadius", "()I", "getMaxY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "NextRTP"})
    private static final class TeleportArea {
        private final double centerX;
        private final double centerZ;
        private final int radius;
        private final int maxY;

        public TeleportArea(double centerX, double centerZ, int radius, int maxY) {
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.radius = radius;
            this.maxY = maxY;
        }

        public final double getCenterX() {
            return this.centerX;
        }

        public final double getCenterZ() {
            return this.centerZ;
        }

        public final int getRadius() {
            return this.radius;
        }

        public final int getMaxY() {
            return this.maxY;
        }

        public final double component1() {
            return this.centerX;
        }

        public final double component2() {
            return this.centerZ;
        }

        public final int component3() {
            return this.radius;
        }

        public final int component4() {
            return this.maxY;
        }

        @NotNull
        public final TeleportArea copy(double centerX, double centerZ, int radius, int maxY) {
            return new TeleportArea(centerX, centerZ, radius, maxY);
        }

        public static /* synthetic */ TeleportArea copy$default(TeleportArea teleportArea, double d, double d2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                d = teleportArea.centerX;
            }
            if ((n3 & 2) != 0) {
                d2 = teleportArea.centerZ;
            }
            if ((n3 & 4) != 0) {
                n = teleportArea.radius;
            }
            if ((n3 & 8) != 0) {
                n2 = teleportArea.maxY;
            }
            return teleportArea.copy(d, d2, n, n2);
        }

        @NotNull
        public String toString() {
            return "TeleportArea(centerX=" + this.centerX + ", centerZ=" + this.centerZ + ", radius=" + this.radius + ", maxY=" + this.maxY + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.centerX);
            result = result * 31 + Double.hashCode(this.centerZ);
            result = result * 31 + Integer.hashCode(this.radius);
            result = result * 31 + Integer.hashCode(this.maxY);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TeleportArea)) {
                return false;
            }
            TeleportArea teleportArea = (TeleportArea)other;
            if (Double.compare(this.centerX, teleportArea.centerX) != 0) {
                return false;
            }
            if (Double.compare(this.centerZ, teleportArea.centerZ) != 0) {
                return false;
            }
            if (this.radius != teleportArea.radius) {
                return false;
            }
            return this.maxY == teleportArea.maxY;
        }
    }
}

