/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.core.Core;
import ur.kryz.rtp.core.brigadier.ExceptionConstants;
import ur.kryz.rtp.core.command.paper.SubCommand;
import ur.kryz.rtp.core.manager.CooldownManager;
import ur.kryz.rtp.core.task.RtpTask;
import ur.kryz.rtp.utils.DateFormatUtil;
import ur.kryz.rtp.utils.Permissions;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lur/kryz/rtp/core/command/RtpCommand;", "Lur/kryz/rtp/core/command/paper/SubCommand;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "module", "Lur/kryz/rtp/core/Core;", "<init>", "(Lur/kryz/rtp/core/Core;)V", "build", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "builder", "execute", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "Util", "NextRTP"})
public final class RtpCommand
implements SubCommand<CommandSourceStack> {
    @NotNull
    private final Core module;

    public RtpCommand(@NotNull Core module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build(@NotNull LiteralArgumentBuilder<CommandSourceStack> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)builder.requires(RtpCommand::build$lambda$0)).executes(arg_0 -> RtpCommand.build$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "executes(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @Override
    public int execute(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Intrinsics.checkNotNullParameter(context, "context");
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            throw ExceptionConstants.INSTANCE.getBAD_SOURCE().create();
        }
        Player sender = player;
        World world = sender.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        Util.rtp(this.module, sender, world);
        return 1;
    }

    private static final boolean build$lambda$0(CommandSourceStack source) {
        Intrinsics.checkNotNullParameter(source, "source");
        String[] stringArray = new String[]{"nextrtp.command.rtp"};
        boolean perm = Permissions.anyPermissions(source, stringArray);
        return perm;
    }

    private static final int build$lambda$1(RtpCommand this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(context, "context");
        return this$0.execute((CommandContext<CommandSourceStack>)context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lur/kryz/rtp/core/command/RtpCommand$Util;", "", "<init>", "()V", "rtp", "", "module", "Lur/kryz/rtp/core/Core;", "player", "Lorg/bukkit/entity/Player;", "world", "Lorg/bukkit/World;", "NextRTP"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @JvmStatic
        public static final void rtp(@NotNull Core module, @NotNull Player player, @NotNull World world) {
            Intrinsics.checkNotNullParameter(module, "module");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(world, "world");
            if (module.getTask().isQueued(player)) {
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.progress", new TagResolver.Single[0]);
                return;
            }
            Number number = module.getConfig().getNumber("teleport.money", (Number)100.0);
            Intrinsics.checkNotNullExpressionValue(number, "getNumber(...)");
            Number money = number;
            double doubleMoney = money.doubleValue();
            String permString = "nextrtp.world." + world.getName();
            if (!player.hasPermission(permString) && !player.hasPermission("nextrtp.world.*")) {
                TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"world_name", (String)world.getName())};
                PlayerUtil.sendParsed((CommandSender)player, "messages.world.not_allowed", singleArray);
                return;
            }
            if (!PlayerUtil.hasMoney(player, doubleMoney) && !player.hasPermission("nextrtp.bypass.money")) {
                TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"money", (String)String.valueOf(doubleMoney))};
                PlayerUtil.sendParsed((CommandSender)player, "messages.currency.no_money", singleArray);
                return;
            }
            CooldownManager cooldownManager = module.getCooldownManager();
            if (cooldownManager.isOnCooldown(player)) {
                long left = cooldownManager.getTimeLeft(player) / (long)1000;
                TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"time", (String)DateFormatUtil.formatTime((int)left))};
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.cooldown", singleArray);
                return;
            }
            RtpTask rtpTask = module.getTask();
            Integer n = module.getConfig().getInt("teleport.delay");
            Intrinsics.checkNotNull(n);
            rtpTask.queue(player, n, world);
        }
    }
}

