/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.core.Core;
import ur.kryz.rtp.core.brigadier.Arguments;
import ur.kryz.rtp.core.brigadier.ExceptionConstants;
import ur.kryz.rtp.core.command.RtpCommand;
import ur.kryz.rtp.core.command.paper.DisplayableUsage;
import ur.kryz.rtp.core.command.paper.SubCommand;
import ur.kryz.rtp.utils.Permissions;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0010B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lur/kryz/rtp/core/command/RtpWorldCommand;", "Lur/kryz/rtp/core/command/paper/SubCommand;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "Lur/kryz/rtp/core/command/paper/DisplayableUsage;", "module", "Lur/kryz/rtp/core/Core;", "<init>", "(Lur/kryz/rtp/core/Core;)V", "build", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "builder", "execute", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "usage", "RtpWorldSudoCommand", "NextRTP"})
public final class RtpWorldCommand
implements SubCommand<CommandSourceStack>,
DisplayableUsage {
    @NotNull
    private final Core module;

    public RtpWorldCommand(@NotNull Core module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build(@NotNull LiteralArgumentBuilder<CommandSourceStack> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        RtpWorldSudoCommand command2 = new RtpWorldSudoCommand(this.module);
        RequiredArgumentBuilder b = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)((ArgumentType)Arguments.INSTANCE.bukkitWorld())).executes(arg_0 -> RtpWorldCommand.build$lambda$0(this, arg_0));
        Intrinsics.checkNotNull(b);
        command2.build((ArgumentBuilder)b);
        LiteralArgumentBuilder v = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"world").requires(RtpWorldCommand::build$lambda$1)).then((ArgumentBuilder)b)).executes(arg_0 -> RtpWorldCommand.build$lambda$2(this, arg_0));
        ArgumentBuilder argumentBuilder = builder.then((ArgumentBuilder)v);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @Override
    public int execute(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = context.getArgument("world", Optional.class);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.Optional<org.bukkit.World>");
        Optional world = (Optional)object;
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            throw ExceptionConstants.INSTANCE.getBAD_SOURCE().create();
        }
        Player sender = player;
        World w = world.orElse(null);
        if (w == null) {
            PlayerUtil.sendParsed((CommandSender)sender, "messages.command.invalid_world", new TagResolver.Single[0]);
            return 1;
        }
        RtpCommand.Util.rtp(this.module, sender, w);
        return 1;
    }

    @Override
    public int usage(@NotNull CommandContext<CommandSourceStack> context) {
        Intrinsics.checkNotNullParameter(context, "context");
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Intrinsics.checkNotNull(sender);
        PlayerUtil.sendParsed(sender, "messages.usage.rtp_world", new TagResolver.Single[0]);
        return 1;
    }

    private static final int build$lambda$0(RtpWorldCommand this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(context, "context");
        return this$0.execute((CommandContext<CommandSourceStack>)context);
    }

    private static final boolean build$lambda$1(CommandSourceStack source) {
        CommandSourceStack commandSourceStack = source;
        Intrinsics.checkNotNull(commandSourceStack);
        String[] stringArray = new String[]{"nextrtp.command.world"};
        return Permissions.anyPermissions(commandSourceStack, stringArray);
    }

    private static final int build$lambda$2(RtpWorldCommand this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(context, "context");
        return this$0.usage((CommandContext<CommandSourceStack>)context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ<\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\r0\f\"\u0014\b\u0000\u0010\r*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\r0\fJ\u0016\u0010\u000f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lur/kryz/rtp/core/command/RtpWorldCommand$RtpWorldSudoCommand;", "Lur/kryz/rtp/core/command/paper/DisplayableUsage;", "module", "Lur/kryz/rtp/core/Core;", "<init>", "(Lur/kryz/rtp/core/Core;)V", "execute", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "build", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "T", "builder", "usage", "NextRTP"})
    private static final class RtpWorldSudoCommand
    implements DisplayableUsage {
        @NotNull
        private final Core module;

        public RtpWorldSudoCommand(@NotNull Core module) {
            Intrinsics.checkNotNullParameter(module, "module");
            this.module = module;
        }

        public final int execute(@NotNull CommandContext<CommandSourceStack> context) {
            Intrinsics.checkNotNullParameter(context, "context");
            Object object = context.getArgument("player", Optional.class);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.Optional<org.bukkit.entity.Player>");
            Optional opt = (Optional)object;
            Object object2 = context.getArgument("world", Optional.class);
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type java.util.Optional<org.bukkit.World>");
            Optional world = (Optional)object2;
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            World w = world.orElse(null);
            if (w == null) {
                Intrinsics.checkNotNull(sender);
                PlayerUtil.sendParsed(sender, "messages.command.invalid_world", new TagResolver.Single[0]);
                return 1;
            }
            Player player = opt.orElse(null);
            if (player == null) {
                Intrinsics.checkNotNull(sender);
                PlayerUtil.sendParsed(sender, "messages.command.invalid_player", new TagResolver.Single[0]);
                return 1;
            }
            RtpCommand.Util.rtp(this.module, player, w);
            return 1;
        }

        @NotNull
        public final <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> build(@NotNull ArgumentBuilder<CommandSourceStack, T> builder) {
            Intrinsics.checkNotNullParameter(builder, "builder");
            LiteralArgumentBuilder v = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sudo").requires(RtpWorldSudoCommand::build$lambda$0)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)Arguments.INSTANCE.optionalPlayer())).executes(arg_0 -> RtpWorldSudoCommand.build$lambda$1(this, arg_0)))).executes(arg_0 -> RtpWorldSudoCommand.build$lambda$2(this, arg_0));
            ArgumentBuilder argumentBuilder = builder.then((ArgumentBuilder)v);
            Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
            return argumentBuilder;
        }

        @Override
        public int usage(@NotNull CommandContext<CommandSourceStack> context) {
            Intrinsics.checkNotNullParameter(context, "context");
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            PlayerUtil.sendParsed(commandSender, "messages.usage.rtp_world_sudo", new TagResolver.Single[0]);
            return 1;
        }

        private static final boolean build$lambda$0(CommandSourceStack source) {
            Intrinsics.checkNotNullParameter(source, "source");
            String[] stringArray = new String[]{"nextrtp.command.world_sudo"};
            return Permissions.anyPermissions(source, stringArray);
        }

        private static final int build$lambda$1(RtpWorldSudoCommand this$0, CommandContext context) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(context, "context");
            return this$0.execute((CommandContext<CommandSourceStack>)context);
        }

        private static final int build$lambda$2(RtpWorldSudoCommand this$0, CommandContext context) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(context, "context");
            return this$0.usage((CommandContext<CommandSourceStack>)context);
        }
    }
}

