/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lur/kryz/rtp/core/manager/CooldownManager;", "", "cooldownSeconds", "", "<init>", "(I)V", "cooldowns", "", "Ljava/util/UUID;", "", "cooldownDurationMillis", "isOnCooldown", "", "player", "Lorg/bukkit/entity/Player;", "getTimeLeft", "applyCooldown", "", "clear", "NextRTP"})
public final class CooldownManager {
    @NotNull
    private final Map<UUID, Long> cooldowns = new HashMap();
    private final long cooldownDurationMillis;

    public CooldownManager(int cooldownSeconds) {
        this.cooldownDurationMillis = (long)cooldownSeconds * 1000L;
    }

    public final boolean isOnCooldown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        long now = System.currentTimeMillis();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return ((Number)this.cooldowns.getOrDefault(uUID, 0L)).longValue() > now;
    }

    public final long getTimeLeft(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        long now = System.currentTimeMillis();
        double d = 0.0;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        double d2 = ((Number)this.cooldowns.getOrDefault(uUID, 0L)).longValue() - now;
        return (long)Math.max(d, d2);
    }

    public final void applyCooldown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + this.cooldownDurationMillis);
    }

    public final void clear(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.cooldowns.remove(player.getUniqueId());
    }
}

