/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.manager;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.core.task.CyclicTaskScheduler;
import ur.kryz.rtp.file.FileManager;
import ur.kryz.rtp.hook.PlaceholderAPIHook;
import ur.kryz.rtp.libs.YamlDocument;
import ur.kryz.rtp.libs.block.implementation.Section;
import ur.kryz.rtp.parser.LegacyParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005%&'()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J1\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lur/kryz/rtp/core/manager/TitleAnimationManager;", "Ljava/lang/Runnable;", "<init>", "()V", "activeAnimations", "", "Ljava/util/UUID;", "Lur/kryz/rtp/core/manager/TitleAnimationManager$ActiveAnimation;", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "config", "Lur/kryz/rtp/libs/YamlDocument;", "reload", "", "set", "pluginInstance", "start", "player", "Lorg/bukkit/entity/Player;", "yaml", "loadAnimation", "T", "pathName", "", "delay", "", "factory", "Lur/kryz/rtp/core/manager/TitleAnimationManager$AnimationFactory;", "(Ljava/lang/String;ILur/kryz/rtp/core/manager/TitleAnimationManager$AnimationFactory;)Ljava/lang/Object;", "stop", "isAnimating", "", "setPlaceholders", "ins", "Lur/kryz/rtp/hook/PlaceholderAPIHook;", "frame", "run", "ActiveAnimation", "TitleAnimation", "SubTitleAnimation", "ActionBarAnimation", "AnimationFactory", "NextRTP"})
public final class TitleAnimationManager
implements Runnable {
    @NotNull
    public static final TitleAnimationManager INSTANCE = new TitleAnimationManager();
    @NotNull
    private static final Map<UUID, ActiveAnimation> activeAnimations = new HashMap();
    private static NextRTPPlugin plugin;
    private static YamlDocument config;

    private TitleAnimationManager() {
    }

    public final void reload() {
        YamlDocument yamlDocument = config;
        if (yamlDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            yamlDocument = null;
        }
        yamlDocument.reload();
    }

    public final void set(@NotNull NextRTPPlugin pluginInstance) {
        Intrinsics.checkNotNullParameter((Object)pluginInstance, "pluginInstance");
        plugin = pluginInstance;
        NextRTPPlugin nextRTPPlugin = plugin;
        if (nextRTPPlugin == null) {
            Intrinsics.throwUninitializedPropertyAccessException("plugin");
            nextRTPPlugin = null;
        }
        config = FileManager.load("animations.yml", nextRTPPlugin);
        CyclicTaskScheduler.Companion.register(this, 10L);
    }

    @JvmStatic
    public static final void start(@NotNull Player player, @NotNull YamlDocument yaml) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(yaml, "yaml");
        if (!yaml.getBoolean("titles.enabled", (Boolean)false).booleanValue()) {
            return;
        }
        if (!yaml.getBoolean("titles.delay.ui.enabled", (Boolean)false).booleanValue()) {
            return;
        }
        Section section = yaml.getSection("titles.delay.ui");
        if (section == null) {
            throw new NoSuchElementException("The path 'titles.delay.ui' was not found, please add it.");
        }
        Section path = section;
        Integer delay = yaml.getInt("teleport.delay", (Integer)5);
        String titleValue = path.getString("title", "");
        String subtitleValue = path.getString("subtitle", "");
        String actionbarValue = path.getString("actionbar", "");
        Intrinsics.checkNotNull(titleValue);
        Intrinsics.checkNotNull(delay);
        TitleAnimation title = INSTANCE.loadAnimation(titleValue, delay, TitleAnimationManager::start$lambda$0);
        Intrinsics.checkNotNull(subtitleValue);
        SubTitleAnimation subTitle = INSTANCE.loadAnimation(subtitleValue, delay, TitleAnimationManager::start$lambda$1);
        Intrinsics.checkNotNull(actionbarValue);
        ActionBarAnimation actionBar = INSTANCE.loadAnimation(actionbarValue, delay, TitleAnimationManager::start$lambda$2);
        activeAnimations.put(player.getUniqueId(), new ActiveAnimation(title, subTitle, actionBar));
    }

    private final <T> T loadAnimation(String pathName, int delay, AnimationFactory<T> factory) {
        YamlDocument yamlDocument = config;
        if (yamlDocument == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            yamlDocument = null;
        }
        if (yamlDocument.getSection("animations." + pathName) == null || StringsKt.isBlank(pathName)) {
            return factory.create(CollectionsKt.listOf(LegacyParser.parse(pathName)), delay * 1000);
        }
        YamlDocument yamlDocument2 = config;
        if (yamlDocument2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            yamlDocument2 = null;
        }
        Integer interval = yamlDocument2.getInt("animations." + pathName + ".interval");
        YamlDocument yamlDocument3 = config;
        if (yamlDocument3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            yamlDocument3 = null;
        }
        List<String> rawFrames = yamlDocument3.getStringList("animations." + pathName + ".value");
        List parsedFrames = new ArrayList();
        for (String frame : rawFrames) {
            Intrinsics.checkNotNull(frame);
            parsedFrames.add(LegacyParser.parse(frame));
        }
        Integer n = interval;
        Intrinsics.checkNotNull(n);
        return factory.create(parsedFrames, n);
    }

    @JvmStatic
    public static final void stop(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        activeAnimations.remove(player.getUniqueId());
    }

    public final boolean isAnimating(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return activeAnimations.containsKey(player.getUniqueId());
    }

    private final String setPlaceholders(PlaceholderAPIHook ins, Player player, String frame) {
        return ins.setPlaceholders(player, frame);
    }

    @Override
    public void run() {
        if (activeAnimations.isEmpty()) {
            return;
        }
        PlaceholderAPIHook instance = PlaceholderAPIHook.Companion.getInstance();
        long now = System.currentTimeMillis();
        List toRemove = new ArrayList();
        for (Map.Entry<UUID, ActiveAnimation> entry : activeAnimations.entrySet()) {
            String frame;
            UUID uuid = entry.getKey();
            ActiveAnimation anim = entry.getValue();
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) {
                toRemove.add(uuid);
                continue;
            }
            MiniMessage m = NextRTPPlugin.MINI_MESSAGE;
            boolean updateTitle = false;
            boolean updateSubtitle = false;
            if (anim.getTitle() != null && now - anim.getLastTitleUpdate() >= (long)anim.getTitle().interval()) {
                frame = anim.getTitle().frames().get(anim.getTitleIndex());
                anim.setTitleIndex((anim.getTitleIndex() + 1) % anim.getTitle().frames().size());
                anim.setLastTitleUpdate(now);
                anim.setLastTitle(m.deserialize((Object)this.setPlaceholders(instance, player, frame)));
                updateTitle = true;
            }
            if (anim.getSubTitle() != null && now - anim.getLastSubTitleUpdate() >= (long)anim.getSubTitle().interval()) {
                frame = anim.getSubTitle().frames().get(anim.getSubTitleIndex());
                anim.setSubTitleIndex((anim.getSubTitleIndex() + 1) % anim.getSubTitle().frames().size());
                anim.setLastSubTitleUpdate(now);
                anim.setLastSubtitle(m.deserialize((Object)this.setPlaceholders(instance, player, frame)));
                updateSubtitle = true;
            }
            if (updateTitle || updateSubtitle) {
                Title t;
                Title.Times time;
                int interval = anim.getTitle() != null ? anim.getTitle().interval() : (anim.getSubTitle() != null ? anim.getSubTitle().interval() : 1000);
                Intrinsics.checkNotNullExpressionValue(Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(interval + 80), (Duration)Duration.ofMillis(0L)), "times(...)");
                Intrinsics.checkNotNullExpressionValue(Title.title((Component)anim.getLastTitle(), (Component)anim.getLastSubtitle(), (Title.Times)time), "title(...)");
                player.showTitle(t);
            }
            if (anim.getActionBar() == null || now - anim.getLastActionBarUpdate() < (long)anim.getActionBar().interval()) continue;
            String frame2 = anim.getActionBar().frames().get(anim.getActionBarIndex());
            anim.setActionBarIndex((anim.getActionBarIndex() + 1) % anim.getActionBar().frames().size());
            anim.setLastActionBarUpdate(now);
            player.sendActionBar(m.deserialize((Object)this.setPlaceholders(instance, player, frame2)));
        }
        for (UUID uuid : toRemove) {
            activeAnimations.remove(uuid);
        }
    }

    private static final TitleAnimation start$lambda$0(List frames, int interval) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new TitleAnimation(frames, interval);
    }

    private static final SubTitleAnimation start$lambda$1(List frames, int interval) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new SubTitleAnimation(frames, interval);
    }

    private static final ActionBarAnimation start$lambda$2(List frames, int interval) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new ActionBarAnimation(frames, interval);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u0014"}, d2={"Lur/kryz/rtp/core/manager/TitleAnimationManager$ActionBarAnimation;", "Ljava/lang/Record;", "frames", "", "", "interval", "", "<init>", "(Ljava/util/List;I)V", "()Ljava/util/List;", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "NextRTP"})
    public static final class ActionBarAnimation
    extends Record {
        @NotNull
        private final List<String> frames;
        private final int interval;

        public ActionBarAnimation(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            this.frames = frames;
            this.interval = interval;
        }

        @NotNull
        public final List<String> frames() {
            return this.frames;
        }

        public final int interval() {
            return this.interval;
        }

        @NotNull
        public final List<String> component1() {
            return this.frames;
        }

        public final int component2() {
            return this.interval;
        }

        @NotNull
        public final ActionBarAnimation copy(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            return new ActionBarAnimation(frames, interval);
        }

        public static /* synthetic */ ActionBarAnimation copy$default(ActionBarAnimation actionBarAnimation, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = actionBarAnimation.frames;
            }
            if ((n2 & 2) != 0) {
                n = actionBarAnimation.interval;
            }
            return actionBarAnimation.copy(list, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "ActionBarAnimation(frames=" + this.frames + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.frames).hashCode();
            result = result * 31 + Integer.hashCode(this.interval);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActionBarAnimation)) {
                return false;
            }
            ActionBarAnimation actionBarAnimation = (ActionBarAnimation)other;
            if (!Intrinsics.areEqual(this.frames, actionBarAnimation.frames)) {
                return false;
            }
            return this.interval == actionBarAnimation.interval;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-\u00a8\u00061"}, d2={"Lur/kryz/rtp/core/manager/TitleAnimationManager$ActiveAnimation;", "", "title", "Lur/kryz/rtp/core/manager/TitleAnimationManager$TitleAnimation;", "subTitle", "Lur/kryz/rtp/core/manager/TitleAnimationManager$SubTitleAnimation;", "actionBar", "Lur/kryz/rtp/core/manager/TitleAnimationManager$ActionBarAnimation;", "<init>", "(Lur/kryz/rtp/core/manager/TitleAnimationManager$TitleAnimation;Lur/kryz/rtp/core/manager/TitleAnimationManager$SubTitleAnimation;Lur/kryz/rtp/core/manager/TitleAnimationManager$ActionBarAnimation;)V", "getTitle", "()Lur/kryz/rtp/core/manager/TitleAnimationManager$TitleAnimation;", "getSubTitle", "()Lur/kryz/rtp/core/manager/TitleAnimationManager$SubTitleAnimation;", "getActionBar", "()Lur/kryz/rtp/core/manager/TitleAnimationManager$ActionBarAnimation;", "lastTitleUpdate", "", "getLastTitleUpdate", "()J", "setLastTitleUpdate", "(J)V", "lastSubTitleUpdate", "getLastSubTitleUpdate", "setLastSubTitleUpdate", "lastActionBarUpdate", "getLastActionBarUpdate", "setLastActionBarUpdate", "titleIndex", "", "getTitleIndex", "()I", "setTitleIndex", "(I)V", "subTitleIndex", "getSubTitleIndex", "setSubTitleIndex", "actionBarIndex", "getActionBarIndex", "setActionBarIndex", "lastTitle", "Lnet/kyori/adventure/text/Component;", "getLastTitle", "()Lnet/kyori/adventure/text/Component;", "setLastTitle", "(Lnet/kyori/adventure/text/Component;)V", "lastSubtitle", "getLastSubtitle", "setLastSubtitle", "NextRTP"})
    public static final class ActiveAnimation {
        @Nullable
        private final TitleAnimation title;
        @Nullable
        private final SubTitleAnimation subTitle;
        @Nullable
        private final ActionBarAnimation actionBar;
        private long lastTitleUpdate;
        private long lastSubTitleUpdate;
        private long lastActionBarUpdate;
        private int titleIndex;
        private int subTitleIndex;
        private int actionBarIndex;
        @NotNull
        private Component lastTitle;
        @NotNull
        private Component lastSubtitle;

        public ActiveAnimation(@Nullable TitleAnimation title, @Nullable SubTitleAnimation subTitle, @Nullable ActionBarAnimation actionBar) {
            this.title = title;
            this.subTitle = subTitle;
            this.actionBar = actionBar;
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
            this.lastTitle = (Component)textComponent;
            TextComponent textComponent2 = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent2, "empty(...)");
            this.lastSubtitle = (Component)textComponent2;
        }

        @Nullable
        public final TitleAnimation getTitle() {
            return this.title;
        }

        @Nullable
        public final SubTitleAnimation getSubTitle() {
            return this.subTitle;
        }

        @Nullable
        public final ActionBarAnimation getActionBar() {
            return this.actionBar;
        }

        public final long getLastTitleUpdate() {
            return this.lastTitleUpdate;
        }

        public final void setLastTitleUpdate(long l) {
            this.lastTitleUpdate = l;
        }

        public final long getLastSubTitleUpdate() {
            return this.lastSubTitleUpdate;
        }

        public final void setLastSubTitleUpdate(long l) {
            this.lastSubTitleUpdate = l;
        }

        public final long getLastActionBarUpdate() {
            return this.lastActionBarUpdate;
        }

        public final void setLastActionBarUpdate(long l) {
            this.lastActionBarUpdate = l;
        }

        public final int getTitleIndex() {
            return this.titleIndex;
        }

        public final void setTitleIndex(int n) {
            this.titleIndex = n;
        }

        public final int getSubTitleIndex() {
            return this.subTitleIndex;
        }

        public final void setSubTitleIndex(int n) {
            this.subTitleIndex = n;
        }

        public final int getActionBarIndex() {
            return this.actionBarIndex;
        }

        public final void setActionBarIndex(int n) {
            this.actionBarIndex = n;
        }

        @NotNull
        public final Component getLastTitle() {
            return this.lastTitle;
        }

        public final void setLastTitle(@NotNull Component component) {
            Intrinsics.checkNotNullParameter(component, "<set-?>");
            this.lastTitle = component;
        }

        @NotNull
        public final Component getLastSubtitle() {
            return this.lastSubtitle;
        }

        public final void setLastSubtitle(@NotNull Component component) {
            Intrinsics.checkNotNullParameter(component, "<set-?>");
            this.lastSubtitle = component;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00e2\u0080\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J#\u0010\u0003\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lur/kryz/rtp/core/manager/TitleAnimationManager$AnimationFactory;", "T", "", "create", "frames", "", "", "interval", "", "(Ljava/util/List;I)Ljava/lang/Object;", "NextRTP"})
    private static interface AnimationFactory<T> {
        public T create(@NotNull List<String> var1, int var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u0014"}, d2={"Lur/kryz/rtp/core/manager/TitleAnimationManager$SubTitleAnimation;", "Ljava/lang/Record;", "frames", "", "", "interval", "", "<init>", "(Ljava/util/List;I)V", "()Ljava/util/List;", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "NextRTP"})
    public static final class SubTitleAnimation
    extends Record {
        @NotNull
        private final List<String> frames;
        private final int interval;

        public SubTitleAnimation(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            this.frames = frames;
            this.interval = interval;
        }

        @NotNull
        public final List<String> frames() {
            return this.frames;
        }

        public final int interval() {
            return this.interval;
        }

        @NotNull
        public final List<String> component1() {
            return this.frames;
        }

        public final int component2() {
            return this.interval;
        }

        @NotNull
        public final SubTitleAnimation copy(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            return new SubTitleAnimation(frames, interval);
        }

        public static /* synthetic */ SubTitleAnimation copy$default(SubTitleAnimation subTitleAnimation, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = subTitleAnimation.frames;
            }
            if ((n2 & 2) != 0) {
                n = subTitleAnimation.interval;
            }
            return subTitleAnimation.copy(list, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "SubTitleAnimation(frames=" + this.frames + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.frames).hashCode();
            result = result * 31 + Integer.hashCode(this.interval);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubTitleAnimation)) {
                return false;
            }
            SubTitleAnimation subTitleAnimation = (SubTitleAnimation)other;
            if (!Intrinsics.areEqual(this.frames, subTitleAnimation.frames)) {
                return false;
            }
            return this.interval == subTitleAnimation.interval;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u0014"}, d2={"Lur/kryz/rtp/core/manager/TitleAnimationManager$TitleAnimation;", "Ljava/lang/Record;", "frames", "", "", "interval", "", "<init>", "(Ljava/util/List;I)V", "()Ljava/util/List;", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "NextRTP"})
    public static final class TitleAnimation
    extends Record {
        @NotNull
        private final List<String> frames;
        private final int interval;

        public TitleAnimation(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            this.frames = frames;
            this.interval = interval;
        }

        @NotNull
        public final List<String> frames() {
            return this.frames;
        }

        public final int interval() {
            return this.interval;
        }

        @NotNull
        public final List<String> component1() {
            return this.frames;
        }

        public final int component2() {
            return this.interval;
        }

        @NotNull
        public final TitleAnimation copy(@NotNull List<String> frames, int interval) {
            Intrinsics.checkNotNullParameter(frames, "frames");
            return new TitleAnimation(frames, interval);
        }

        public static /* synthetic */ TitleAnimation copy$default(TitleAnimation titleAnimation, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = titleAnimation.frames;
            }
            if ((n2 & 2) != 0) {
                n = titleAnimation.interval;
            }
            return titleAnimation.copy(list, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "TitleAnimation(frames=" + this.frames + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.frames).hashCode();
            result = result * 31 + Integer.hashCode(this.interval);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TitleAnimation)) {
                return false;
            }
            TitleAnimation titleAnimation = (TitleAnimation)other;
            if (!Intrinsics.areEqual(this.frames, titleAnimation.frames)) {
                return false;
            }
            return this.interval == titleAnimation.interval;
        }
    }
}

