/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.task;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lur/kryz/rtp/core/task/CyclicTaskScheduler;", "", "tickMillis", "", "<init>", "(J)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "masterTask", "Ljava/lang/Runnable;", "start", "", "stop", "unregister", "id", "", "ScheduledRunnable", "Companion", "NextRTP"})
public final class CyclicTaskScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long tickMillis;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final Runnable masterTask;
    @NotNull
    private static final AtomicInteger idGenerator = new AtomicInteger();
    @NotNull
    private static final Map<Integer, ScheduledRunnable> tasks = new ConcurrentHashMap();

    public CyclicTaskScheduler(long tickMillis) {
        this.tickMillis = tickMillis;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "newSingleThreadScheduledExecutor(...)");
        this.executor = scheduledExecutorService;
        this.masterTask = CyclicTaskScheduler::masterTask$lambda$0;
    }

    public final void start() {
        this.executor.scheduleAtFixedRate(this.masterTask, 0L, this.tickMillis, TimeUnit.MILLISECONDS);
    }

    public final void stop() {
        this.executor.shutdownNow();
    }

    public final void unregister(int id) {
        tasks.remove(id);
    }

    private static final void masterTask$lambda$0() {
        long now = System.currentTimeMillis();
        Iterator<ScheduledRunnable> iterator2 = tasks.values().iterator();
        while (iterator2.hasNext()) {
            ScheduledRunnable runnable = iterator2.next();
            if (runnable.getIntervalMillis() == -1L) {
                try {
                    runnable.getRunnable().run();
                }
                catch (Exception t) {
                    t.printStackTrace();
                }
                iterator2.remove();
                continue;
            }
            if (now - runnable.getLastRun() < runnable.getIntervalMillis()) continue;
            try {
                runnable.getRunnable().run();
            }
            catch (Exception t) {
                t.printStackTrace();
            }
            runnable.setLastRun(now);
        }
    }

    @JvmStatic
    public static final int register(@NotNull Runnable task, long intervalMillis) {
        return Companion.register(task, intervalMillis);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lur/kryz/rtp/core/task/CyclicTaskScheduler$Companion;", "", "<init>", "()V", "idGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "tasks", "", "", "Lur/kryz/rtp/core/task/CyclicTaskScheduler$ScheduledRunnable;", "register", "task", "Ljava/lang/Runnable;", "intervalMillis", "", "NextRTP"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int register(@NotNull Runnable task, long intervalMillis) {
            Intrinsics.checkNotNullParameter(task, "task");
            int id = idGenerator.incrementAndGet();
            Integer n = id;
            tasks.put(n, new ScheduledRunnable(task, intervalMillis));
            return id;
        }

        public static /* synthetic */ int register$default(Companion companion, Runnable runnable, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = -1L;
            }
            return companion.register(runnable, l);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lur/kryz/rtp/core/task/CyclicTaskScheduler$ScheduledRunnable;", "", "runnable", "Ljava/lang/Runnable;", "intervalMillis", "", "<init>", "(Ljava/lang/Runnable;J)V", "getRunnable", "()Ljava/lang/Runnable;", "getIntervalMillis", "()J", "lastRun", "getLastRun", "setLastRun", "(J)V", "NextRTP"})
    private static final class ScheduledRunnable {
        @NotNull
        private final Runnable runnable;
        private final long intervalMillis;
        private volatile long lastRun;

        public ScheduledRunnable(@NotNull Runnable runnable, long intervalMillis) {
            Intrinsics.checkNotNullParameter(runnable, "runnable");
            this.runnable = runnable;
            this.intervalMillis = intervalMillis;
        }

        @NotNull
        public final Runnable getRunnable() {
            return this.runnable;
        }

        public final long getIntervalMillis() {
            return this.intervalMillis;
        }

        public final long getLastRun() {
            return this.lastRun;
        }

        public final void setLastRun(long l) {
            this.lastRun = l;
        }
    }
}

